/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.AqueductBlock;
import com.yanny.ytech.configuration.block_entity.IrrigationBlockEntity;
import com.yanny.ytech.network.irrigation.NetworkType;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class AqueductBlockEntity
extends IrrigationBlockEntity {
    public static final String TAG_CAPACITY = "capacity";
    private int capacity;

    public AqueductBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        this(pos, blockState, 0);
    }

    public AqueductBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState, int capacity) {
        super((BlockEntityType<? extends BlockEntity>)((BlockEntityType)YTechBlockEntityTypes.AQUEDUCT.get()), pos, blockState, ((AqueductBlock)blockState.getBlock()).getValidNeighbors(blockState, pos));
        this.capacity = capacity;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public NetworkType getNetworkType() {
        return NetworkType.STORAGE;
    }

    @Override
    public boolean validForRainFilling() {
        if (this.level instanceof ServerLevel) {
            Holder biome = this.level.getBiome(this.worldPosition);
            return !YTechMod.CONFIGURATION.isValidBlockForRaining() || this.level.canSeeSky(this.worldPosition.above()) && ((Biome)biome.value()).getPrecipitationAt(this.worldPosition) == Biome.Precipitation.RAIN;
        }
        return false;
    }

    @Override
    public boolean validForDripping() {
        ServerLevel serverLevel;
        BlockPos pos;
        Level level = this.level;
        if (level instanceof ServerLevel && (pos = PointedDripstoneBlock.findStalactiteTipAboveCauldron((Level)(serverLevel = (ServerLevel)level), (BlockPos)this.worldPosition)) != null) {
            Fluid fluid = PointedDripstoneBlock.getCauldronFillFluidType((ServerLevel)serverLevel, (BlockPos)pos);
            return fluid != Fluids.EMPTY && fluid.isSame((Fluid)Fluids.WATER);
        }
        return false;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.capacity = tag.getInt(TAG_CAPACITY);
    }

    public void onRandomTick() {
        YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt(TAG_CAPACITY, this.capacity);
    }
}

