/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.block_entity.AbstractPrimitiveMachineBlockEntity;
import com.yanny.ytech.configuration.container.PrimitiveSmelterContainerMenu;
import com.yanny.ytech.configuration.recipe.SmeltingRecipe;
import com.yanny.ytech.configuration.recipe.YTechRecipeInput;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimitiveSmelterBlockEntity
extends AbstractPrimitiveMachineBlockEntity {
    private static final String TAG_RECIPE_INPUT = "recipeInput";
    private static final String TAG_RECIPE_MOLD = "recipeMold";
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_FUEL = 1;
    private static final int SLOT_MOLD = 2;
    private static final int SLOT_OUTPUT = 3;
    private final RecipeManager.CachedCheck<RecipeInput, SmeltingRecipe> quickCheck;
    @Nullable
    private ItemStack recipeInput = ItemStack.EMPTY;
    @Nullable
    private ItemStack recipeMold = ItemStack.EMPTY;

    public PrimitiveSmelterBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.PRIMITIVE_SMELTER.get(), pos, blockState, (RecipeType)YTechRecipeTypes.SMELTING.get());
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)YTechRecipeTypes.SMELTING.get()));
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.ytech.primitive_smelter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory inventory, @NotNull Player player) {
        return new PrimitiveSmelterContainerMenu(windowId, inventory.player, this.worldPosition, this.itemStackHandler, this.containerData);
    }

    @Override
    @NotNull
    public MachineItemStackHandler createItemStackHandler() {
        return new MachineItemStackHandler.Builder().addInputSlot(55, 16).addInputSlot(55, 52, (itemStackHandler, slot, itemStack) -> itemStack.getBurnTime(RecipeType.BLASTING) > 0).addInputSlot(88, 52, (itemStackHandler, slot, itemStack) -> itemStack.is(YTechItemTags.CLAY_MOLDS.tag) || itemStack.is(YTechItemTags.SAND_MOLDS.tag)).addOutputSlot(116, 35).setOnChangeListener(() -> ((PrimitiveSmelterBlockEntity)this).setChanged()).build();
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (this.level == null || !this.level.isClientSide) {
            this.recipeInput = tag.contains(TAG_RECIPE_INPUT) ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_RECIPE_INPUT)) : null;
            this.recipeMold = tag.contains(TAG_RECIPE_MOLD) ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_RECIPE_MOLD)) : null;
        }
    }

    @Override
    public boolean hasActiveRecipe() {
        return this.recipeInput != null;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.level == null || !this.level.isClientSide) {
            if (this.recipeInput != null) {
                tag.put(TAG_RECIPE_INPUT, this.recipeInput.save(provider));
            }
            if (this.recipeMold != null) {
                CompoundTag itemStack = new CompoundTag();
                this.recipeMold.save(provider, (Tag)itemStack);
                tag.put(TAG_RECIPE_MOLD, (Tag)itemStack);
            }
        }
    }

    @Override
    protected boolean hasItemsInInput() {
        return !this.itemStackHandler.getStackInSlot(0).isEmpty();
    }

    @Override
    protected int getFuelSlot() {
        return 1;
    }

    @Override
    protected void startRecipe(@NotNull AtomicBoolean hasChanged) {
        if (this.level != null) {
            ItemStack input = this.itemStackHandler.getStackInSlot(0);
            ItemStack mold = this.itemStackHandler.getStackInSlot(2);
            this.quickCheck.getRecipeFor((RecipeInput)new YTechRecipeInput(input, mold), this.level).ifPresent(recipe -> {
                ItemStack result = this.itemStackHandler.getStackInSlot(3);
                SmeltingRecipe r = (SmeltingRecipe)recipe.value();
                if (r.minTemperature() <= this.temperature && (result.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)r.result()) && result.getMaxStackSize() > result.getCount())) {
                    Level patt0$temp;
                    this.recipeInput = input.split(r.inputCount());
                    this.recipeMold = mold.copy();
                    this.leftSmelting = this.smeltingTime = r.smeltingTime();
                    this.recipeTemperature = r.minTemperature();
                    hasChanged.set(true);
                    if (!r.mold().isEmpty() && (patt0$temp = this.level) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt0$temp;
                        mold.hurtAndBreak(1, serverLevel, null, item -> {});
                    }
                }
            });
        }
    }

    @Override
    protected void finishRecipe() {
        if (this.level != null && this.recipeInput != null) {
            ItemStack result = this.itemStackHandler.getStackInSlot(3);
            this.quickCheck.getRecipeFor((RecipeInput)new YTechRecipeInput(this.recipeInput, this.recipeMold), this.level).ifPresent(r -> {
                if (result.isEmpty()) {
                    this.itemStackHandler.setStackInSlot(3, ((SmeltingRecipe)r.value()).result().copy());
                } else {
                    result.grow(1);
                }
            });
            this.recipeInput = null;
            this.recipeMold = null;
        }
    }

    @Override
    protected boolean isValidRecipeInInput() {
        if (this.level != null) {
            ItemStack itemStack = this.itemStackHandler.getStackInSlot(0);
            ItemStack mold = this.itemStackHandler.getStackInSlot(2);
            return this.quickCheck.getRecipeFor((RecipeInput)new YTechRecipeInput(itemStack, mold), this.level).isPresent();
        }
        return false;
    }
}

