/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.container;

import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.block_entity.AqueductFertilizerBlockEntity;
import com.yanny.ytech.configuration.container.Utils;
import com.yanny.ytech.registration.YTechMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class AqueductFertilizerMenu
extends AbstractContainerMenu {
    protected final BlockPos pos;
    @NotNull
    protected final ItemStackHandler itemStackHandler;
    @NotNull
    protected final AqueductFertilizerBlockEntity blockEntity;
    @NotNull
    protected final ContainerData containerData;
    private final int inputSlots;

    public AqueductFertilizerMenu(int windowId, @NotNull Player player, @NotNull BlockPos pos, @NotNull MachineItemStackHandler itemStackHandler, @NotNull ContainerData data) {
        super((MenuType)YTechMenuTypes.AQUEDUCT_FERTILIZER.get(), windowId);
        this.pos = pos;
        this.containerData = data;
        this.blockEntity = AqueductFertilizerMenu.getAqueductFertilizerBlockEntity(player, pos);
        this.itemStackHandler = itemStackHandler;
        this.inputSlots = itemStackHandler.getInputSlots();
        for (int index = 0; index < itemStackHandler.getSlots(); ++index) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemStackHandler, index, itemStackHandler.getX(index), itemStackHandler.getY(index)));
        }
        Utils.layoutPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), (Container)player.getInventory(), 8, 84);
        this.addDataSlots(data);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        int slotCount = this.itemStackHandler.getSlots();
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (index < slotCount && !this.moveItemStackTo(stack, slotCount, 36 + slotCount, true)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(stack, 0, this.inputSlots, false) && (index < 27 + slotCount ? !this.moveItemStackTo(stack, 27 + slotCount, 36 + slotCount, false) : index < 36 + slotCount && !this.moveItemStackTo(stack, slotCount, 27 + slotCount, false))) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return itemstack;
    }

    public boolean stillValid(@NotNull Player player) {
        return AqueductFertilizerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.pos), (Player)player, (Block)player.level().getBlockState(this.pos).getBlock());
    }

    @NotNull
    public AqueductFertilizerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public static AqueductFertilizerBlockEntity getAqueductFertilizerBlockEntity(@NotNull Player player, @NotNull BlockPos pos) {
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AqueductFertilizerBlockEntity) {
            AqueductFertilizerBlockEntity entity = (AqueductFertilizerBlockEntity)blockEntity;
            return entity;
        }
        throw new IllegalArgumentException("BlockEntity is not instanceof MachineBlockEntity");
    }
}

