/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yanny.ytech.configuration.SpearType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SpearModel
extends Model {
    public static final Map<SpearType, ModelLayerLocation> LAYER_LOCATIONS = new HashMap<SpearType, ModelLayerLocation>();
    public static final Map<SpearType, ModelResourceLocation> MODEL_LOCATIONS = new HashMap<SpearType, ModelResourceLocation>();
    public static final Map<SpearType, ModelResourceLocation> MODEL_IN_HAND_LOCATIONS = new HashMap<SpearType, ModelResourceLocation>();
    @NotNull
    private final ModelPart root;

    public SpearModel(@NotNull ModelPart root) {
        super(RenderType::entitySolid);
        this.root = root;
    }

    @NotNull
    public static LayerDefinition createLayer(int xOffset, int yOffset) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition rootPart = meshDefinition.getRoot();
        PartDefinition polePart = rootPart.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 25.0f, 1.0f), PartPose.ZERO);
        polePart.addOrReplaceChild("base", CubeListBuilder.create().texOffs(4 + xOffset, yOffset).addBox(-1.5f, -1.0f, -0.5f, 3.0f, 1.0f, 1.0f), PartPose.ZERO);
        polePart.addOrReplaceChild("tip", CubeListBuilder.create().texOffs(4 + xOffset, 2 + yOffset).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 1.0f, 1.0f), PartPose.ZERO);
        polePart.addOrReplaceChild("k", CubeListBuilder.create().texOffs(4 + xOffset, 4 + yOffset).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    static {
        for (SpearType type : SpearType.values()) {
            String key = Utils.getPath((DeferredHolder)YTechItems.SPEARS.get(type.materialType));
            LAYER_LOCATIONS.put(type, new ModelLayerLocation(Utils.modLoc(key), "main"));
            MODEL_LOCATIONS.put(type, ModelResourceLocation.inventory((ResourceLocation)Utils.modLoc(key)));
            MODEL_IN_HAND_LOCATIONS.put(type, ModelResourceLocation.standalone((ResourceLocation)Utils.modItemLoc(key + "_in_hand")));
        }
    }
}

