/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.entity.TerrorBirdEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TerrorBirdModel
extends EntityModel<TerrorBirdEntity> {
    @NotNull
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Utils.modLoc("terror_bird"), "main");
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart l_foot;
    @NotNull
    private final ModelPart r_foot;

    public TerrorBirdModel(@NotNull ModelPart root) {
        super(RenderType::entityCutoutNoCull);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.l_foot = root.getChild("l_foot");
        this.r_foot = root.getChild("r_foot");
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packetLight, int packetOverlay, int color) {
        this.parts().forEach(modelPart -> modelPart.render(poseStack, vertexConsumer, packetLight, packetOverlay, color));
    }

    public void setupAnim(@NotNull TerrorBirdEntity entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.r_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.l_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
    }

    @NotNull
    private Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.l_foot, (Object)this.r_foot);
    }

    @NotNull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -19.0f, -6.0f, 10.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("l_foot", CubeListBuilder.create().texOffs(0, 0).addBox(1.5f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(1.0f, 9.0f, -3.0f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("r_foot", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(-4.0f, 9.0f, -3.0f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)10.0f, (float)-4.0f));
        head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 21).addBox(-3.0f, -4.0f, -8.0f, 6.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)-4.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(48, 0).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-2.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

