/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemainingShapedRecipe
extends ShapedRecipe {
    public RemainingShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
    }

    public RemainingShapedRecipe(ShapedRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), recipe.pattern, recipe.getResultItem(null), recipe.showNotification());
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput container) {
        NonNullList list = NonNullList.withSize((int)container.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = container.getItem(i);
            if (item.hasCraftingRemainingItem()) {
                list.set(i, (Object)item.getCraftingRemainingItem());
                continue;
            }
            if (!item.isDamageableItem()) continue;
            ItemStack result = item.copy();
            list.set(i, (Object)result);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) continue;
            result.hurtAndBreak(1, server.overworld(), null, it -> {});
        }
        return list;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)YTechRecipeSerializers.REMAINING_SHAPED.get();
    }

    public static class Builder
    extends ShapedRecipeBuilder {
        public Builder(RecipeCategory pCategory, ItemLike pResult, int pCount) {
            super(pCategory, pResult, pCount);
        }

        public static Builder shaped(@NotNull RecipeCategory pCategory, ItemLike pResult) {
            return Builder.shaped(pCategory, pResult, 1);
        }

        public static Builder shaped(@NotNull RecipeCategory pCategory, ItemLike pResult, int pCount) {
            return new Builder(pCategory, pResult, pCount);
        }

        public void save(final @NotNull RecipeOutput consumer, @NotNull ResourceLocation id) {
            super.save(new RecipeOutput(){

                @NotNull
                public Advancement.Builder advancement() {
                    return consumer.advancement();
                }

                public void accept(@NotNull ResourceLocation id, @NotNull Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder, ICondition ... iConditions) {
                    consumer.accept(id, (Recipe)new RemainingShapedRecipe((ShapedRecipe)recipe), advancementHolder);
                }
            }, id);
        }
    }

    public static class Serializer
    implements RecipeSerializer<RemainingShapedRecipe> {
        private static final MapCodec<RemainingShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_311730_ -> p_311730_.getResultItem(null)), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(ShapedRecipe::showNotification)).apply((Applicative)instance, RemainingShapedRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, RemainingShapedRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<RemainingShapedRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, RemainingShapedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        private static RemainingShapedRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf friendlyByteBuf) {
            return new RemainingShapedRecipe(ShapedRecipe.Serializer.fromNetwork((RegistryFriendlyByteBuf)friendlyByteBuf));
        }

        private static void toNetwork(@NotNull RegistryFriendlyByteBuf buf, @NotNull RemainingShapedRecipe recipe) {
            ShapedRecipe.Serializer.toNetwork((RegistryFriendlyByteBuf)buf, (ShapedRecipe)recipe);
        }
    }
}

