/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SmeltingRecipe(Ingredient ingredient, int inputCount, Ingredient mold, int minTemperature, int smeltingTime, ItemStack result) implements Recipe<RecipeInput>
{
    public boolean matches(@NotNull RecipeInput recipeInput, @NotNull Level level) {
        return this.ingredient.test(recipeInput.getItem(0)) && recipeInput.getItem(0).getCount() >= this.inputCount && (this.mold.isEmpty() || this.mold.test(recipeInput.getItem(1)));
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput recipeInput, @NotNull HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)YTechRecipeSerializers.SMELTING.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)YTechRecipeTypes.SMELTING.get();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.ingredient, this.mold});
    }

    public static class Builder
    implements RecipeBuilder {
        private final Ingredient ingredient;
        private final int inputCount;
        private final Ingredient mold;
        private final int minTemperature;
        private final int smeltingTime;
        private final Item result;
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        Builder(@NotNull Ingredient ingredient, int inputCount, @NotNull Ingredient mold, int minTemperature, int smeltingTime, @NotNull Item result) {
            this.ingredient = ingredient;
            this.inputCount = inputCount;
            this.mold = mold;
            this.minTemperature = minTemperature;
            this.smeltingTime = smeltingTime;
            this.result = result;
        }

        public static Builder smelting(@NotNull TagKey<Item> input, int inputCount, @NotNull TagKey<Item> mold, int minTemperature, int smeltingTime, @NotNull Item result) {
            return new Builder(Ingredient.of(input), inputCount, Ingredient.of(mold), minTemperature, smeltingTime, result);
        }

        public static Builder smelting(@NotNull TagKey<Item> input, int minTemperature, int smeltingTime, @NotNull Item result) {
            return new Builder(Ingredient.of(input), 1, Ingredient.EMPTY, minTemperature, smeltingTime, result);
        }

        public static Builder smelting(@NotNull ItemLike input, int inputCount, @NotNull TagKey<Item> mold, int minTemperature, int smeltingTime, @NotNull Item result) {
            return new Builder(Ingredient.of((ItemLike[])new ItemLike[]{input}), inputCount, Ingredient.of(mold), minTemperature, smeltingTime, result);
        }

        @NotNull
        public RecipeBuilder unlockedBy(@NotNull String criterionName, @NotNull Criterion criterionTrigger) {
            this.criteria.put(criterionName, criterionTrigger);
            return this;
        }

        @NotNull
        public RecipeBuilder group(@Nullable String groupName) {
            return this;
        }

        @NotNull
        public Item getResult() {
            return this.result;
        }

        public void save(@NotNull RecipeOutput finishedRecipeConsumer, @NotNull ResourceLocation recipeId) {
            this.ensureValid(recipeId);
            Advancement.Builder builder = finishedRecipeConsumer.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            finishedRecipeConsumer.accept(recipeId, (Recipe)new SmeltingRecipe(this.ingredient, this.inputCount, this.mold, this.minTemperature, this.smeltingTime, new ItemStack((ItemLike)this.result)), builder.build(recipeId.withPrefix("recipes/smelting/")));
        }

        private void ensureValid(@NotNull ResourceLocation id) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<SmeltingRecipe> {
        private static final MapCodec<SmeltingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(smeltingRecipe -> smeltingRecipe.ingredient), (App)Codec.INT.fieldOf("inputCount").forGetter(smeltingRecipe -> smeltingRecipe.inputCount), (App)Ingredient.CODEC.fieldOf("mold").forGetter(smeltingRecipe -> smeltingRecipe.mold), (App)Codec.INT.fieldOf("minTemp").forGetter(smeltingRecipe -> smeltingRecipe.minTemperature), (App)Codec.INT.fieldOf("smeltingTime").forGetter(smeltingRecipe -> smeltingRecipe.smeltingTime), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(smeltingRecipe -> smeltingRecipe.result)).apply((Applicative)instance, SmeltingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SmeltingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<SmeltingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SmeltingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        private static SmeltingRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int inputCount = buffer.readInt();
            Ingredient mold = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int minTemperature = buffer.readInt();
            int dryingTime = buffer.readInt();
            return new SmeltingRecipe(ingredient, inputCount, mold, minTemperature, dryingTime, result);
        }

        private static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, @NotNull SmeltingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeInt(recipe.inputCount);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.mold);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeInt(recipe.minTemperature);
            buffer.writeInt(recipe.smeltingTime);
        }
    }
}

