/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yanny.ytech.configuration.recipe.YTechRecipeInput;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TanningRecipe(Ingredient ingredient, Ingredient tool, int hitCount, ItemStack result) implements Recipe<YTechRecipeInput>
{
    public boolean matches(@NotNull YTechRecipeInput recipeInput, @NotNull Level level) {
        return this.ingredient.test(recipeInput.getItem(0)) && (recipeInput.size() == 1 || this.tool.test(recipeInput.getItem(1)));
    }

    @NotNull
    public ItemStack assemble(@NotNull YTechRecipeInput recipeInput, @NotNull HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)YTechRecipeSerializers.TANNING.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)YTechRecipeTypes.TANNING.get();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.ingredient, this.tool});
    }

    public static class Builder
    implements RecipeBuilder {
        private final Ingredient ingredient;
        private Ingredient tool = Ingredient.EMPTY;
        private final int hitCount;
        private final Item result;
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        Builder(@NotNull Ingredient ingredient, int hitCount, @NotNull Item result) {
            this.ingredient = ingredient;
            this.hitCount = hitCount;
            this.result = result;
        }

        public static Builder tanning(@NotNull TagKey<Item> input, int hitCount, @NotNull Item result) {
            return new Builder(Ingredient.of(input), hitCount, result);
        }

        public Builder tool(@NotNull Ingredient tool) {
            this.tool = tool;
            return this;
        }

        @NotNull
        public Builder unlockedBy(@NotNull String criterionName, @NotNull Criterion criterionTrigger) {
            this.criteria.put(criterionName, criterionTrigger);
            return this;
        }

        @NotNull
        public Builder group(@Nullable String groupName) {
            return this;
        }

        @NotNull
        public Item getResult() {
            return this.result;
        }

        public void save(@NotNull RecipeOutput finishedRecipeConsumer, @NotNull ResourceLocation recipeId) {
            this.ensureValid(recipeId);
            Advancement.Builder builder = finishedRecipeConsumer.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            finishedRecipeConsumer.accept(recipeId, (Recipe)new TanningRecipe(this.ingredient, this.tool, this.hitCount, new ItemStack((ItemLike)this.result)), builder.build(recipeId.withPrefix("recipes/tanning/")));
        }

        private void ensureValid(@NotNull ResourceLocation id) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<TanningRecipe> {
        private static final MapCodec<TanningRecipe> CODEC = RecordCodecBuilder.mapCodec(recipe -> recipe.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(tanningRecipe -> tanningRecipe.ingredient), (App)Ingredient.CODEC.fieldOf("tool").forGetter(tanningRecipe -> tanningRecipe.tool), (App)Codec.INT.fieldOf("hitCount").forGetter(tanningRecipe -> tanningRecipe.hitCount), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(tanningRecipe -> tanningRecipe.result)).apply((Applicative)recipe, TanningRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, TanningRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<TanningRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, TanningRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        private static TanningRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient tool = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int hitCount = buffer.readInt();
            return new TanningRecipe(ingredient, tool, hitCount, result);
        }

        private static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, @NotNull TanningRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.tool);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeInt(recipe.hitCount);
        }
    }
}

