/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ytech.configuration.block_entity.BronzeAnvilBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BronzeAnvilRenderer
implements BlockEntityRenderer<BronzeAnvilBlockEntity> {
    private final ItemRenderer itemRenderer;

    public BronzeAnvilRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(@NotNull BronzeAnvilBlockEntity anvil, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemStack input;
        BlockState blockState = anvil.getBlockState();
        Direction facing = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Level level = anvil.getLevel();
        poseStack.pushPose();
        poseStack.rotateAround(facing.getRotation(), 0.5f, 0.5f, 0.5f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(1.0f, 1.0f, 0.0f);
        if (level != null && !(input = anvil.getItem()).isEmpty()) {
            BakedModel bakedmodel = this.itemRenderer.getModel(input, level, null, 0);
            this.itemRenderer.render(input, ItemDisplayContext.FIXED, false, poseStack, buffer, packedLight, packedOverlay, bakedmodel);
            if (input.getCount() > 1) {
                poseStack.pushPose();
                poseStack.translate(-0.1f, -0.1f, -0.02f);
                this.itemRenderer.render(input, ItemDisplayContext.FIXED, false, poseStack, buffer, packedLight, packedOverlay, bakedmodel);
                poseStack.popPose();
            }
        }
        poseStack.popPose();
    }
}

