/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import com.yanny.ytech.configuration.block_entity.CraftingWorkspaceBlockEntity;
import com.yanny.ytech.configuration.renderer.FakeCraftingWorkspaceLevel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public class CraftingWorkspaceRenderer
implements BlockEntityRenderer<CraftingWorkspaceBlockEntity> {
    private static final FakeCraftingWorkspaceLevel FAKE_LEVEL;
    private TextureAtlasSprite sprite;
    private float r;
    private float g;
    private float b;
    private float a;
    private float minU;
    private float minV;
    private float maxU;
    private float maxV;

    public CraftingWorkspaceRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull CraftingWorkspaceBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        poseStack.pushPose();
        poseStack.scale(0.33333334f, 0.33333334f, 0.33333334f);
        if (level != null) {
            int bitmask = blockEntity.getBitmask();
            int i = 0;
            NonNullList<ItemStack> items = blockEntity.getItems();
            NonNullList<BlockState> states = blockEntity.getBlockStates();
            FAKE_LEVEL.setData(blockEntity.getBlockPos(), level, items, states);
            ModelBlockRenderer.enableCaching();
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    for (int x = 0; x < 3; ++x) {
                        if ((bitmask >> i & 1) == 1) {
                            int[] position = CraftingWorkspaceBlock.getPosition(i);
                            ItemStack itemStack = (ItemStack)items.get(i);
                            BlockState state = (BlockState)states.get(i);
                            if (position == null || itemStack.isEmpty()) {
                                ++i;
                                continue;
                            }
                            poseStack.pushPose();
                            poseStack.translate((float)x, (float)y, (float)z);
                            if (itemStack.getItem() instanceof BlockItem) {
                                BlockPos pos = new BlockPos(x + 1, y + 1, z + 1);
                                BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
                                for (RenderType renderType : model.getRenderTypes(state, RandomSource.create((long)state.getSeed(pos)), ModelData.EMPTY)) {
                                    VertexConsumer vertexConsumer = buffer.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType));
                                    Minecraft.getInstance().getBlockRenderer().getModelRenderer().tesselateBlock((BlockAndTintGetter)FAKE_LEVEL, model, state, pos, poseStack, vertexConsumer, true, RandomSource.create(), state.getSeed(pos), packedOverlay, ModelData.EMPTY, renderType);
                                }
                            } else {
                                poseStack.translate(0.5, 0.5, 0.5);
                                poseStack.pushPose();
                                poseStack.rotateAround(Axis.YN.rotationDegrees((float)(level.getGameTime() % 360L)), 0.0f, 0.0f, 0.0f);
                                ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                                BakedModel bakedmodel = itemRenderer.getModel(itemStack, level, null, 0);
                                itemRenderer.render(itemStack, ItemDisplayContext.FIXED, false, poseStack, buffer, packedLight, packedOverlay, bakedmodel);
                                poseStack.popPose();
                            }
                            poseStack.popPose();
                        }
                        ++i;
                    }
                }
            }
            FAKE_LEVEL.clearData();
            ModelBlockRenderer.clearCache();
        }
        poseStack.popPose();
    }

    static {
        ObjenesisStd objenesis = new ObjenesisStd();
        ObjectInstantiator instantiator = objenesis.getInstantiatorOf(FakeCraftingWorkspaceLevel.class);
        FAKE_LEVEL = (FakeCraftingWorkspaceLevel)((Object)instantiator.newInstance());
        FAKE_LEVEL.init();
    }
}

