/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yanny.ytech.configuration.block_entity.MillstoneBlockEntity;
import com.yanny.ytech.configuration.entity.GoAroundEntity;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class GoAroundRenderer
extends MobRenderer<GoAroundEntity, CowModel<GoAroundEntity>> {
    private static final ResourceLocation COW_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/cow/cow.png");

    public GoAroundRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, (EntityModel)new CowModel(pContext.bakeLayer(ModelLayers.COW)), 0.1f);
    }

    public void render(@NotNull GoAroundEntity pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        MillstoneBlockEntity leashEntity = pEntity.getDevice();
        Mob entity = (Mob)pEntity.getVehicle();
        if (leashEntity != null && entity != null) {
            double offset = pEntity.getY() - entity.getY();
            this.renderLeash2(entity, offset, pPartialTicks, pPoseStack, pBuffer, leashEntity);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GoAroundEntity mimicEntity) {
        return COW_LOCATION;
    }

    public void renderLeash2(Mob pEntityLiving, double offset, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, BlockEntity pLeashHolder) {
        int $$29;
        pPoseStack.pushPose();
        Vec3 $$5 = pLeashHolder.getBlockPos().getCenter().add(0.0, 0.2, 0.0);
        double $$6 = (double)(Mth.lerp((float)pPartialTicks, (float)pEntityLiving.yBodyRotO, (float)pEntityLiving.yBodyRot) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 $$7 = pEntityLiving.getLeashOffset(pPartialTicks);
        double $$8 = Math.cos($$6) * $$7.z + Math.sin($$6) * $$7.x;
        double $$9 = Math.sin($$6) * $$7.z - Math.cos($$6) * $$7.x;
        double $$10 = Mth.lerp((double)pPartialTicks, (double)pEntityLiving.xo, (double)pEntityLiving.getX()) + $$8;
        double $$11 = Mth.lerp((double)pPartialTicks, (double)pEntityLiving.yo, (double)pEntityLiving.getY()) + $$7.y;
        double $$12 = Mth.lerp((double)pPartialTicks, (double)pEntityLiving.zo, (double)pEntityLiving.getZ()) + $$9;
        pPoseStack.translate($$8, $$7.y - offset, $$9);
        float $$13 = (float)($$5.x - $$10);
        float $$14 = (float)($$5.y - $$11);
        float $$15 = (float)($$5.z - $$12);
        float $$16 = 0.025f;
        VertexConsumer $$17 = pBuffer.getBuffer(RenderType.leash());
        Matrix4f $$18 = pPoseStack.last().pose();
        float $$19 = Mth.invSqrt((float)($$13 * $$13 + $$15 * $$15)) * $$16 / 2.0f;
        float $$20 = $$15 * $$19;
        float $$21 = $$13 * $$19;
        BlockPos $$22 = BlockPos.containing((Position)pEntityLiving.getEyePosition(pPartialTicks));
        BlockPos $$23 = pLeashHolder.getBlockPos();
        int $$24 = this.getBlockLightLevel2((Entity)pEntityLiving, $$22);
        int $$25 = this.getBlockLightLevel2((Entity)pEntityLiving, $$23);
        int $$26 = pEntityLiving.level().getBrightness(LightLayer.SKY, $$22);
        int $$27 = pEntityLiving.level().getBrightness(LightLayer.SKY, $$23);
        for ($$29 = 0; $$29 <= 24; ++$$29) {
            GoAroundRenderer.addVertexPair((VertexConsumer)$$17, (Matrix4f)$$18, (float)$$13, (float)$$14, (float)$$15, (int)$$24, (int)$$25, (int)$$26, (int)$$27, (float)$$16, (float)$$16, (float)$$20, (float)$$21, (int)$$29, (boolean)false);
        }
        for ($$29 = 24; $$29 >= 0; --$$29) {
            GoAroundRenderer.addVertexPair((VertexConsumer)$$17, (Matrix4f)$$18, (float)$$13, (float)$$14, (float)$$15, (int)$$24, (int)$$25, (int)$$26, (int)$$27, (float)$$16, (float)0.0f, (float)$$20, (float)$$21, (int)$$29, (boolean)true);
        }
        pPoseStack.popPose();
    }

    private int getBlockLightLevel2(Entity pEntity, BlockPos pPos) {
        return pEntity.isOnFire() ? 15 : pEntity.level().getBrightness(LightLayer.BLOCK, pPos);
    }
}

