/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.yanny.ytech.configuration.SpearType;
import com.yanny.ytech.configuration.entity.SpearEntity;
import com.yanny.ytech.configuration.model.SpearModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SpearRenderer
extends EntityRenderer<SpearEntity> {
    private final SpearModel model;

    public SpearRenderer(@NotNull EntityRendererProvider.Context context, ModelLayerLocation layerLocation) {
        super(context);
        this.model = new SpearModel(context.bakeLayer(layerLocation));
    }

    public void render(@NotNull SpearEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot()) + 90.0f));
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(this.getTextureLocation(entity)), (boolean)false, (boolean)entity.isFoil());
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull SpearEntity entity) {
        return SpearType.TEXTURE_LOCATION;
    }
}

