/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.registration;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.NameHolder;
import com.yanny.ytech.configuration.PartType;
import com.yanny.ytech.configuration.SpearType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.AqueductBlock;
import com.yanny.ytech.configuration.item.BasketItem;
import com.yanny.ytech.configuration.item.ChloriteBraceletItem;
import com.yanny.ytech.configuration.item.ClayBucketItem;
import com.yanny.ytech.configuration.item.DiviningRodItem;
import com.yanny.ytech.configuration.item.KnifeItem;
import com.yanny.ytech.configuration.item.LionManItem;
import com.yanny.ytech.configuration.item.MaterialArrowItem;
import com.yanny.ytech.configuration.item.PebbleItem;
import com.yanny.ytech.configuration.item.ShellBeadsItem;
import com.yanny.ytech.configuration.item.SpearItem;
import com.yanny.ytech.configuration.item.ToolItem;
import com.yanny.ytech.configuration.item.UnlitTorchItem;
import com.yanny.ytech.configuration.item.VenusOfHohleFelsItem;
import com.yanny.ytech.configuration.item.WildHorseItem;
import com.yanny.ytech.registration.YTechArmorMaterials;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechEntityTypes;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YTechItems {
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ytech");
    public static final DeferredItem<Item> ANTLER = ITEMS.registerSimpleItem("antler");
    public static final DeferredItem<Item> BASKET = ITEMS.register("basket", BasketItem::new);
    public static final DeferredItem<Item> BEESWAX = ITEMS.register("beeswax", YTechItems::simpleItem);
    public static final DeferredItem<Item> BONE_NEEDLE = ITEMS.register("bone_needle", () -> ToolItem.customToolItem((Tier)Tiers.WOOD, new Item.Properties().durability(5).setNoRepair()));
    public static final DeferredItem<Item> BREAD_DOUGH = ITEMS.registerSimpleItem("bread_dough");
    public static final DeferredItem<Item> BRICK_MOLD = ITEMS.registerSimpleItem("brick_mold", new Item.Properties().durability(256));
    public static final DeferredItem<Item> CLAY_BUCKET = ITEMS.register("clay_bucket", () -> new ClayBucketItem(Fluids.EMPTY, new Item.Properties().stacksTo(8)));
    public static final DeferredItem<Item> COOKED_VENISON = ITEMS.register("cooked_venison", () -> YTechItems.foodItem(7, 0.8f));
    public static final DeferredItem<Item> DIVINING_ROD = ITEMS.register("divining_rod", DiviningRodItem::new);
    public static final DeferredItem<Item> DRIED_BEEF = ITEMS.register("dried_beef", () -> YTechItems.foodItem(6, 0.7f));
    public static final DeferredItem<Item> DRIED_CHICKEN = ITEMS.register("dried_chicken", () -> YTechItems.foodItem(4, 0.5f));
    public static final DeferredItem<Item> DRIED_COD = ITEMS.register("dried_cod", () -> YTechItems.foodItem(4, 0.5f));
    public static final DeferredItem<Item> DRIED_MUTTON = ITEMS.register("dried_mutton", () -> YTechItems.foodItem(4, 0.5f));
    public static final DeferredItem<Item> DRIED_PORKCHOP = ITEMS.register("dried_porkchop", () -> YTechItems.foodItem(6, 0.7f));
    public static final DeferredItem<Item> DRIED_RABBIT = ITEMS.register("dried_rabbit", () -> YTechItems.foodItem(4, 0.5f));
    public static final DeferredItem<Item> DRIED_SALMON = ITEMS.register("dried_salmon", () -> YTechItems.foodItem(4, 0.5f));
    public static final DeferredItem<Item> DRIED_VENISON = ITEMS.register("dried_venison", () -> YTechItems.foodItem(5, 0.7f));
    public static final DeferredItem<Item> FLOUR = ITEMS.registerSimpleItem("flour");
    public static final DeferredItem<Item> GRASS_FIBERS = ITEMS.register("grass_fibers", () -> YTechItems.descriptionItem(List.of(Component.translatable((String)"text.ytech.hover.grass_fibers").withStyle(ChatFormatting.DARK_GRAY))));
    public static final DeferredItem<Item> GRASS_TWINE = ITEMS.register("grass_twine", YTechItems::simpleItem);
    public static final DeferredItem<Item> IRON_BLOOM = ITEMS.registerSimpleItem("iron_bloom");
    public static final DeferredItem<Item> LAVA_CLAY_BUCKET = ITEMS.register("lava_clay_bucket", () -> new ClayBucketItem((Fluid)Fluids.LAVA, new Item.Properties().craftRemainder((Item)CLAY_BUCKET.get()).stacksTo(1)));
    public static final DeferredItem<Item> LEATHER_STRIPS = ITEMS.registerSimpleItem("leather_strips");
    public static final DeferredItem<Item> MAMMOTH_TUSK = ITEMS.register("mammoth_tusk", YTechItems::simpleItem);
    public static final DeferredItem<Item> PEBBLE = ITEMS.register("pebble", PebbleItem::new);
    public static final DeferredItem<Item> RAW_HIDE = ITEMS.registerSimpleItem("raw_hide");
    public static final DeferredItem<Item> RHINO_HORN = ITEMS.register("rhino_horn", YTechItems::simpleItem);
    public static final DeferredItem<Item> SHARP_FLINT = ITEMS.register("sharp_flint", () -> YTechItems.toolCanHurtItem(MaterialType.WOODEN));
    public static final DeferredItem<Item> UNFIRED_AMPHORA = ITEMS.register("unfired_amphora", YTechItems::simpleItem);
    public static final DeferredItem<Item> UNFIRED_BRICK = ITEMS.registerSimpleItem("unfired_brick");
    public static final DeferredItem<Item> UNFIRED_CLAY_BUCKET = ITEMS.registerSimpleItem("unfired_clay_bucket");
    public static final DeferredItem<Item> UNFIRED_DECORATED_POT = ITEMS.registerSimpleItem("unfired_decoration_pot");
    public static final DeferredItem<Item> UNFIRED_FLOWER_POT = ITEMS.registerSimpleItem("unfired_flower_pot");
    public static final DeferredItem<Item> UNLIT_TORCH = ITEMS.register("unlit_torch", UnlitTorchItem::new);
    public static final DeferredItem<Item> VENISON = ITEMS.register("venison", () -> YTechItems.foodItem(2, 0.3f));
    public static final DeferredItem<Item> WATER_CLAY_BUCKET = ITEMS.register("water_clay_bucket", () -> new ClayBucketItem((Fluid)Fluids.WATER, new Item.Properties().craftRemainder((Item)CLAY_BUCKET.get()).stacksTo(1)));
    public static final DeferredItem<BlockItem> AMPHORA = ITEMS.register("amphora", () -> YTechItems.descriptionItem(YTechBlocks.AMPHORA, List.of(Component.translatable((String)"text.ytech.hover.amphora1").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"text.ytech.hover.amphora2").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"text.ytech.hover.amphora3").withStyle(ChatFormatting.DARK_GRAY))));
    public static final DeferredItem<BlockItem> AQUEDUCT_FERTILIZER = ITEMS.register("aqueduct_fertilizer", YTechItems::aqueductFertilizerBlockItem);
    public static final DeferredItem<BlockItem> AQUEDUCT_HYDRATOR = ITEMS.register("aqueduct_hydrator", YTechItems::aqueductHydratorBlockItem);
    public static final DeferredItem<BlockItem> AQUEDUCT_VALVE = ITEMS.register("aqueduct_valve", YTechItems::aqueductValveBlockItem);
    public static final DeferredItem<BlockItem> BRICK_CHIMNEY = ITEMS.register("brick_chimney", () -> YTechItems.descriptionItem(YTechBlocks.BRICK_CHIMNEY, List.of(Component.translatable((String)"text.ytech.hover.chimney").withStyle(ChatFormatting.DARK_GRAY))));
    public static final DeferredItem<BlockItem> BRONZE_ANVIL = ITEMS.registerSimpleBlockItem(YTechBlocks.BRONZE_ANVIL);
    public static final DeferredItem<BlockItem> CRAFTING_WORKSPACE = ITEMS.register("crafting_workspace", () -> YTechItems.descriptionItem(YTechBlocks.CRAFTING_WORKSPACE, List.of(Component.translatable((String)"text.ytech.hover.crafting_workbench1").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"text.ytech.hover.crafting_workbench2").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"text.ytech.hover.crafting_workbench3").withStyle(ChatFormatting.DARK_GRAY))));
    public static final DeferredItem<BlockItem> FIRE_PIT = ITEMS.register("fire_pit", YTechItems::firePitBlockItem);
    public static final DeferredItem<BlockItem> GRASS_BED = ITEMS.register("grass_bed", YTechItems::grassBedBlockItem);
    public static final DeferredItem<BlockItem> MILLSTONE = ITEMS.register("millstone", () -> YTechItems.descriptionItem(YTechBlocks.MILLSTONE, List.of(Component.translatable((String)"text.ytech.hover.millstone").withStyle(ChatFormatting.DARK_GRAY))));
    public static final DeferredItem<BlockItem> POTTERY_WHEEL = ITEMS.register("potters_wheel", () -> YTechItems.descriptionItem(YTechBlocks.POTTERS_WHEEL, List.of(Component.translatable((String)"text.ytech.hover.potters_wheel1").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"text.ytech.hover.potters_wheel2").withStyle(ChatFormatting.DARK_GRAY))));
    public static final DeferredItem<BlockItem> PRIMITIVE_ALLOY_SMELTER = ITEMS.register("primitive_alloy_smelter", () -> YTechItems.descriptionItem(YTechBlocks.PRIMITIVE_ALLOY_SMELTER, List.of(Component.translatable((String)"text.ytech.hover.primitive_smelter").withStyle(ChatFormatting.DARK_GRAY))));
    public static final DeferredItem<BlockItem> PRIMITIVE_SMELTER = ITEMS.register("primitive_smelter", () -> YTechItems.descriptionItem(YTechBlocks.PRIMITIVE_SMELTER, List.of(Component.translatable((String)"text.ytech.hover.primitive_smelter").withStyle(ChatFormatting.DARK_GRAY))));
    public static final DeferredItem<BlockItem> REINFORCED_BRICKS = ITEMS.registerSimpleBlockItem(YTechBlocks.REINFORCED_BRICKS);
    public static final DeferredItem<BlockItem> REINFORCED_BRICK_CHIMNEY = ITEMS.register("reinforced_brick_chimney", () -> YTechItems.descriptionItem(YTechBlocks.REINFORCED_BRICK_CHIMNEY, List.of(Component.translatable((String)"text.ytech.hover.chimney").withStyle(ChatFormatting.DARK_GRAY))));
    public static final DeferredItem<BlockItem> STRAINER = ITEMS.registerSimpleBlockItem(YTechBlocks.STRAINER);
    public static final DeferredItem<BlockItem> TERRACOTTA_BRICKS = ITEMS.registerSimpleBlockItem(YTechBlocks.TERRACOTTA_BRICKS);
    public static final DeferredItem<BlockItem> TERRACOTTA_BRICK_SLAB = ITEMS.registerSimpleBlockItem(YTechBlocks.TERRACOTTA_BRICK_SLAB);
    public static final DeferredItem<BlockItem> TERRACOTTA_BRICK_STAIRS = ITEMS.registerSimpleBlockItem(YTechBlocks.TERRACOTTA_BRICK_STAIRS);
    public static final DeferredItem<BlockItem> THATCH = ITEMS.register("thatch", () -> YTechItems.burnableBlockItem(YTechBlocks.THATCH, 200));
    public static final DeferredItem<BlockItem> THATCH_SLAB = ITEMS.register("thatch_slab", () -> YTechItems.burnableBlockItem(YTechBlocks.THATCH_SLAB, 100));
    public static final DeferredItem<BlockItem> THATCH_STAIRS = ITEMS.register("thatch_stairs", () -> YTechItems.burnableBlockItem(YTechBlocks.THATCH_STAIRS, 200));
    public static final DeferredItem<BlockItem> TOOL_RACK = ITEMS.register("tool_rack", () -> YTechItems.blockItem(YTechBlocks.TOOL_RACK));
    public static final DeferredItem<BlockItem> TREE_STUMP = ITEMS.register("tree_stump", () -> YTechItems.blockItem(YTechBlocks.TREE_STUMP));
    public static final DeferredItem<BlockItem> WELL_PULLEY = ITEMS.register("well_pulley", () -> YTechItems.descriptionItem(YTechBlocks.WELL_PULLEY, List.of(Component.translatable((String)"text.ytech.hover.well_pulley1").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"text.ytech.hover.well_pulley2").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"text.ytech.hover.well_pulley3").withStyle(ChatFormatting.DARK_GRAY))));
    public static final DeferredItem<BlockItem> WOODEN_BOX = ITEMS.register("wooden_box", () -> YTechItems.blockItem(YTechBlocks.WOODEN_BOX));
    public static final DeferredItem<Item> CHLORITE_BRACELET = ITEMS.register("chlorite_bracelet", ChloriteBraceletItem::new);
    public static final DeferredItem<Item> LION_MAN = ITEMS.register("lion_man", LionManItem::new);
    public static final DeferredItem<Item> SHELL_BEADS = ITEMS.register("shell_beads", ShellBeadsItem::new);
    public static final DeferredItem<Item> VENUS_OF_HOHLE_FELS = ITEMS.register("venus_of_hohle_fels", VenusOfHohleFelsItem::new);
    public static final DeferredItem<Item> WILD_HORSE = ITEMS.register("wild_horse", WildHorseItem::new);
    public static final DeferredItem<Item> AUROCHS_SPAWN_EGG = ITEMS.register("aurochs_spawn_egg", () -> new DeferredSpawnEggItem(YTechEntityTypes.AUROCHS, 4622581, 14695555, new Item.Properties()));
    public static final DeferredItem<Item> DEER_SPAWN_EGG = ITEMS.register("deer_spawn_egg", () -> new DeferredSpawnEggItem(YTechEntityTypes.DEER, 6703141, 14720083, new Item.Properties()));
    public static final DeferredItem<Item> FOWL_SPAWN_EGG = ITEMS.register("fowl_spawn_egg", () -> new DeferredSpawnEggItem(YTechEntityTypes.FOWL, 12994635, 0xEDDE9D, new Item.Properties()));
    public static final DeferredItem<Item> MOUFLON_SPAWN_EGG = ITEMS.register("mouflon_spawn_egg", () -> new DeferredSpawnEggItem(YTechEntityTypes.MOUFLON, 412395, 10566582, new Item.Properties()));
    public static final DeferredItem<Item> SABER_TOOTH_TIGER_SPAWN_EGG = ITEMS.register("saber_tooth_tiger_spawn_egg", () -> new DeferredSpawnEggItem(YTechEntityTypes.SABER_TOOTH_TIGER, 10824320, 9540802, new Item.Properties()));
    public static final DeferredItem<Item> TERROR_BIRD_SPAWN_EGG = ITEMS.register("terror_bird_spawn_egg", () -> new DeferredSpawnEggItem(YTechEntityTypes.TERROR_BIRD, 7707328, 12686418, new Item.Properties()));
    public static final DeferredItem<Item> WILD_BOAR_SPAWN_EGG = ITEMS.register("wild_boar_spawn_egg", () -> new DeferredSpawnEggItem(YTechEntityTypes.WILD_BOAR, 16054231, 5638745, new Item.Properties()));
    public static final DeferredItem<Item> WOOLLY_MAMMOTH_SPAWN_EGG = ITEMS.register("woolly_mammoth_spawn_egg", () -> new DeferredSpawnEggItem(YTechEntityTypes.WOOLLY_MAMMOTH, 9063025, 7129259, new Item.Properties()));
    public static final DeferredItem<Item> WOOLLY_RHINO_SPAWN_EGG = ITEMS.register("woolly_rhino_spawn_egg", () -> new DeferredSpawnEggItem(YTechEntityTypes.WOOLLY_RHINO, 308538, 3109909, new Item.Properties()));
    public static final TypedItem<PartType> CLAY_MOLDS = new PartItem("clay_mold", NameHolder.suffix("clay_mold"), () -> new Item(new Item.Properties().durability(16)));
    public static final TypedItem<PartType> PATTERNS = new PartItem("pattern", NameHolder.suffix("pattern"), YTechItems::simpleItem);
    public static final TypedItem<PartType> SAND_MOLDS = new PartItem("sand_mold", NameHolder.suffix("sand_mold"), YTechItems::simpleItem);
    public static final TypedItem<PartType> UNFIRED_MOLDS = new PartItem("unfired_mold", NameHolder.both("unfired", "mold"), YTechItems::simpleItem);
    public static final MultiTypedItem<MaterialType, PartType> PARTS = new MaterialPartItem("part", Utils.exclude(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.IRON}), Utils.exclude(PartType.ALL_PARTS, (Enum[])new PartType[]{PartType.INGOT}), NameHolder.suffix("part"), YTechItems::simpleItem);
    public static final TypedItem<MaterialType> ARROWS = new MaterialItem("arrow", NameHolder.suffix("arrow"), MaterialType.ALL_HARD_METALS, MaterialArrowItem::new);
    public static final TypedItem<MaterialType> AXES = new AxeMaterialItem();
    public static final TypedItem<MaterialType> BOLTS = new MaterialItem("bolt", NameHolder.suffix("bolt"), Utils.merge(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.WOODEN}), type -> YTechItems.burnableSimpleItem(type, 100));
    public static final TypedItem<MaterialType> BOOTS = new BootsMaterialItem();
    public static final TypedItem<MaterialType> CHESTPLATES = new ChestplatesMaterialItem();
    public static final TypedItem<MaterialType> CRUSHED_MATERIALS = new MaterialItem("crushed_material", NameHolder.prefix("crushed"), MaterialType.ALL_ORES, type -> YTechItems.simpleItem());
    public static final TypedItem<MaterialType> FILES = new MaterialItem("file", NameHolder.suffix("file"), MaterialType.ALL_METALS, YTechItems::toolCanHurtItem);
    public static final TypedItem<MaterialType> HAMMERS = new MaterialItem("hammer", NameHolder.suffix("hammer"), Utils.merge(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.STONE}), YTechItems::toolCanHurtItem);
    public static final TypedItem<MaterialType> HELMETS = new HelmetMaterialItem();
    public static final TypedItem<MaterialType> HOES = new HoeMaterialItem();
    public static final TypedItem<MaterialType> INGOTS = new IngotMaterialItem();
    public static final TypedItem<MaterialType> KNIVES = new MaterialItem("knife", NameHolder.suffix("knife"), Utils.merge(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.FLINT}), YTechItems::knifeItem);
    public static final TypedItem<MaterialType> LEGGINGS = new LeggingsMaterialItem();
    public static final TypedItem<MaterialType> MESHES = new MaterialItem("mesh", NameHolder.suffix("mesh"), MaterialType.MESH_MATERIALS, YTechItems::toolItem);
    public static final TypedItem<MaterialType> MORTAR_AND_PESTLES = new MaterialItem("mortar_and_pestle", NameHolder.suffix("mortar_and_pestle"), Utils.merge(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.STONE}), YTechItems::toolItem);
    public static final TypedItem<MaterialType> PICKAXES = new PickaxeMaterialItem();
    public static final TypedItem<MaterialType> PLATES = new MaterialItem("plate", NameHolder.suffix("plate"), Utils.merge(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.WOODEN}), type -> YTechItems.burnableSimpleItem(type, 200));
    public static final TypedItem<MaterialType> RAW_MATERIALS = new RawMaterialItem();
    public static final TypedItem<MaterialType> RODS = new MaterialItem("rod", NameHolder.suffix("rod"), MaterialType.ALL_METALS, type -> YTechItems.simpleItem());
    public static final TypedItem<MaterialType> SAWS = new MaterialItem("saw", NameHolder.suffix("saw"), MaterialType.ALL_METALS, YTechItems::toolCanHurtItem);
    public static final TypedItem<MaterialType> SAW_BLADES = new MaterialItem("saw_blade", NameHolder.suffix("saw_blade"), EnumSet.of(MaterialType.IRON), type -> YTechItems.simpleItem());
    public static final TypedItem<MaterialType> SHEARS = new ShearsMaterialItem();
    public static final TypedItem<MaterialType> SHOVELS = new ShovelMaterialItem();
    public static final TypedItem<MaterialType> SPEARS = new MaterialItem("spear", NameHolder.suffix("spear"), Utils.merge(MaterialType.ALL_HARD_METALS, (Enum[])new MaterialType[]{MaterialType.FLINT}), type -> new SpearItem(SpearType.BY_MATERIAL_TYPE.get(type)));
    public static final TypedItem<MaterialType> SWORDS = new SwordMaterialItem();
    public static final TypedItem<MaterialType> AQUEDUCTS = new MaterialItem(YTechBlocks.AQUEDUCTS, YTechItems::aqueductBlockItem);
    public static final TypedItem<MaterialType> DEEPSLATE_ORES = new DeepslateOreMaterialItem();
    public static final TypedItem<MaterialType> DRYING_RACKS = new MaterialItem(YTechBlocks.DRYING_RACKS, YTechItems::dryingRackBlockItem);
    public static final TypedItem<MaterialType> GRAVEL_DEPOSITS = new MaterialItem(YTechBlocks.GRAVEL_DEPOSITS, YTechItems::blockItem);
    public static final TypedItem<MaterialType> NETHER_ORES = new NetherOreMaterialItem();
    public static final TypedItem<MaterialType> RAW_STORAGE_BLOCKS = new RawStorageBlockMaterialItem();
    public static final TypedItem<MaterialType> SAND_DEPOSITS = new MaterialItem(YTechBlocks.SAND_DEPOSITS, YTechItems::blockItem);
    public static final TypedItem<MaterialType> STONE_ORES = new StoneOreMaterialItem();
    public static final TypedItem<MaterialType> STORAGE_BLOCKS = new StorageBlockMaterialItem();
    public static final TypedItem<MaterialType> TANNING_RACKS = new MaterialItem(YTechBlocks.TANNING_RACKS, block -> YTechItems.burnableBlockItem((DeferredBlock<Block>)block, 300));

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }

    public static Collection<DeferredHolder<Item, ? extends Item>> getRegisteredItems() {
        return ITEMS.getEntries();
    }

    private static BlockItem blockItem(DeferredBlock<Block> block) {
        return new BlockItem((Block)block.get(), new Item.Properties());
    }

    private static BlockItem burnableBlockItem(DeferredBlock<Block> block, final int burnTime) {
        return new BlockItem((Block)block.get(), new Item.Properties()){

            public int getBurnTime(@NotNull ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return burnTime;
            }
        };
    }

    private static Item simpleItem() {
        return new Item(new Item.Properties());
    }

    private static Item burnableSimpleItem(final @NotNull MaterialType material, final int burnTime) {
        return new Item(new Item.Properties()){

            public int getBurnTime(@NotNull ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return material == MaterialType.WOODEN ? burnTime : 0;
            }
        };
    }

    private static Item toolItem(MaterialType material) {
        return ToolItem.toolItem(material.getTier());
    }

    private static Item toolCanHurtItem(MaterialType material) {
        return ToolItem.attackableToolItem(material.getTier());
    }

    private static Item axeItem(MaterialType material) {
        return new AxeItem(material.getTier(), new Item.Properties().attributes(AxeItem.createAttributes((Tier)material.getTier(), (float)6.0f, (float)-3.2f)));
    }

    private static Item pickaxeItem(MaterialType material) {
        return new PickaxeItem(material.getTier(), new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)material.getTier(), (float)1.0f, (float)-2.8f)));
    }

    private static Item shearsItem(MaterialType materialType) {
        return new ShearsItem(new Item.Properties().durability(materialType.getTier().getUses()));
    }

    private static Item shovelItem(MaterialType material) {
        return new ShovelItem(material.getTier(), new Item.Properties().attributes(ShovelItem.createAttributes((Tier)material.getTier(), (float)1.5f, (float)-3.0f)));
    }

    private static Item helmetItem(MaterialType material) {
        return new ArmorItem(YTechArmorMaterials.ARMORS.get(material), ArmorItem.Type.HELMET, new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(YTechArmorMaterials.ARMORS.getDurability(material))));
    }

    private static Item chestplateItem(MaterialType material) {
        return new ArmorItem(YTechArmorMaterials.ARMORS.get(material), ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(YTechArmorMaterials.ARMORS.getDurability(material))));
    }

    private static Item leggingsItem(MaterialType material) {
        return new ArmorItem(YTechArmorMaterials.ARMORS.get(material), ArmorItem.Type.LEGGINGS, new Item.Properties().durability(ArmorItem.Type.LEGGINGS.getDurability(YTechArmorMaterials.ARMORS.getDurability(material))));
    }

    private static Item bootsItem(MaterialType material) {
        return new ArmorItem(YTechArmorMaterials.ARMORS.get(material), ArmorItem.Type.BOOTS, new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(YTechArmorMaterials.ARMORS.getDurability(material))));
    }

    private static Item hoeItem(MaterialType material) {
        return new HoeItem(material.getTier(), new Item.Properties().attributes(HoeItem.createAttributes((Tier)material.getTier(), (float)0.0f, (float)-3.0f)));
    }

    private static Item swordItem(MaterialType material) {
        return new SwordItem(material.getTier(), new Item.Properties().attributes(SwordItem.createAttributes((Tier)material.getTier(), (int)3, (float)-2.4f)));
    }

    private static Item knifeItem(MaterialType material) {
        return new KnifeItem(material.getTier(), new Item.Properties().attributes(KnifeItem.createAttributes(material.getTier(), 1, -1.0f)));
    }

    private static Item foodItem(int nutrition, float saturation) {
        return new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturation).build()));
    }

    private static Item descriptionItem(final @NotNull List<Component> description) {
        return new Item(new Item.Properties()){

            public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
                super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
                tooltipComponents.addAll(description);
            }
        };
    }

    private static BlockItem descriptionItem(DeferredBlock<Block> block, final @NotNull List<Component> description) {
        return new BlockItem((Block)block.get(), new Item.Properties()){

            public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
                super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
                tooltipComponents.addAll(description);
            }
        };
    }

    private static BlockItem aqueductBlockItem(final DeferredBlock<Block> block) {
        return new BlockItem((Block)block.get(), new Item.Properties()){

            public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
                super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.aqueduct1", (Object[])new Object[]{((AqueductBlock)((Object)block.get())).getCapacity()}).withStyle(ChatFormatting.DARK_GRAY));
                if (YTechMod.CONFIGURATION.shouldRainingFillAqueduct()) {
                    tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.aqueduct2", (Object[])new Object[]{YTechMod.CONFIGURATION.getRainingFillAmount(), YTechMod.CONFIGURATION.getRainingFillPerNthTick()}).withStyle(ChatFormatting.DARK_GRAY));
                }
                if (YTechMod.CONFIGURATION.shouldDrippingFillAqueduct()) {
                    tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.aqueduct3", (Object[])new Object[]{YTechMod.CONFIGURATION.getDrippingFillAmount(), YTechMod.CONFIGURATION.getDrippingFillPerNthTick()}).withStyle(ChatFormatting.DARK_GRAY));
                }
            }
        };
    }

    private static BlockItem aqueductFertilizerBlockItem() {
        return new BlockItem((Block)YTechBlocks.AQUEDUCT_FERTILIZER.get(), new Item.Properties()){

            public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
                super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.aqueduct_fertilizer1").withStyle(ChatFormatting.DARK_GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.aqueduct_fertilizer2", (Object[])new Object[]{YTechMod.CONFIGURATION.getHydratorDrainAmount(), YTechMod.CONFIGURATION.getHydratorDrainPerNthTick()}).withStyle(ChatFormatting.DARK_GRAY));
            }
        };
    }

    private static BlockItem aqueductHydratorBlockItem() {
        return new BlockItem((Block)YTechBlocks.AQUEDUCT_HYDRATOR.get(), new Item.Properties()){

            public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
                super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.aqueduct_hydrator1").withStyle(ChatFormatting.DARK_GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.aqueduct_hydrator2", (Object[])new Object[]{YTechMod.CONFIGURATION.getHydratorDrainAmount(), YTechMod.CONFIGURATION.getHydratorDrainPerNthTick()}).withStyle(ChatFormatting.DARK_GRAY));
            }
        };
    }

    private static BlockItem aqueductValveBlockItem() {
        return new BlockItem((Block)YTechBlocks.AQUEDUCT_VALVE.get(), new Item.Properties()){

            public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
                super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.aqueduct_valve1").withStyle(ChatFormatting.DARK_GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.aqueduct_valve2", (Object[])new Object[]{YTechMod.CONFIGURATION.getValveFillAmount(), YTechMod.CONFIGURATION.getValveFillPerNthTick()}).withStyle(ChatFormatting.DARK_GRAY));
            }
        };
    }

    private static BlockItem firePitBlockItem() {
        return new BlockItem((Block)YTechBlocks.FIRE_PIT.get(), new Item.Properties()){

            public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
                super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.fire_pit1").withStyle(ChatFormatting.DARK_GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.fire_pit2").withStyle(ChatFormatting.DARK_GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.fire_pit3").withStyle(ChatFormatting.DARK_GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.fire_pit4").withStyle(ChatFormatting.DARK_GRAY));
            }
        };
    }

    private static BlockItem grassBedBlockItem() {
        return new BlockItem((Block)YTechBlocks.GRASS_BED.get(), new Item.Properties()){

            public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
                super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.grass_bed").withStyle(ChatFormatting.DARK_GRAY));
            }
        };
    }

    private static BlockItem dryingRackBlockItem(DeferredBlock<Block> block) {
        return new BlockItem((Block)block.get(), new Item.Properties()){

            public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
                super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
                tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.drying_rack1").withStyle(ChatFormatting.DARK_GRAY));
                if (YTechMod.CONFIGURATION.noDryingDuringRain()) {
                    tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.drying_rack2").withStyle(ChatFormatting.DARK_GRAY));
                }
            }
        };
    }

    public static class PartItem
    extends TypedItem<PartType> {
        PartItem(String group, NameHolder nameHolder, Supplier<Item> itemSupplier) {
            super(group);
            for (PartType partType : PartType.values()) {
                Object key = nameHolder.prefix() != null ? nameHolder.prefix() + "_" : "";
                key = (String)key + partType.key;
                key = (String)key + (String)(nameHolder.suffix() != null ? "_" + nameHolder.suffix() : "");
                this.items.put(partType, ITEMS.register((String)key, itemSupplier));
            }
        }
    }

    public static class TypedItem<E extends Enum<E>>
    extends AbstractMap<E, DeferredItem<Item>> {
        protected final String group;
        protected final Map<E, DeferredItem<Item>> items = new HashMap<E, DeferredItem<Item>>();

        TypedItem(String group) {
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }

        @Override
        @NotNull
        public Set<Map.Entry<E, DeferredItem<Item>>> entrySet() {
            return this.items.entrySet();
        }
    }

    public static class MaterialPartItem
    extends MultiTypedItem<MaterialType, PartType> {
        MaterialPartItem(String group, EnumSet<MaterialType> materials, EnumSet<PartType> parts, NameHolder nameHolder, Supplier<Item> itemSupplier) {
            super(group);
            for (MaterialType material : materials) {
                for (PartType part : parts) {
                    Object key = nameHolder.prefix() != null ? nameHolder.prefix() + "_" : "";
                    key = (String)key + material.key + "_" + part.key;
                    key = (String)key + (String)(nameHolder.suffix() != null ? "_" + nameHolder.suffix() : "");
                    this.items.computeIfAbsent(material, k -> new HashMap()).put(part, ITEMS.register((String)key, itemSupplier));
                }
            }
        }
    }

    public static class MultiTypedItem<E extends Enum<E>, F extends Enum<F>>
    extends AbstractMap<E, Map<F, DeferredItem<Item>>> {
        protected final String group;
        protected final Map<E, Map<F, DeferredItem<Item>>> items = new HashMap<E, Map<F, DeferredItem<Item>>>();

        MultiTypedItem(String group) {
            this.group = group;
        }

        public DeferredItem<Item> get(E type1, F type2) {
            return this.items.get(type1).get(type2);
        }

        public String getGroup() {
            return this.group;
        }

        @Override
        @NotNull
        public Set<Map.Entry<E, Map<F, DeferredItem<Item>>>> entrySet() {
            return this.items.entrySet();
        }
    }

    public static class MaterialItem
    extends TypedItem<MaterialType> {
        public MaterialItem(String group, NameHolder nameHolder, EnumSet<MaterialType> materialTypes, Function<MaterialType, Item> itemSupplier) {
            super(group);
            materialTypes.forEach((? super T type) -> {
                Object key = nameHolder.prefix() != null ? nameHolder.prefix() + "_" : "";
                key = type.key.equals("gold") && nameHolder.prefix() == null ? (String)key + "golden" : (String)key + type.key;
                key = (String)key + (String)(nameHolder.suffix() != null ? "_" + nameHolder.suffix() : "");
                this.items.put(type, ITEMS.register((String)key, () -> (Item)itemSupplier.apply((MaterialType)type)));
            });
        }

        public MaterialItem(YTechBlocks.MaterialBlock block, Function<DeferredBlock<Block>, Item> itemSupplier) {
            this(block, EnumSet.noneOf(MaterialType.class), itemSupplier);
        }

        public MaterialItem(YTechBlocks.MaterialBlock block, EnumSet<MaterialType> exclude, Function<DeferredBlock<Block>, Item> itemSupplier) {
            super(block.getGroup());
            block.entries().stream().filter(entry -> !exclude.contains(entry.getKey())).forEach((? super T entry) -> {
                MaterialType type = (MaterialType)entry.getKey();
                DeferredBlock object = (DeferredBlock)entry.getValue();
                this.items.put(type, ITEMS.register(Utils.getPath(object), () -> (Item)itemSupplier.apply(object)));
            });
        }
    }

    private static class AxeMaterialItem
    extends MaterialItem {
        public AxeMaterialItem() {
            super("axe", NameHolder.suffix("axe"), Utils.exclude((EnumSet)Utils.merge(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.FLINT}), (Enum[])new MaterialType[]{MaterialType.GOLD, MaterialType.IRON}), YTechItems::axeItem);
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_AXE)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_AXE)));
        }
    }

    private static class BootsMaterialItem
    extends MaterialItem {
        public BootsMaterialItem() {
            super("boots", NameHolder.suffix("boots"), Utils.exclude(MaterialType.ALL_HARD_METALS, (Enum[])new MaterialType[]{MaterialType.GOLD, MaterialType.IRON}), YTechItems::bootsItem);
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_BOOTS)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_BOOTS)));
            this.items.put(MaterialType.LEATHER, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.LEATHER_BOOTS)));
        }
    }

    private static class ChestplatesMaterialItem
    extends MaterialItem {
        public ChestplatesMaterialItem() {
            super("chestplate", NameHolder.suffix("chestplate"), Utils.exclude(MaterialType.ALL_HARD_METALS, (Enum[])new MaterialType[]{MaterialType.GOLD, MaterialType.IRON}), YTechItems::chestplateItem);
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_CHESTPLATE)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_CHESTPLATE)));
            this.items.put(MaterialType.LEATHER, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.LEATHER_CHESTPLATE)));
        }
    }

    private static class HelmetMaterialItem
    extends MaterialItem {
        public HelmetMaterialItem() {
            super("helmet", NameHolder.suffix("helmet"), Utils.exclude(MaterialType.ALL_HARD_METALS, (Enum[])new MaterialType[]{MaterialType.GOLD, MaterialType.IRON}), YTechItems::helmetItem);
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_HELMET)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_HELMET)));
            this.items.put(MaterialType.LEATHER, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.LEATHER_HELMET)));
        }
    }

    private static class HoeMaterialItem
    extends MaterialItem {
        public HoeMaterialItem() {
            super("hoe", NameHolder.suffix("hoe"), Utils.exclude(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.GOLD, MaterialType.IRON}), YTechItems::hoeItem);
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_HOE)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_HOE)));
        }
    }

    private static class IngotMaterialItem
    extends MaterialItem {
        public IngotMaterialItem() {
            super("ingot", NameHolder.suffix("ingot"), Utils.exclude(MaterialType.ALL_METALS, MaterialType.VANILLA_METALS), type -> YTechItems.simpleItem());
            this.items.put(MaterialType.COPPER, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.COPPER_INGOT)));
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLD_INGOT)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_INGOT)));
        }
    }

    private static class LeggingsMaterialItem
    extends MaterialItem {
        public LeggingsMaterialItem() {
            super("leggings", NameHolder.suffix("leggings"), Utils.exclude(MaterialType.ALL_HARD_METALS, (Enum[])new MaterialType[]{MaterialType.GOLD, MaterialType.IRON}), YTechItems::leggingsItem);
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_LEGGINGS)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_LEGGINGS)));
            this.items.put(MaterialType.LEATHER, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.LEATHER_LEGGINGS)));
        }
    }

    private static class PickaxeMaterialItem
    extends MaterialItem {
        public PickaxeMaterialItem() {
            super("pickaxe", NameHolder.suffix("pickaxe"), Utils.exclude((EnumSet)Utils.merge(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.ANTLER}), (Enum[])new MaterialType[]{MaterialType.GOLD, MaterialType.IRON}), YTechItems::pickaxeItem);
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_PICKAXE)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_PICKAXE)));
        }
    }

    private static class RawMaterialItem
    extends MaterialItem {
        public RawMaterialItem() {
            super("raw_material", NameHolder.prefix("raw"), Utils.exclude(MaterialType.ALL_ORES, MaterialType.VANILLA_METALS), type -> YTechItems.simpleItem());
            this.items.put(MaterialType.COPPER, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.RAW_COPPER)));
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.RAW_GOLD)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.RAW_IRON)));
        }
    }

    private static class ShearsMaterialItem
    extends MaterialItem {
        public ShearsMaterialItem() {
            super("shears", NameHolder.suffix("shears"), Utils.exclude(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.IRON}), YTechItems::shearsItem);
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.SHEARS)));
        }
    }

    private static class ShovelMaterialItem
    extends MaterialItem {
        public ShovelMaterialItem() {
            super("shovel", NameHolder.suffix("shovel"), Utils.exclude(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.GOLD, MaterialType.IRON}), YTechItems::shovelItem);
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_SHOVEL)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_SHOVEL)));
            this.items.put(MaterialType.WOODEN, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.WOODEN_SHOVEL)));
        }
    }

    private static class SwordMaterialItem
    extends MaterialItem {
        public SwordMaterialItem() {
            super("sword", NameHolder.suffix("sword"), Utils.exclude(MaterialType.ALL_METALS, (Enum[])new MaterialType[]{MaterialType.GOLD, MaterialType.IRON}), YTechItems::swordItem);
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_SWORD)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_SWORD)));
        }
    }

    private static class DeepslateOreMaterialItem
    extends MaterialItem {
        public DeepslateOreMaterialItem() {
            super(YTechBlocks.DEEPSLATE_ORES, MaterialType.VANILLA_METALS, YTechItems::blockItem);
            this.items.put(MaterialType.COPPER, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.DEEPSLATE_COPPER_ORE)));
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.DEEPSLATE_GOLD_ORE)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.DEEPSLATE_IRON_ORE)));
        }
    }

    private static class NetherOreMaterialItem
    extends MaterialItem {
        public NetherOreMaterialItem() {
            super(YTechBlocks.NETHER_ORES, EnumSet.of(MaterialType.GOLD), YTechItems::blockItem);
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.NETHER_GOLD_ORE)));
        }
    }

    private static class RawStorageBlockMaterialItem
    extends MaterialItem {
        public RawStorageBlockMaterialItem() {
            super(YTechBlocks.RAW_STORAGE_BLOCKS, MaterialType.VANILLA_METALS, YTechItems::blockItem);
            this.items.put(MaterialType.COPPER, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.RAW_COPPER_BLOCK)));
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.RAW_GOLD_BLOCK)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.RAW_IRON_BLOCK)));
        }
    }

    private static class StoneOreMaterialItem
    extends MaterialItem {
        public StoneOreMaterialItem() {
            super(YTechBlocks.STONE_ORES, MaterialType.VANILLA_METALS, YTechItems::blockItem);
            this.items.put(MaterialType.COPPER, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.COPPER_ORE)));
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLD_ORE)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_ORE)));
        }
    }

    private static class StorageBlockMaterialItem
    extends MaterialItem {
        public StorageBlockMaterialItem() {
            super(YTechBlocks.STORAGE_BLOCKS, MaterialType.VANILLA_METALS, YTechItems::blockItem);
            this.items.put(MaterialType.COPPER, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.COPPER_BLOCK)));
            this.items.put(MaterialType.GOLD, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.GOLD_BLOCK)));
            this.items.put(MaterialType.IRON, DeferredItem.createItem((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)Items.IRON_BLOCK)));
        }
    }
}

