/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.AbstractPrimitiveMachineBlock;
import com.yanny.ytech.configuration.block.AmphoraBlock;
import com.yanny.ytech.configuration.block.BronzeAnvilBlock;
import com.yanny.ytech.configuration.block.DryingRackBlock;
import com.yanny.ytech.configuration.block.FirePitBlock;
import com.yanny.ytech.configuration.block.IrrigationBlock;
import com.yanny.ytech.configuration.block.MillstoneBlock;
import com.yanny.ytech.configuration.block.PottersWheelBlock;
import com.yanny.ytech.configuration.block.TanningRackBlock;
import com.yanny.ytech.configuration.block.ToolRackBlock;
import com.yanny.ytech.configuration.block.TreeStumpBlock;
import com.yanny.ytech.configuration.block.WoodenBoxBlock;
import com.yanny.ytech.configuration.block_entity.AbstractPrimitiveMachineBlockEntity;
import com.yanny.ytech.configuration.block_entity.AmphoraBlockEntity;
import com.yanny.ytech.configuration.block_entity.AqueductFertilizerBlockEntity;
import com.yanny.ytech.configuration.block_entity.AqueductHydratorBlockEntity;
import com.yanny.ytech.configuration.block_entity.BronzeAnvilBlockEntity;
import com.yanny.ytech.configuration.block_entity.DryingRackBlockEntity;
import com.yanny.ytech.configuration.block_entity.FirePitBlockEntity;
import com.yanny.ytech.configuration.block_entity.IrrigationBlockEntity;
import com.yanny.ytech.configuration.block_entity.MillstoneBlockEntity;
import com.yanny.ytech.configuration.block_entity.PottersWheelBlockEntity;
import com.yanny.ytech.configuration.block_entity.TanningRackBlockEntity;
import com.yanny.ytech.configuration.block_entity.ToolRackBlockEntity;
import com.yanny.ytech.configuration.block_entity.TreeStumpBlockEntity;
import com.yanny.ytech.configuration.block_entity.WoodenBoxBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.registration.YTechBlocks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public class JadeCompatibility
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)DryingRackProvider.INSTANCE, DryingRackBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)MillstoneProvider.INSTANCE, MillstoneBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)TanningRackProvider.INSTANCE, TanningRackBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)PrimitiveMachineProvider.INSTANCE, AbstractPrimitiveMachineBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)IrrigationProvider.INSTANCE, IrrigationBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)FirePitProvider.INSTANCE, FirePitBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)TreeStumpProvider.INSTANCE, TreeStumpBlockEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)BronzeAnvilProvider.INSTANCE, BronzeAnvilBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)DryingRackProvider.INSTANCE, DryingRackBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)MillstoneProvider.INSTANCE, MillstoneBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)TanningRackProvider.INSTANCE, TanningRackBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)PrimitiveMachineProvider.INSTANCE, AbstractPrimitiveMachineBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)IrrigationProvider.INSTANCE, IrrigationBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)PottersWheelProvider.INSTANCE, PottersWheelBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)FirePitProvider.INSTANCE, FirePitBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)TreeStumpProvider.INSTANCE, TreeStumpBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)AmphoraProvider.INSTANCE, AmphoraBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)WoodenBoxProvider.INSTANCE, WoodenBoxBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)ToolRackProvider.INSTANCE, ToolRackBlock.class);
    }

    private static class DryingRackProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor> {
        private static final DryingRackProvider INSTANCE = new DryingRackProvider();

        private DryingRackProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            if (blockAccessor.getServerData().m_128441_("Progress")) {
                iTooltip.add((Component)Component.m_237110_((String)"text.ytech.top.drying_rack.progress", (Object[])new Object[]{blockAccessor.getServerData().m_128423_("Progress")}));
            }
        }

        public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
            DryingRackBlockEntity blockEntity = (DryingRackBlockEntity)accessor.getBlockEntity();
            if (!blockEntity.getItem().m_41619_()) {
                compoundTag.m_128405_("Progress", blockEntity.getProgress());
            }
        }

        public ResourceLocation getUid() {
            return Utils.modLoc("drying_racks");
        }
    }

    private static class MillstoneProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor> {
        private static final MillstoneProvider INSTANCE = new MillstoneProvider();

        private MillstoneProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            if (blockAccessor.getServerData().m_128441_("Item")) {
                IElementHelper elements = iTooltip.getElementHelper();
                iTooltip.add(elements.item(ItemStack.m_41712_((CompoundTag)blockAccessor.getServerData().m_128469_("Item"))));
            }
        }

        public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
            MillstoneBlockEntity blockEntity = (MillstoneBlockEntity)accessor.getBlockEntity();
            compoundTag.m_128365_("Item", (Tag)blockEntity.getInputItem().m_41739_(new CompoundTag()));
        }

        public ResourceLocation getUid() {
            return YTechBlocks.MILLSTONE.getId();
        }
    }

    private static class TanningRackProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor> {
        private static final TanningRackProvider INSTANCE = new TanningRackProvider();

        private TanningRackProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            if (blockAccessor.getServerData().m_128441_("Progress")) {
                iTooltip.add((Component)Component.m_237110_((String)"text.ytech.top.tanning_rack.progress", (Object[])new Object[]{blockAccessor.getServerData().m_128423_("Progress")}));
            }
        }

        public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
            TanningRackBlockEntity blockEntity = (TanningRackBlockEntity)accessor.getBlockEntity();
            if (!blockEntity.getItem().m_41619_()) {
                compoundTag.m_128405_("Progress", blockEntity.getProgress());
            }
        }

        public ResourceLocation getUid() {
            return Utils.modLoc("tanning_racks");
        }
    }

    private static class PrimitiveMachineProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor> {
        private static final PrimitiveMachineProvider INSTANCE = new PrimitiveMachineProvider();

        private PrimitiveMachineProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor accessor, IPluginConfig iPluginConfig) {
            if (accessor.getServerData().m_128441_("Progress")) {
                iTooltip.add((Component)Component.m_237110_((String)"text.ytech.top.smelter.progress", (Object[])new Object[]{accessor.getServerData().m_128423_("Progress")}));
            }
            if (accessor.getServerData().m_128441_("Temperature")) {
                iTooltip.add((Component)Component.m_237110_((String)"text.ytech.top.smelter.temperature", (Object[])new Object[]{accessor.getServerData().m_128423_("Temperature")}));
            }
        }

        public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
            AbstractPrimitiveMachineBlockEntity blockEntity = (AbstractPrimitiveMachineBlockEntity)accessor.getBlockEntity();
            if (blockEntity.hasActiveRecipe()) {
                compoundTag.m_128405_("Progress", blockEntity.progress());
            }
            compoundTag.m_128405_("Temperature", blockEntity.temperature());
        }

        public ResourceLocation getUid() {
            return Utils.modLoc("primitive_machines");
        }
    }

    private static class IrrigationProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor> {
        private static final IrrigationProvider INSTANCE = new IrrigationProvider();

        private IrrigationProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor accessor, IPluginConfig iPluginConfig) {
            if (accessor.getServerData().m_128441_("Production")) {
                iTooltip.add((Component)Component.m_237110_((String)"text.ytech.top.irrigation.production", (Object[])new Object[]{accessor.getServerData().m_128423_("Production")}));
            }
            if (accessor.getServerData().m_128441_("Hydrating")) {
                iTooltip.add((Component)Component.m_237115_((String)"text.ytech.top.irrigation.hydrating"));
            }
            if (accessor.getServerData().m_128441_("Fertilizing")) {
                iTooltip.add((Component)Component.m_237115_((String)"text.ytech.top.irrigation.fertilizing"));
            }
            if (accessor.getServerData().m_128441_("Amount") && accessor.getServerData().m_128441_("Capacity")) {
                iTooltip.add((Component)Component.m_237110_((String)"text.ytech.top.irrigation.network", (Object[])new Object[]{accessor.getServerData().m_128423_("Amount"), accessor.getServerData().m_128423_("Capacity")}));
            }
        }

        public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
            IrrigationBlockEntity blockEntity = (IrrigationBlockEntity)accessor.getBlockEntity();
            switch (blockEntity.getNetworkType()) {
                case PROVIDER: {
                    compoundTag.m_128405_("Production", Math.round((float)blockEntity.getFlow() * (20.0f / (float)YTechMod.CONFIGURATION.getValveFillPerNthTick())));
                    break;
                }
                case CONSUMER: {
                    AqueductFertilizerBlockEntity fertilizerBlock;
                    AqueductHydratorBlockEntity hydratorBlock;
                    if (blockEntity instanceof AqueductHydratorBlockEntity && (hydratorBlock = (AqueductHydratorBlockEntity)blockEntity).isHydrating()) {
                        compoundTag.m_128379_("Hydrating", true);
                    }
                    if (!(blockEntity instanceof AqueductFertilizerBlockEntity) || !(fertilizerBlock = (AqueductFertilizerBlockEntity)blockEntity).isFertilizing()) break;
                    compoundTag.m_128379_("Fertilizing", true);
                }
            }
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(blockEntity);
            if (network != null) {
                compoundTag.m_128405_("Amount", network.getFluidHandler().getFluidAmount());
                compoundTag.m_128405_("Capacity", network.getFluidHandler().getCapacity());
            }
        }

        public ResourceLocation getUid() {
            return Utils.modLoc("irrigation");
        }
    }

    private static class FirePitProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor> {
        private static final FirePitProvider INSTANCE = new FirePitProvider();

        private FirePitProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            if (blockAccessor.getServerData().m_128441_("Progress")) {
                iTooltip.add((Component)Component.m_237110_((String)"text.ytech.top.fire_pit.progress", (Object[])new Object[]{blockAccessor.getServerData().m_128423_("Progress")}));
            }
        }

        public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
            FirePitBlockEntity blockEntity = (FirePitBlockEntity)accessor.getBlockEntity();
            if (!blockEntity.getItem().m_41619_()) {
                compoundTag.m_128405_("Progress", blockEntity.getProgress());
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.FIRE_PIT.getId();
        }
    }

    private static class TreeStumpProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor> {
        private static final TreeStumpProvider INSTANCE = new TreeStumpProvider();

        private TreeStumpProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            if (blockAccessor.getServerData().m_128441_("Progress")) {
                iTooltip.add((Component)Component.m_237110_((String)"text.ytech.top.tree_stump.progress", (Object[])new Object[]{blockAccessor.getServerData().m_128423_("Progress")}));
            }
        }

        public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
            TreeStumpBlockEntity blockEntity = (TreeStumpBlockEntity)accessor.getBlockEntity();
            if (!blockEntity.getItem().m_41619_()) {
                compoundTag.m_128405_("Progress", blockEntity.getProgress());
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.TREE_STUMP.getId();
        }
    }

    private static class BronzeAnvilProvider
    implements IBlockComponentProvider {
        private static final BronzeAnvilProvider INSTANCE = new BronzeAnvilProvider();

        private BronzeAnvilProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            BronzeAnvilBlockEntity blockEntity;
            BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
            if (blockEntity2 instanceof BronzeAnvilBlockEntity && !(blockEntity = (BronzeAnvilBlockEntity)blockEntity2).getItem().m_41619_()) {
                IElementHelper elements = iTooltip.getElementHelper();
                iTooltip.add(elements.item(blockEntity.getItem()));
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.BRONZE_ANVIL.getId();
        }
    }

    private static class PottersWheelProvider
    implements IBlockComponentProvider {
        private static final PottersWheelProvider INSTANCE = new PottersWheelProvider();

        private PottersWheelProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            PottersWheelBlockEntity blockEntity;
            BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
            if (blockEntity2 instanceof PottersWheelBlockEntity && !(blockEntity = (PottersWheelBlockEntity)blockEntity2).getItem().m_41619_()) {
                IElementHelper elements = iTooltip.getElementHelper();
                iTooltip.add(elements.item(blockEntity.getItem()));
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.POTTERS_WHEEL.getId();
        }
    }

    private static class AmphoraProvider
    implements IBlockComponentProvider {
        private static final AmphoraProvider INSTANCE = new AmphoraProvider();

        private AmphoraProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            AmphoraBlockEntity blockEntity;
            BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
            if (blockEntity2 instanceof AmphoraBlockEntity && !(blockEntity = (AmphoraBlockEntity)blockEntity2).getItem().m_41619_()) {
                IElementHelper elements = iTooltip.getElementHelper();
                iTooltip.add(elements.item(blockEntity.getItem()));
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.AMPHORA.getId();
        }
    }

    private static class WoodenBoxProvider
    implements IBlockComponentProvider {
        private static final WoodenBoxProvider INSTANCE = new WoodenBoxProvider();

        private WoodenBoxProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof WoodenBoxBlockEntity) {
                WoodenBoxBlockEntity blockEntity2 = (WoodenBoxBlockEntity)blockEntity;
                IElementHelper elements = iTooltip.getElementHelper();
                ItemStack item = blockEntity2.getItem(blockAccessor.getPosition(), blockAccessor.getSide(), ((BlockHitResult)blockAccessor.getHitResult()).m_82450_());
                if (!item.m_41619_()) {
                    iTooltip.add(elements.item(item));
                    iTooltip.append((Component)Component.m_237115_((String)item.m_41778_()));
                }
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.WOODEN_BOX.getId();
        }
    }

    private static class ToolRackProvider
    implements IBlockComponentProvider {
        private static final ToolRackProvider INSTANCE = new ToolRackProvider();

        private ToolRackProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof ToolRackBlockEntity) {
                ToolRackBlockEntity blockEntity2 = (ToolRackBlockEntity)blockEntity;
                IElementHelper elements = iTooltip.getElementHelper();
                ItemStack item = blockEntity2.getItem(blockAccessor.getPosition(), blockAccessor.getSide(), ((BlockHitResult)blockAccessor.getHitResult()).m_82450_());
                if (!item.m_41619_()) {
                    iTooltip.add(elements.item(item));
                    iTooltip.append((Component)Component.m_237115_((String)item.m_41778_()));
                }
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.TOOL_RACK.getId();
        }
    }
}

