/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.jei;

import com.yanny.ytech.compatibility.jei.ButtonWidget;
import com.yanny.ytech.configuration.Utils;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import mezz.jei.api.helpers.IJeiHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WorkspaceCraftingWidget
implements ISlottedRecipeWidget,
IJeiGuiEventListener {
    public static final ResourceLocation TEXTURE = Utils.modLoc("textures/gui/emi.png");
    private final int x;
    private final int y;
    private final List<IRecipeSlotDrawable> ingredients;
    private final IJeiHelpers jeiHelpers;
    private final List<ButtonWidget> buttonWidgets;
    private int layer = 0;

    public WorkspaceCraftingWidget(int x, int y, List<IRecipeSlotDrawable> ingredients, IJeiHelpers jeiHelpers) {
        this.x = x;
        this.y = y;
        this.ingredients = ingredients;
        this.jeiHelpers = jeiHelpers;
        this.buttonWidgets = List.of(new ButtonWidget(x + 64, y, 12, 10, 16, 0, TEXTURE, () -> this.layer < 3, this::upClicked), new ButtonWidget(x + 64, y + 10, 12, 10, 28, 0, TEXTURE, () -> this.layer > 0, this::downClicked));
    }

    void upClicked(double mouseX, double mouseY, int button) {
        if (this.layer < 3) {
            ++this.layer;
        }
    }

    void downClicked(double mouseX, double mouseY, int button) {
        if (this.layer > 0) {
            --this.layer;
        }
    }

    public void drawWidget(@NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int i = 0;
        switch (this.layer) {
            case 0: {
                int z;
                for (int y = 0; y < 3; ++y) {
                    for (z = 2; z >= 0; --z) {
                        for (int x = 0; x < 3; ++x) {
                            IRecipeSlotDrawable ingredient = this.ingredients.get(i);
                            if (!ingredient.isEmpty()) {
                                int tmpX = this.x + 32 - x * 8 - z * 8;
                                int tmpY = this.y + 74 + x * 4 - z * 4 - y * 32;
                                guiGraphics.m_280168_().m_85836_();
                                guiGraphics.m_280168_().m_252880_((float)tmpX, (float)tmpY, (float)(i * 5));
                                ingredient.draw(guiGraphics);
                                guiGraphics.m_280168_().m_85849_();
                            }
                            ++i;
                        }
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int z;
                i = (this.layer - 1) * 9;
                for (int x = 0; x < 3; ++x) {
                    for (z = 0; z < 3; ++z) {
                        IRecipeSlotDrawable ingredient = this.ingredients.get(i);
                        if (!ingredient.isEmpty()) {
                            this.jeiHelpers.getGuiHelper().getSlotDrawable().draw(guiGraphics, this.x + x * 18, this.y + 22 + z * 18);
                            guiGraphics.m_280168_().m_85836_();
                            guiGraphics.m_280168_().m_252880_((float)(this.x + 1 + x * 18), (float)(this.y + 23 + z * 18), (float)(i * 5));
                            ingredient.draw(guiGraphics);
                            guiGraphics.m_280168_().m_85849_();
                        }
                        ++i;
                    }
                }
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"emi.workspace_crafting.layer", (Object[])new Object[]{this.layer}), this.x + 1, this.y + 1, 0, false);
            }
        }
        for (ButtonWidget widget : this.buttonWidgets) {
            widget.drawWidget(guiGraphics, mouseX, mouseY);
        }
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, double mouseX, double mouseY) {
        if (this.layer > 0) {
            int i = (this.layer - 1) * 9;
            for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    IRecipeSlotDrawable ingredient = this.ingredients.get(i);
                    if (!ingredient.isEmpty() && mouseX >= (double)(this.x + 1 + x * 18) && mouseX < (double)(this.x + 1 + (x + 1) * 18) && mouseY >= (double)(this.y + 22 + z * 18) && mouseY < (double)(this.y + 22 + (z + 1) * 18)) {
                        ingredient.getTooltip(tooltip);
                    }
                    ++i;
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (ButtonWidget widget : this.buttonWidgets) {
            ScreenPosition bounds = widget.getPosition();
            if (!(mouseX > (double)bounds.f_263719_()) || !(mouseX < (double)(bounds.f_263719_() + 12)) || !(mouseY > (double)bounds.f_263694_()) || !(mouseY < (double)(bounds.f_263694_() + 10))) continue;
            return widget.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    @NotNull
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        RecipeSlotUnderMouse slot = null;
        if (this.layer > 0) {
            int i = (this.layer - 1) * 9;
            block0: for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    IRecipeSlotDrawable ingredient = this.ingredients.get(i);
                    if (!ingredient.isEmpty() && mouseX >= (double)(this.x + 1 + x * 18) && mouseX < (double)(this.x + 1 + (x + 1) * 18) && mouseY >= (double)(this.y + 22 + z * 18) && mouseY < (double)(this.y + 22 + (z + 1) * 18)) {
                        slot = new RecipeSlotUnderMouse(ingredient, this.x + 1 + x * 18, this.y + 22 + z * 18);
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        return Optional.ofNullable(slot);
    }

    @NotNull
    public ScreenPosition getPosition() {
        return new ScreenPosition(this.x, this.y);
    }

    @NotNull
    public ScreenRectangle getArea() {
        return new ScreenRectangle(this.x, this.y, this.x + 94, this.y + 97);
    }
}

