/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineItemStackHandler
extends ItemStackHandler {
    @NotNull
    private final List<SlotHolder> inputSlotHolder;
    @NotNull
    private final List<SlotHolder> outputSlotHolder;
    boolean outputOperation;

    MachineItemStackHandler(@NotNull List<SlotHolder> inputSlotHolder, @NotNull List<SlotHolder> outputSlotHolder, @NotNull NonNullList<ItemStack> stacks) {
        super(stacks);
        this.inputSlotHolder = inputSlotHolder;
        this.outputSlotHolder = outputSlotHolder;
    }

    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public int getX(int slot) {
        this.validateSlotIndex(slot);
        if (slot < this.inputSlotHolder.size()) {
            return this.inputSlotHolder.get(slot).x();
        }
        return this.outputSlotHolder.get(slot - this.inputSlotHolder.size()).x();
    }

    public int getY(int slot) {
        this.validateSlotIndex(slot);
        if (slot < this.inputSlotHolder.size()) {
            return this.inputSlotHolder.get(slot).y();
        }
        return this.outputSlotHolder.get(slot - this.inputSlotHolder.size()).y();
    }

    public int getInputSlots() {
        return this.inputSlotHolder.size();
    }

    public void outputOperation(Runnable runnable) {
        this.outputOperation = true;
        runnable.run();
        this.outputOperation = false;
    }

    public void setSize(int size) {
        if (size != this.getSlots()) {
            throw new IllegalStateException("Invalid size of slots, expected " + size + ", found " + this.getSlots());
        }
        this.stacks.clear();
    }

    record SlotHolder(int x, int y, TriPredicate<MachineItemStackHandler, Integer, ItemStack> isItemValid) {
    }

    public static interface TriPredicate<A, B, C> {
        public boolean test(A var1, B var2, C var3);
    }

    public static class Builder {
        final List<SlotHolder> inputSlotHolder = new ArrayList<SlotHolder>();
        final List<SlotHolder> outputSlotHolder = new ArrayList<SlotHolder>();
        @Nullable
        Runnable onChangeListener;

        public Builder addInputSlot(int x, int y, TriPredicate<MachineItemStackHandler, Integer, ItemStack> isItemValid) {
            this.inputSlotHolder.add(new SlotHolder(x, y, isItemValid));
            return this;
        }

        public Builder addInputSlot(int x, int y) {
            this.inputSlotHolder.add(new SlotHolder(x, y, (itemStackHandler, slot, itemStack) -> true));
            return this;
        }

        public Builder addOutputSlot(int x, int y) {
            this.outputSlotHolder.add(new SlotHolder(x, y, (itemStackHandler, slot, itemStack) -> true));
            return this;
        }

        public Builder setOnChangeListener(@NotNull Runnable onChangeListener) {
            this.onChangeListener = onChangeListener;
            return this;
        }

        public MachineItemStackHandler build() {
            NonNullList stacks = NonNullList.m_122780_((int)(this.inputSlotHolder.size() + this.outputSlotHolder.size()), (Object)ItemStack.f_41583_);
            return this.build((NonNullList<ItemStack>)stacks);
        }

        public MachineItemStackHandler build(NonNullList<ItemStack> stacks) {
            Objects.requireNonNull(this.onChangeListener, "Missing onChangeListener");
            if (stacks.size() != this.inputSlotHolder.size() + this.outputSlotHolder.size()) {
                throw new IllegalStateException("Stack count doesn't match slot count!");
            }
            return new MachineItemStackHandler(this.inputSlotHolder, this.outputSlotHolder, stacks){

                protected void onContentsChanged(int slot) {
                    onChangeListener.run();
                }

                public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                    if (this.outputOperation) {
                        return slot >= inputSlotHolder.size();
                    }
                    if (slot < inputSlotHolder.size()) {
                        return inputSlotHolder.get((int)slot).isItemValid.test(this, slot, stack);
                    }
                    return false;
                }
            };
        }
    }
}

