/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.IrrigationBlock;
import com.yanny.ytech.configuration.block_entity.AqueductBlockEntity;
import com.yanny.ytech.configuration.recipe.RemainingShapedRecipe;
import com.yanny.ytech.network.irrigation.IrrigationClientNetwork;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AqueductBlock
extends IrrigationBlock
implements BucketPickup,
LiquidBlockContainer {
    private static final VoxelShape SHAPE_BOTTOM = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    private static final VoxelShape SHAPE_NORTH_SIDE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.125);
    private static final VoxelShape SHAPE_EAST_SIDE = Shapes.m_83048_((double)0.875, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_SOUTH_SIDE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_WEST_SIDE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_NORTH_WEST_SIDE = Shapes.m_83113_((VoxelShape)SHAPE_WEST_SIDE, (VoxelShape)SHAPE_NORTH_SIDE, (BooleanOp)BooleanOp.f_82689_);
    private static final VoxelShape SHAPE_NORTH_EAST_SIDE = Shapes.m_83113_((VoxelShape)SHAPE_NORTH_SIDE, (VoxelShape)SHAPE_EAST_SIDE, (BooleanOp)BooleanOp.f_82689_);
    private static final VoxelShape SHAPE_SOUTH_EAST_SIDE = Shapes.m_83113_((VoxelShape)SHAPE_EAST_SIDE, (VoxelShape)SHAPE_SOUTH_SIDE, (BooleanOp)BooleanOp.f_82689_);
    private static final VoxelShape SHAPE_SOUTH_WEST_SIDE = Shapes.m_83113_((VoxelShape)SHAPE_SOUTH_SIDE, (VoxelShape)SHAPE_WEST_SIDE, (BooleanOp)BooleanOp.f_82689_);
    private static final BooleanProperty NORTH_EAST = BooleanProperty.m_61465_((String)"north_east");
    private static final BooleanProperty NORTH_WEST = BooleanProperty.m_61465_((String)"north_west");
    private static final BooleanProperty SOUTH_EAST = BooleanProperty.m_61465_((String)"south_east");
    private static final BooleanProperty SOUTH_WEST = BooleanProperty.m_61465_((String)"south_west");
    private final Map<BlockState, VoxelShape> shapesCache = this.m_152458_(AqueductBlock::calculateShape);
    private final MaterialType material;

    public AqueductBlock(MaterialType material) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50352_));
        this.material = material;
    }

    public int getCapacity() {
        return switch (this.material) {
            case MaterialType.MUDBRICK -> YTechMod.CONFIGURATION.getBaseFluidStoragePerBlock();
            case MaterialType.TERRACOTTA -> YTechMod.CONFIGURATION.getBaseFluidStoragePerBlock() * 2;
            case MaterialType.STONE -> YTechMod.CONFIGURATION.getBaseFluidStoragePerBlock() * 4;
            default -> throw new IllegalStateException(String.format("Missing material type %s", this.material));
        };
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shapesCache.get(state);
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{BlockStateProperties.f_61369_}).m_61104_(new Property[]{BlockStateProperties.f_61371_}).m_61104_(new Property[]{BlockStateProperties.f_61370_}).m_61104_(new Property[]{BlockStateProperties.f_61368_}).m_61104_(new Property[]{NORTH_EAST}).m_61104_(new Property[]{NORTH_WEST}).m_61104_(new Property[]{SOUTH_EAST}).m_61104_(new Property[]{SOUTH_WEST});
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        BlockState state = this.m_49966_();
        Level level = blockPlaceContext.m_43725_();
        BlockPos pos = blockPlaceContext.m_8083_();
        boolean hasNorthConnection = AqueductBlock.isValidForConnection((LevelAccessor)level, pos, Direction.NORTH);
        boolean hasEastConnection = AqueductBlock.isValidForConnection((LevelAccessor)level, pos, Direction.EAST);
        boolean hasSouthConnection = AqueductBlock.isValidForConnection((LevelAccessor)level, pos, Direction.SOUTH);
        boolean hasWestConnection = AqueductBlock.isValidForConnection((LevelAccessor)level, pos, Direction.WEST);
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(!hasNorthConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(!hasEastConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(!hasSouthConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(!hasWestConnection));
        state = (BlockState)state.m_61124_((Property)NORTH_WEST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide((LevelAccessor)level, pos.m_122024_(), BlockStateProperties.f_61368_) || AqueductBlock.hasSide((LevelAccessor)level, pos.m_122012_(), BlockStateProperties.f_61371_) || !hasWestConnection || !hasNorthConnection));
        state = (BlockState)state.m_61124_((Property)NORTH_EAST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide((LevelAccessor)level, pos.m_122012_(), BlockStateProperties.f_61369_) || AqueductBlock.hasSide((LevelAccessor)level, pos.m_122029_(), BlockStateProperties.f_61368_) || !hasNorthConnection || !hasEastConnection));
        state = (BlockState)state.m_61124_((Property)SOUTH_EAST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide((LevelAccessor)level, pos.m_122029_(), BlockStateProperties.f_61370_) || AqueductBlock.hasSide((LevelAccessor)level, pos.m_122019_(), BlockStateProperties.f_61369_) || !hasEastConnection || !hasSouthConnection));
        state = (BlockState)state.m_61124_((Property)SOUTH_WEST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide((LevelAccessor)level, pos.m_122019_(), BlockStateProperties.f_61371_) || AqueductBlock.hasSide((LevelAccessor)level, pos.m_122024_(), BlockStateProperties.f_61370_) || !hasSouthConnection || !hasWestConnection));
        return state;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        boolean hasNorthConnection = AqueductBlock.isValidForConnection(level, pos, Direction.NORTH);
        boolean hasEastConnection = AqueductBlock.isValidForConnection(level, pos, Direction.EAST);
        boolean hasSouthConnection = AqueductBlock.isValidForConnection(level, pos, Direction.SOUTH);
        boolean hasWestConnection = AqueductBlock.isValidForConnection(level, pos, Direction.WEST);
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(!hasNorthConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(!hasEastConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(!hasSouthConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(!hasWestConnection));
        state = (BlockState)state.m_61124_((Property)NORTH_WEST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide(level, pos.m_122024_(), BlockStateProperties.f_61368_) || AqueductBlock.hasSide(level, pos.m_122012_(), BlockStateProperties.f_61371_) || !hasWestConnection || !hasNorthConnection));
        state = (BlockState)state.m_61124_((Property)NORTH_EAST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide(level, pos.m_122012_(), BlockStateProperties.f_61369_) || AqueductBlock.hasSide(level, pos.m_122029_(), BlockStateProperties.f_61368_) || !hasNorthConnection || !hasEastConnection));
        state = (BlockState)state.m_61124_((Property)SOUTH_EAST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide(level, pos.m_122029_(), BlockStateProperties.f_61370_) || AqueductBlock.hasSide(level, pos.m_122019_(), BlockStateProperties.f_61369_) || !hasEastConnection || !hasSouthConnection));
        state = (BlockState)state.m_61124_((Property)SOUTH_WEST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide(level, pos.m_122019_(), BlockStateProperties.f_61371_) || AqueductBlock.hasSide(level, pos.m_122024_(), BlockStateProperties.f_61370_) || !hasSouthConnection || !hasWestConnection));
        return state;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        return new AqueductBlockEntity(pos, blockState, this.getCapacity());
    }

    @NotNull
    public ItemStack m_142598_(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = level.m_7702_(pos)) instanceof AqueductBlockEntity) {
            FluidTank tank;
            AqueductBlockEntity aqueductBlock = (AqueductBlockEntity)blockEntity;
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(aqueductBlock);
            if (network != null && (tank = network.getFluidHandler()).getFluidAmount() >= 1000) {
                tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                return new ItemStack((ItemLike)Items.f_42447_);
            }
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    public boolean m_6044_(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Fluid fluid) {
        return fluid == Fluids.f_76193_;
    }

    public boolean m_7361_(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidState) {
        BlockEntity blockEntity;
        if (fluidState.m_76152_() == Fluids.f_76193_ && !level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof AqueductBlockEntity) {
            AqueductBlockEntity aqueductBlock = (AqueductBlockEntity)blockEntity;
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(aqueductBlock);
            if (network != null) {
                FluidTank tank = network.getFluidHandler();
                tank.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return false;
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        BlockEntity blockEntity;
        if ((!(entity instanceof LivingEntity) || entity.m_146900_().m_60713_((Block)this)) && (blockEntity = level.m_7702_(pos)) instanceof AqueductBlockEntity) {
            AqueductBlockEntity aqueductBlockEntity = (AqueductBlockEntity)blockEntity;
            double multiplier = 0.5;
            if (level.f_46443_) {
                IrrigationClientNetwork network = YTechMod.IRRIGATION_PROPAGATOR.client().getNetwork(aqueductBlockEntity);
                if (network != null && network.getCapacity() > 0) {
                    multiplier = Mth.m_14008_((double)((1.0 - (double)network.getAmount() / (double)network.getCapacity()) * 0.5), (double)0.0, (double)0.5);
                    if (entity.m_6060_()) {
                        entity.m_252836_();
                    }
                }
            } else {
                IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(aqueductBlockEntity);
                if (network != null && network.getFluidHandler().getCapacity() > 0) {
                    multiplier = Mth.m_14008_((double)((1.0 - (double)network.getFluidHandler().getFluidAmount() / (double)network.getFluidHandler().getCapacity()) * 0.5), (double)0.0, (double)0.5);
                    if (entity.m_6060_()) {
                        entity.m_252836_();
                    }
                }
            }
            entity.m_20256_(entity.m_20184_().m_82559_(new Vec3(0.5 + multiplier, 1.0, 0.5 + multiplier)));
        }
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    public boolean m_7420_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return false;
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return YTechMod.CONFIGURATION.isValidBlockForRaining();
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AqueductBlockEntity) {
            AqueductBlockEntity blockEntity2 = (AqueductBlockEntity)blockEntity;
            blockEntity2.onRandomTick();
        }
    }

    @Override
    public List<BlockPos> getValidNeighbors(@NotNull BlockState blockState, @NotNull BlockPos pos) {
        return Direction.Plane.HORIZONTAL.m_122557_().map(dir -> pos.m_121955_(dir.m_122436_())).toList();
    }

    public static void registerModel(@NotNull BlockStateProvider provider, @NotNull RegistryObject<Block> block, MaterialType material) {
        ResourceLocation bricks = switch (material) {
            case MaterialType.MUDBRICK -> Utils.mcBlockLoc("mud_bricks");
            case MaterialType.TERRACOTTA -> Utils.modBlockLoc("terracotta_bricks");
            case MaterialType.STONE -> Utils.mcBlockLoc("stone_bricks");
            default -> throw new IllegalStateException();
        };
        String name = Utils.getPath(block);
        ModelBuilder base = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name)).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 14.0f, 16.0f, 16.0f).texture("#0").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#0").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 2.0f, 16.0f).end()).texture("particle", bricks)).texture("0", bricks);
        ModelBuilder side = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_side")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case SOUTH: {
                    faceBuilder.uvs(2.0f, 0.0f, 14.0f, 14.0f).texture("#0");
                    break;
                }
                case NORTH: {
                    faceBuilder.uvs(2.0f, 0.0f, 14.0f, 14.0f).texture("#0").cullface(direction);
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 14.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(2.0f, 0.0f, 14.0f, 2.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).texture("#0").cullface(direction);
                }
            }
        }).from(2.0f, 2.0f, 0.0f).to(14.0f, 16.0f, 2.0f).end()).texture("particle", bricks)).texture("0", bricks);
        ModelBuilder edge = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_edge")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#0").cullface(direction);
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 14.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 14.0f).texture("#0").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(2.0f, 0.0f, 4.0f, 2.0f).texture("#0").cullface(direction);
                }
            }
        }).from(0.0f, 2.0f, 0.0f).to(2.0f, 16.0f, 2.0f).end()).texture("particle", bricks)).texture("0", bricks);
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)provider.getMultipartBuilder((Block)block.get()).part().modelFile((ModelFile)base).addModel()).end();
        PROPERTY_BY_DIRECTION.forEach((arg_0, arg_1) -> AqueductBlock.lambda$registerModel$4(builder, (ModelFile)side, arg_0, arg_1));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)edge).rotationY(((Integer)ANGLE_BY_DIRECTION.get(Direction.NORTH)).intValue()).addModel()).condition((Property)NORTH_WEST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)edge).rotationY(((Integer)ANGLE_BY_DIRECTION.get(Direction.EAST)).intValue()).addModel()).condition((Property)NORTH_EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)edge).rotationY(((Integer)ANGLE_BY_DIRECTION.get(Direction.SOUTH)).intValue()).addModel()).condition((Property)SOUTH_EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)edge).rotationY(((Integer)ANGLE_BY_DIRECTION.get(Direction.WEST)).intValue()).addModel()).condition((Property)SOUTH_WEST, (Comparable[])new Boolean[]{true}).end();
        ModelBuilder itemModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_inventory")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 14.0f, 16.0f, 16.0f).texture("#0");
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#0");
                }
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 2.0f, 16.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 14.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 2.0f).texture("#0");
                }
            }
        }).from(0.0f, 2.0f, 0.0f).to(16.0f, 16.0f, 2.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 14.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 2.0f).texture("#0");
                }
            }
        }).from(0.0f, 2.0f, 14.0f).to(16.0f, 16.0f, 16.0f).end()).texture("particle", bricks)).texture("0", bricks);
        ((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)itemModel);
    }

    public static void registerRecipe(Consumer<FinishedRecipe> recipeConsumer, RegistryObject<Item> item, MaterialType material) {
        switch (material) {
            case MUDBRICK: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get(), 2).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_220186_).m_126130_("# #").m_126130_("# #").m_126130_("###").m_126132_(Utils.getHasName(), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)Items.f_220186_)).m_126140_(recipeConsumer, Utils.modLoc(item));
                break;
            }
            case TERRACOTTA: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get(), 2).m_206416_(Character.valueOf('#'), YTechItemTags.TERRACOTTA_BRICKS).m_206416_(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).m_126130_("# #").m_126130_("#H#").m_126130_("###").m_126132_(Utils.getHasName(), (CriterionTriggerInstance)RecipeProvider.m_206406_(YTechItemTags.TERRACOTTA_BRICKS)).m_126140_(recipeConsumer, Utils.modLoc(item));
                break;
            }
            case STONE: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get(), 2).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42018_).m_206416_(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).m_126130_("# #").m_126130_("#H#").m_126130_("###").m_126132_(Utils.getHasName(), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)Items.f_42018_)).m_126140_(recipeConsumer, Utils.modLoc(item));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static boolean hasSide(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BooleanProperty property) {
        BlockState blockState = level.m_8055_(pos);
        boolean isIrrigation = blockState.m_60734_() instanceof AqueductBlock;
        return isIrrigation && blockState.m_61138_((Property)property) && (Boolean)blockState.m_61143_((Property)property) != false;
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape shape = SHAPE_BOTTOM;
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH_SIDE, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_EAST_SIDE, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH_SIDE, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_WEST_SIDE, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)NORTH_WEST)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH_WEST_SIDE, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)NORTH_EAST)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH_EAST_SIDE, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH_EAST)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH_EAST_SIDE, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH_WEST)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH_WEST_SIDE, (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    private static /* synthetic */ void lambda$registerModel$4(MultiPartBlockStateBuilder builder, ModelFile side, Direction dir, BooleanProperty value) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(((Integer)ANGLE_BY_DIRECTION.get(dir)).intValue()).addModel()).condition((Property)value, (Comparable[])new Boolean[]{true}).end();
    }
}

