/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.IrrigationBlock;
import com.yanny.ytech.configuration.block_entity.AqueductConsumerBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AqueductConsumerBlock
extends IrrigationBlock {
    public static final BooleanProperty ACTIVATED = BooleanProperty.m_61465_((String)"activated");

    public AqueductConsumerBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50352_));
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public boolean m_7420_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return false;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
        Level level = blockPlaceContext.m_43725_();
        BlockPos pos = blockPlaceContext.m_8083_();
        boolean hasNorthConnection = AqueductConsumerBlock.isValidForConnection((LevelAccessor)level, pos, Direction.NORTH);
        boolean hasEastConnection = AqueductConsumerBlock.isValidForConnection((LevelAccessor)level, pos, Direction.EAST);
        boolean hasSouthConnection = AqueductConsumerBlock.isValidForConnection((LevelAccessor)level, pos, Direction.SOUTH);
        boolean hasWestConnection = AqueductConsumerBlock.isValidForConnection((LevelAccessor)level, pos, Direction.WEST);
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(hasNorthConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(hasEastConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(hasSouthConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(hasWestConnection));
        return state;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        boolean hasNorthConnection = AqueductConsumerBlock.isValidForConnection(level, pos, Direction.NORTH);
        boolean hasEastConnection = AqueductConsumerBlock.isValidForConnection(level, pos, Direction.EAST);
        boolean hasSouthConnection = AqueductConsumerBlock.isValidForConnection(level, pos, Direction.SOUTH);
        boolean hasWestConnection = AqueductConsumerBlock.isValidForConnection(level, pos, Direction.WEST);
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(hasNorthConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(hasEastConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(hasSouthConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(hasWestConnection));
        return state;
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        BlockEntity blockEntity;
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof AqueductConsumerBlockEntity) {
            AqueductConsumerBlockEntity blockEntity2 = (AqueductConsumerBlockEntity)blockEntity;
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(blockEntity2);
            if (network != null) {
                blockEntity2.neighborChanged();
            }
        }
    }

    @Override
    public List<BlockPos> getValidNeighbors(@NotNull BlockState blockState, @NotNull BlockPos pos) {
        return Direction.Plane.HORIZONTAL.m_122557_().map(dir -> pos.m_121955_(dir.m_122436_())).toList();
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        AqueductConsumerBlockEntity hydratorBlock;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AqueductConsumerBlockEntity && (hydratorBlock = (AqueductConsumerBlockEntity)blockEntity).isHydrating() && random.m_188503_(10) == 0) {
            level.m_245747_(pos, SoundEvents.f_12540_, SoundSource.BLOCKS, random.m_188501_() * 0.25f + 0.75f, random.m_188501_() + 0.5f, false);
        }
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{BlockStateProperties.f_61369_}).m_61104_(new Property[]{BlockStateProperties.f_61371_}).m_61104_(new Property[]{BlockStateProperties.f_61370_}).m_61104_(new Property[]{BlockStateProperties.f_61368_}).m_61104_(new Property[]{ACTIVATED});
    }

    protected static void createAqueductConsumerTicker(@NotNull Level level, @NotNull BlockEntity blockEntity) {
        if (blockEntity instanceof AqueductConsumerBlockEntity) {
            AqueductConsumerBlockEntity block = (AqueductConsumerBlockEntity)blockEntity;
            block.tick((ServerLevel)level);
        }
    }
}

