/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.IrrigationBlock;
import com.yanny.ytech.configuration.block_entity.AqueductValveBlockEntity;
import com.yanny.ytech.configuration.recipe.RemainingShapedRecipe;
import com.yanny.ytech.network.generic.NetworkUtils;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AqueductValveBlock
extends IrrigationBlock {
    public AqueductValveBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50352_));
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        return new AqueductValveBlockEntity(pos, blockState);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public boolean m_7420_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return false;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_8125_().m_122427_());
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        BlockEntity blockEntity;
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof AqueductValveBlockEntity) {
            AqueductValveBlockEntity blockEntity2 = (AqueductValveBlockEntity)blockEntity;
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(blockEntity2);
            if (network != null) {
                blockEntity2.neighborChanged();
            }
        }
    }

    @Override
    public List<BlockPos> getValidNeighbors(@NotNull BlockState blockState, @NotNull BlockPos pos) {
        return NetworkUtils.getDirections(List.of(Direction.EAST, Direction.WEST), pos, (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_));
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        AqueductValveBlockEntity valveBlockEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AqueductValveBlockEntity && (valveBlockEntity = (AqueductValveBlockEntity)blockEntity).getFlow() > 0 && random.m_188503_(10) == 0) {
            level.m_245747_(pos, SoundEvents.f_12540_, SoundSource.BLOCKS, random.m_188501_() * 0.25f + 0.75f, random.m_188501_() + 0.5f, false);
        }
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return true;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AqueductValveBlockEntity) {
            AqueductValveBlockEntity blockEntity2 = (AqueductValveBlockEntity)blockEntity;
            blockEntity2.randomTick(level);
        }
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ResourceLocation valveTexture = Utils.modBlockLoc("aqueduct/aqueduct_valve");
        ResourceLocation bricksTexture = Utils.modBlockLoc("terracotta_bricks");
        String name = Utils.getPath(YTechBlocks.AQUEDUCT_VALVE);
        ModelBuilder model = ((BlockModelBuilder)provider.models().cube(name, bricksTexture, bricksTexture, bricksTexture, bricksTexture, valveTexture, valveTexture)).texture("particle", valveTexture);
        provider.horizontalBlock((Block)YTechBlocks.AQUEDUCT_VALVE.get(), (ModelFile)model);
        ((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)model);
    }

    public static void registerRecipe(Consumer<FinishedRecipe> recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechBlocks.AQUEDUCT_VALVE.get()).m_206416_(Character.valueOf('#'), YTechItemTags.TERRACOTTA_BRICKS).m_206416_(Character.valueOf('R'), YTechItemTags.RODS.tag).m_206416_(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).m_206416_(Character.valueOf('S'), YTechItemTags.SAWS.tag).m_126130_("###").m_126130_("HRS").m_126130_("###").m_126132_(Utils.getHasName(), (CriterionTriggerInstance)RecipeProvider.m_206406_(YTechItemTags.TERRACOTTA_BRICKS)).m_126140_(recipeConsumer, Utils.modLoc(YTechBlocks.AQUEDUCT_VALVE));
    }
}

