/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.recipe.RemainingShapedRecipe;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrassBedBlock
extends HorizontalDirectionalBlock {
    private static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public GrassBedBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60978_(0.2f).m_60955_().m_278183_().m_278166_(PushReaction.DESTROY));
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (pState.m_61143_((Property)BedBlock.f_49440_) != BedPart.HEAD && !(pState = pLevel.m_8055_(pPos = pPos.m_121945_((Direction)pState.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!BedBlock.m_49488_((Level)pLevel)) {
            pLevel.m_7471_(pPos, false);
            BlockPos pos = pPos.m_121945_(((Direction)pState.m_61143_((Property)f_54117_)).m_122424_());
            if (pLevel.m_8055_(pos).m_60713_((Block)this)) {
                pLevel.m_7471_(pos, false);
            }
            Vec3 center = pPos.m_252807_();
            pLevel.m_254951_(null, pLevel.m_269111_().m_269488_(center), null, center, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)pState.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(pLevel, pPos)) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        pPlayer.m_7720_(pPos).ifLeft(sleepingProblem -> {
            if (sleepingProblem.m_36423_() != null) {
                pPlayer.m_5661_(sleepingProblem.m_36423_(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    private boolean kickVillagerOutOfBed(Level pLevel, BlockPos pPos) {
        List villagers = pLevel.m_6443_(Villager.class, new AABB(pPos), LivingEntity::m_5803_);
        if (villagers.isEmpty()) {
            return false;
        }
        ((Villager)villagers.get(0)).m_5796_();
        return true;
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (pFacing == GrassBedBlock.getNeighbourDirection((BedPart)pState.m_61143_((Property)BedBlock.f_49440_), (Direction)pState.m_61143_((Property)f_54117_))) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_((Property)BedBlock.f_49440_) != pState.m_61143_((Property)BedBlock.f_49440_) ? (BlockState)pState.m_61124_((Property)BedBlock.f_49441_, (Comparable)((Boolean)pFacingState.m_61143_((Property)BedBlock.f_49441_))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private static Direction getNeighbourDirection(BedPart pPart, Direction pDirection) {
        return pPart == BedPart.FOOT ? pDirection : pDirection.m_122424_();
    }

    public void m_5707_(Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart part;
        if (!pLevel.f_46443_ && pPlayer.m_7500_() && (part = (BedPart)pState.m_61143_((Property)BedBlock.f_49440_)) == BedPart.FOOT && (blockState = pLevel.m_8055_(blockPos = pPos.m_121945_(GrassBedBlock.getNeighbourDirection(part, (Direction)pState.m_61143_((Property)f_54117_))))).m_60713_((Block)this) && blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
            pLevel.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            pLevel.m_5898_(pPlayer, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_8125_();
        BlockPos clickedPos = pContext.m_8083_();
        BlockPos relative = clickedPos.m_121945_(direction);
        Level level = pContext.m_43725_();
        return level.m_8055_(relative).m_60629_(pContext) && level.m_6857_().m_61937_(relative) ? (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.FOOT)).m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(false)) : null;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return BASE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, BedBlock.f_49440_, BedBlock.f_49441_});
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @javax.annotation.Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.f_46443_) {
            BlockPos pos = pPos.m_121945_((Direction)pState.m_61143_((Property)f_54117_));
            pLevel.m_7731_(pos, (BlockState)pState.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD), 3);
            pLevel.m_6289_(pPos, Blocks.f_50016_);
            pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
        }
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        String name = Utils.getPath(YTechBlocks.GRASS_BED);
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name)).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case EAST: {
                    faceBuilder.uvs(9.0f, 2.0f, 11.0f, 16.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#1");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(1.0f, 2.0f, 3.0f, 14.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#1");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(9.0f, 0.0f, 11.0f, 14.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#1");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 12.0f, 14.0f).texture("#1");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 12.0f, 14.0f).texture("#1").cullface(direction);
                }
            }
        }).from(2.0f, 0.0f, 0.0f).to(14.0f, 2.0f, 14.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 4.0f, 16.0f, 10.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#0");
                }
            }
        }).from(13.0f, 0.0f, 0.0f).to(19.0f, 0.0f, 16.0f).rotation().angle(22.5f).axis(Direction.Axis.Z).origin(8.0f, 0.0f, 8.0f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 4.0f, 16.0f, 10.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#0");
                }
            }
        }).from(-3.0f, 0.0f, -1.0f).to(3.0f, 0.0f, 15.0f).rotation().angle(-22.5f).axis(Direction.Axis.Z).origin(8.0f, 0.0f, 8.0f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case UP: {
                    faceBuilder.uvs(0.0f, 3.0f, 16.0f, 9.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 3.0f, 16.0f, 9.0f).texture("#0");
                }
            }
        }).from(0.0f, 0.0f, 13.0f).to(16.0f, 0.0f, 19.0f).rotation().angle(-22.5f).axis(Direction.Axis.X).origin(8.0f, 0.0f, 8.0f).end().end()).renderType("minecraft:cutout")).texture("particle", Utils.modBlockLoc("thatch"))).texture("0", Utils.modBlockLoc("dried_grass"))).texture("1", Utils.modBlockLoc("thatch"));
        ((ItemModelBuilder)((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)provider.itemModels().getExistingFile(Utils.mcItemLoc("generated")))).texture("layer0", Utils.modItemLoc("grass_bed"));
        provider.getVariantBuilder((Block)YTechBlocks.GRASS_BED.get()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.FOOT).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).build()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.FOOT).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(90).build()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.FOOT).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(180).build()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.FOOT).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(270).build()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.HEAD).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(180).build()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.HEAD).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(270).build()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.HEAD).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).build()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.HEAD).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(90).build());
    }

    public static void registerLootTable(@NotNull BlockLootSubProvider provider) {
        provider.m_246481_((Block)YTechBlocks.GRASS_BED.get(), b -> provider.m_245178_(b, (Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD));
    }

    public static void registerRecipe(Consumer<FinishedRecipe> recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechBlocks.GRASS_BED.get()).m_206416_(Character.valueOf('G'), YTechItemTags.THATCH_SLABS).m_206416_(Character.valueOf('S'), YTechItemTags.GRASS_FIBERS).m_126130_("SSS").m_126130_("GGG").m_126130_("GGG").m_126132_(Utils.getHasName(), (CriterionTriggerInstance)RecipeProvider.m_206406_(YTechItemTags.THATCH_SLABS)).m_126140_(recipeConsumer, Utils.modLoc(YTechBlocks.GRASS_BED));
    }
}

