/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.ToolRackBlockEntity;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolRackBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE_WEST = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_EAST = Shapes.m_83048_((double)0.875, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.125);
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)1.0);

    public ToolRackBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_));
    }

    public boolean m_7420_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)HORIZONTAL_FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> throw new IllegalStateException();
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_EAST;
            case Direction.EAST -> SHAPE_WEST;
        };
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ToolRackBlockEntity(blockPos, blockState);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional = level.m_141902_(pos, (BlockEntityType)YTechBlockEntityTypes.TOOL_RACK.get());
        if (optional.isPresent()) {
            return ((ToolRackBlockEntity)((Object)optional.get())).onUse(level, pos, player, hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && !level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ToolRackBlockEntity) {
            ToolRackBlockEntity toolRackBlockEntity = (ToolRackBlockEntity)blockEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, toolRackBlockEntity.getItems());
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HORIZONTAL_FACING});
    }

    public static int getIndex(int @Nullable [] position) {
        if (ToolRackBlock.validPosition(position)) {
            return position[1] * 4 + position[0];
        }
        return -1;
    }

    public static int @Nullable [] getPosition(BlockHitResult hit) {
        BlockPos pos = hit.m_82425_();
        Vec3 position = hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (hit.m_82434_().m_122434_() == Direction.Axis.X) {
            position = new Vec3(position.f_82481_, position.f_82480_, position.f_82479_);
        }
        if (hit.m_82434_().m_122421_() == Direction.AxisDirection.NEGATIVE) {
            position = new Vec3(1.0 - position.f_82479_, position.f_82480_, position.f_82481_);
        }
        int x = (int)Math.floor(position.f_82479_ * 4.0);
        int y = (int)Math.floor(position.f_82480_ * 4.0);
        if (x >= 0 && x < 4 && y >= 0 && y < 4) {
            return new int[]{x, y};
        }
        return null;
    }

    public static int @Nullable [] getPosition(int index) {
        if (index >= 0 && index < 16) {
            int y = index / 4;
            int x = index %= 4;
            return new int[]{x, y};
        }
        return null;
    }

    public static boolean validPosition(int @Nullable [] position) {
        return position != null && position[0] >= 0 && position[0] < 4 && position[1] >= 0 && position[1] < 4;
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.TOOL_RACK))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#0");
                    break;
                }
                case WEST: 
                case EAST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 16.0f).texture("#1").cullface(direction);
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#1").cullface(direction);
                    break;
                }
                case DOWN: 
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 2.0f).texture("#1").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 14.0f).to(16.0f, 16.0f, 16.0f).end()).texture("particle", Utils.modBlockLoc("tool_rack/tool_rack_back"))).texture("0", Utils.modBlockLoc("tool_rack/tool_rack"))).texture("1", Utils.modBlockLoc("tool_rack/tool_rack_back"));
        provider.horizontalBlock((Block)YTechBlocks.TOOL_RACK.get(), (ModelFile)model);
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.TOOL_RACK))).parent((ModelFile)model);
    }
}

