/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.AqueductBlock;
import com.yanny.ytech.configuration.block_entity.IrrigationBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.network.irrigation.NetworkType;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AqueductBlockEntity
extends IrrigationBlockEntity {
    public static final String TAG_CAPACITY = "capacity";
    private int capacity;
    @NotNull
    private final AABB renderBox;
    @Nullable
    private LazyOptional<IFluidHandler> lazyFluidHandler;

    public AqueductBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        this(pos, blockState, 0);
    }

    public AqueductBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState, int capacity) {
        super((BlockEntityType<? extends BlockEntity>)((BlockEntityType)YTechBlockEntityTypes.AQUEDUCT.get()), pos, blockState, ((AqueductBlock)blockState.m_60734_()).getValidNeighbors(blockState, pos));
        this.capacity = capacity;
        this.renderBox = new AABB(pos, pos.m_7918_(1, 1, 1));
    }

    @Override
    public void onLoad() {
        IrrigationServerNetwork network;
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(this)) != null) {
            this.lazyFluidHandler = LazyOptional.of(network::getFluidHandler);
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public NetworkType getNetworkType() {
        return NetworkType.STORAGE;
    }

    @Override
    public boolean validForRainFilling() {
        if (this.f_58857_ instanceof ServerLevel) {
            Holder biome = this.f_58857_.m_204166_(this.f_58858_);
            return !YTechMod.CONFIGURATION.isValidBlockForRaining() || this.f_58857_.m_45527_(this.f_58858_.m_7494_()) && ((Biome)biome.get()).m_264600_(this.f_58858_) == Biome.Precipitation.RAIN;
        }
        return false;
    }

    @Override
    public boolean validForDripping() {
        ServerLevel serverLevel;
        BlockPos pos;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel && (pos = PointedDripstoneBlock.m_154055_((Level)(serverLevel = (ServerLevel)level), (BlockPos)this.f_58858_)) != null) {
            Fluid fluid = PointedDripstoneBlock.m_221849_((ServerLevel)serverLevel, (BlockPos)pos);
            return fluid != Fluids.f_76191_ && fluid.m_6212_((Fluid)Fluids.f_76193_);
        }
        return false;
    }

    public AABB getRenderBoundingBox() {
        return this.renderBox;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.lazyFluidHandler != null) {
            return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.lazyFluidHandler);
        }
        return LazyOptional.empty();
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.capacity = tag.m_128451_(TAG_CAPACITY);
    }

    public void onRandomTick() {
        YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_CAPACITY, this.capacity);
    }
}

