/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.AqueductConsumerBlock;
import com.yanny.ytech.configuration.block_entity.AqueductConsumerBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ticket.AABBTicket;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class AqueductHydratorBlockEntity
extends AqueductConsumerBlockEntity {
    private static final String TAG_TIMER = "timer";
    protected int timer = 0;
    private AABBTicket ticket = null;

    public AqueductHydratorBlockEntity(@NotNull BlockEntityType<? extends BlockEntity> entityType, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        super(entityType, pos, blockState);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.timer = tag.m_128451_(TAG_TIMER);
    }

    @Override
    public void tick(@NotNull ServerLevel level) {
        if (this.ticket == null) {
            this.ticket = this.createTicket(level);
        }
        if (!(this.isHydrating() && this.timer != 0 || level.m_46467_() % 20L != 0L)) {
            if (this.drainLiquid(level)) {
                BlockState blockState = (BlockState)this.m_58900_().m_61124_((Property)AqueductConsumerBlock.ACTIVATED, (Comparable)Boolean.valueOf(true));
                if (this.ticket == null) {
                    this.ticket = this.createTicket(level);
                } else {
                    this.ticket.validate();
                }
                this.timer = YTechMod.CONFIGURATION.getHydratorDrainPerNthTick();
                level.m_7731_(this.f_58858_, blockState, 3);
                YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
            }
        } else if (this.timer > 0) {
            --this.timer;
            if (this.timer == 0) {
                if (!this.drainLiquid(level)) {
                    BlockState blockState = (BlockState)this.m_58900_().m_61124_((Property)AqueductConsumerBlock.ACTIVATED, (Comparable)Boolean.valueOf(false));
                    if (this.ticket != null) {
                        this.ticket.invalidate();
                    }
                    level.m_7731_(this.f_58858_, blockState, 3);
                    YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
                } else {
                    this.timer = YTechMod.CONFIGURATION.getHydratorDrainPerNthTick();
                }
            } else {
                AqueductHydratorBlockEntity.m_155232_((Level)level, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
            }
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_TIMER, this.timer);
    }

    protected boolean drainLiquid(@NotNull ServerLevel level) {
        IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(this);
        if (network != null) {
            int amount = YTechMod.CONFIGURATION.getHydratorDrainAmount();
            if (network.getFluidHandler().drain(new FluidStack((Fluid)Fluids.f_76193_, amount), IFluidHandler.FluidAction.SIMULATE).getAmount() == amount) {
                network.getFluidHandler().drain(new FluidStack((Fluid)Fluids.f_76193_, amount), IFluidHandler.FluidAction.EXECUTE);
                AqueductHydratorBlockEntity.m_155232_((Level)level, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
                return true;
            }
        }
        return false;
    }

    private AABBTicket createTicket(ServerLevel level) {
        return FarmlandWaterManager.addAABBTicket((Level)level, (AABB)AABB.m_165882_((Vec3)this.f_58858_.m_252807_(), (double)9.0, (double)1.0, (double)9.0));
    }
}

