/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.AqueductValveBlock;
import com.yanny.ytech.configuration.block_entity.IrrigationBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.network.irrigation.NetworkType;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AqueductValveBlockEntity
extends IrrigationBlockEntity {
    private static final String TAG_FLOW = "flow";
    private int flow = 0;

    public AqueductValveBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        super((BlockEntityType<? extends BlockEntity>)((BlockEntityType)YTechBlockEntityTypes.AQUEDUCT_VALVE.get()), pos, blockState, ((AqueductValveBlock)blockState.m_60734_()).getValidNeighbors(blockState, pos));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.flow = tag.m_128451_(TAG_FLOW);
    }

    @Override
    protected void onLevelSet(@NotNull ServerLevel level) {
        this.flow = this.calculateFlow(level);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public int getFlow() {
        return this.flow;
    }

    @Override
    @NotNull
    public NetworkType getNetworkType() {
        return NetworkType.PROVIDER;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_FLOW, this.flow);
    }

    public void neighborChanged() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            int oldValue = this.flow;
            this.flow = this.calculateFlow((ServerLevel)this.f_58857_);
            if (oldValue != this.flow) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
        }
    }

    public void randomTick(@NotNull ServerLevel level) {
        IrrigationServerNetwork network;
        if (this.flow > 0 && (network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(this)) != null && level.f_46441_.m_188503_(YTechMod.CONFIGURATION.getValveChanceToDrainWater()) == 0 && network.getFluidHandler().getFluidAmount() + YTechMod.CONFIGURATION.getValveFillAmount() <= network.getFluidHandler().getCapacity()) {
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            for (BlockPos pos : this.getValidNeighbors()) {
                BlockState blockState = level.m_8055_(pos);
                FluidState fluidState = blockState.m_60819_();
                if (!fluidState.m_192917_((Fluid)Fluids.f_76193_) && !fluidState.m_192917_((Fluid)Fluids.f_76192_)) continue;
                checkedBlocks.add(pos);
                BlockPos waterPos = fluidState.m_76170_() ? pos : this.findWaterSource(0, level, pos, checkedBlocks);
                if (waterPos == null) continue;
                BlockState waterBlockState = level.m_8055_(waterPos);
                if (waterBlockState.m_60713_(Blocks.f_49990_)) {
                    level.m_46597_(waterPos, Blocks.f_50016_.m_49966_());
                } else if (waterBlockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    level.m_46597_(waterPos, (BlockState)waterBlockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                }
                this.neighborChanged();
                return;
            }
        }
    }

    private int calculateFlow(@NotNull ServerLevel level) {
        return this.getValidNeighbors().stream().anyMatch(pos -> {
            BlockState blockState = level.m_8055_(pos);
            if (blockState.m_60734_() == Blocks.f_49990_) {
                FluidState fluidState = blockState.m_60819_();
                return !fluidState.m_61138_((Property)FlowingFluid.f_75947_) || (Boolean)fluidState.m_61143_((Property)FlowingFluid.f_75947_) == false;
            }
            return false;
        }) ? YTechMod.CONFIGURATION.getValveFillAmount() : 0;
    }

    @Nullable
    private BlockPos findWaterSource(int waterLevel, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Set<BlockPos> checkedBlocks) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos waterPos;
            BlockPos offsetPos = pos.m_121955_(direction.m_122436_());
            BlockState blockState = level.m_8055_(offsetPos);
            FluidState fluidState = blockState.m_60819_();
            if (!fluidState.m_192917_((Fluid)Fluids.f_76193_) && !fluidState.m_192917_((Fluid)Fluids.f_76192_) || checkedBlocks.contains(offsetPos)) continue;
            checkedBlocks.add(offsetPos);
            if (fluidState.m_76170_()) {
                return offsetPos;
            }
            if ((Integer)fluidState.m_61143_((Property)BlockStateProperties.f_61420_) <= waterLevel || (waterPos = this.findWaterSource((Integer)fluidState.m_61143_((Property)BlockStateProperties.f_61420_), level, offsetPos, checkedBlocks)) == null) continue;
            return waterPos;
        }
        return null;
    }
}

