/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block_entity.SimpleProgressHandler;
import com.yanny.ytech.configuration.recipe.DryingRecipe;
import com.yanny.ytech.registration.YTechBiomeTags;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class DryingRackBlockEntity
extends BlockEntity
implements BlockEntityTicker<DryingRackBlockEntity> {
    private final SimpleProgressHandler<DryingRecipe> progressHandler = new SimpleProgressHandler((RecipeType)YTechRecipeTypes.DRYING.get());

    public DryingRackBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.DRYING_RACK.get(), pos, blockState);
    }

    public int getProgress() {
        return this.progressHandler.getProgress();
    }

    public ItemStack getItem() {
        return this.progressHandler.getItem();
    }

    public InteractionResult onUse(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (!level.f_46443_) {
            ItemStack holdingItemStack = player.m_21120_(hand);
            if (this.progressHandler.isEmpty()) {
                this.progressHandler.setupCrafting(level, holdingItemStack, DryingRecipe::dryingTime);
            } else {
                Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)this.progressHandler.getItem());
                this.progressHandler.clear();
            }
            level.m_7260_(pos, state, state, 3);
            level.m_151543_(pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull DryingRackBlockEntity blockEntity) {
        Function<DryingRecipe, Boolean> canProcess = recipe -> !level.m_46471_() || !YTechMod.CONFIGURATION.noDryingDuringRain();
        Function<DryingRecipe, Float> getStep = recipe -> {
            Holder biome = level.m_204166_(pos);
            if (biome.m_203656_(YTechBiomeTags.SLOW_DRYING_BIOMES)) {
                return Float.valueOf(0.5f);
            }
            if (biome.m_203656_(YTechBiomeTags.FAST_DRYING_BIOMES)) {
                return Float.valueOf(2.0f);
            }
            return Float.valueOf(1.0f);
        };
        BiConsumer<Container, DryingRecipe> onFinish = (container, recipe) -> {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)recipe.m_5874_((Container)container, level.m_9598_()));
            level.m_7260_(pos, state, state, 3);
            level.m_151543_(pos);
        };
        if (this.progressHandler.tick(level, canProcess, getStep, onFinish, xva$0 -> new SimpleContainer(new ItemStack[]{xva$0}))) {
            DryingRackBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.progressHandler.load(tag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.progressHandler.save(tag);
    }
}

