/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.google.common.collect.ImmutableList;
import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.WellPulleyBlock;
import com.yanny.ytech.configuration.block_entity.IrrigationBlockEntity;
import com.yanny.ytech.network.irrigation.NetworkType;
import com.yanny.ytech.registration.YTechBiomeTags;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechSoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import org.jetbrains.annotations.NotNull;

public class WellPulleyBlockEntity
extends IrrigationBlockEntity {
    private static final String TAG_TIMER = "timer";
    private static final PerlinSimplexNoise WATER_SOURCE_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(5432L)), (List)ImmutableList.of((Object)0));
    protected int timer = 0;
    private int cachedFlow = -1;

    public WellPulleyBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        super((BlockEntityType<? extends BlockEntity>)((BlockEntityType)YTechBlockEntityTypes.WELL_PULLEY.get()), pos, blockState, ((WellPulleyBlock)blockState.m_60734_()).getValidNeighbors(blockState, pos));
    }

    @Override
    public int getFlow() {
        if (this.f_58857_ != null) {
            BlockState blockState = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
            if (this.cachedFlow < 0) {
                this.cachedFlow = this.getNoiseFlow(this.f_58857_);
            }
            if (blockState.m_60713_((Block)YTechBlocks.WELL_PULLEY.get())) {
                return (Boolean)this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_61143_((Property)WellPulleyBlock.ACTIVATED) != false ? this.cachedFlow : 0;
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public NetworkType getNetworkType() {
        return NetworkType.PROVIDER;
    }

    @NotNull
    public InteractionResult onUse(@NotNull Level level, @NotNull BlockState aboveState, @NotNull Player player) {
        if (aboveState.m_60713_((Block)YTechBlocks.WELL_PULLEY.get())) {
            this.timer = 20;
            if (!((Boolean)aboveState.m_61143_((Property)WellPulleyBlock.ACTIVATED)).booleanValue()) {
                level.m_7731_(this.f_58858_.m_7494_(), (BlockState)aboveState.m_61124_((Property)WellPulleyBlock.ACTIVATED, (Comparable)Boolean.valueOf((Boolean)aboveState.m_61143_((Property)WellPulleyBlock.ACTIVATED) == false)), 3);
                YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
            }
            level.m_5594_(null, this.f_58858_, (SoundEvent)YTechSoundEvents.WELL_PULLEY_USE.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_151543_(this.f_58858_);
            player.m_36399_((float)YTechMod.CONFIGURATION.getFoodExhaustionOnUse());
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.timer = tag.m_128451_(TAG_TIMER);
    }

    public void tick(ServerLevel level) {
        if (this.timer > 0) {
            BlockState aboveState;
            --this.timer;
            level.m_151543_(this.f_58858_);
            if (this.timer == 0 && (aboveState = level.m_8055_(this.f_58858_.m_7494_())).m_60713_((Block)YTechBlocks.WELL_PULLEY.get())) {
                level.m_7731_(this.f_58858_.m_7494_(), (BlockState)aboveState.m_61124_((Property)WellPulleyBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)), 3);
                YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
            }
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_TIMER, this.timer);
    }

    public static double getWaterAbundance(BlockPos pos) {
        return WATER_SOURCE_NOISE.m_75449_((double)pos.m_123341_() * 0.01, (double)pos.m_123343_() * 0.01, false);
    }

    private int getNoiseFlow(@NotNull Level level) {
        Holder biome = level.m_204166_(this.f_58858_);
        if (!biome.m_203656_(YTechBiomeTags.WELL_DISABLED_BIOMES)) {
            double biomeModifier = 1.0;
            double waterAbundance = WellPulleyBlockEntity.getWaterAbundance(this.f_58858_);
            boolean dryBiome = biome.m_203656_(YTechBiomeTags.WELL_DRY_BIOMES);
            boolean wetBiome = biome.m_203656_(YTechBiomeTags.WELL_WET_BIOMES);
            if (dryBiome) {
                biomeModifier = YTechMod.CONFIGURATION.getWellPulleyDryBonus();
            } else if (wetBiome) {
                biomeModifier = YTechMod.CONFIGURATION.getWellPulleyWetBonus();
            }
            return (int)Math.max(Math.round(waterAbundance * (double)YTechMod.CONFIGURATION.getWellPulleyGeneration() * biomeModifier), 1L);
        }
        return 1;
    }
}

