/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.block.WoodenBoxBlock;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class WoodenBoxBlockEntity
extends BlockEntity {
    private static final String TAG_ITEMS = "Items";
    private final MyItemStackHandler itemHandler = new MyItemStackHandler(9);

    public WoodenBoxBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)YTechBlockEntityTypes.WOODEN_BOX.get(), pPos, pBlockState);
    }

    public NonNullList<ItemStack> getItems() {
        return this.itemHandler.getItems();
    }

    public ItemStack getItem(BlockPos pos, Direction direction, Vec3 hitVec) {
        int[] position = WoodenBoxBlock.getPosition(new BlockHitResult(hitVec, direction, pos, false));
        if (position != null) {
            return this.itemHandler.getStackInSlot(WoodenBoxBlock.getIndex(position));
        }
        return ItemStack.f_41583_;
    }

    public InteractionResult onUse(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        int[] hitPos = WoodenBoxBlock.getPosition(hitResult);
        ItemStack holdingItem = player.m_21120_(hand);
        if (hitPos != null) {
            int index = WoodenBoxBlock.getIndex(hitPos);
            ItemStack item = this.itemHandler.getStackInSlot(index);
            if (item.m_41619_()) {
                if (!holdingItem.m_41619_()) {
                    this.itemHandler.setStackInSlot(index, holdingItem.m_278832_());
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else {
                if (holdingItem.m_41619_()) {
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)this.itemHandler.extractItem(index, player.m_6047_() ? item.m_41741_() : 1, false));
                } else {
                    player.m_21008_(hand, this.itemHandler.insertItem(index, holdingItem, false));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_(TAG_ITEMS));
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(TAG_ITEMS, (Tag)this.itemHandler.serializeNBT());
    }

    private class MyItemStackHandler
    extends ItemStackHandler {
        public MyItemStackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            if (WoodenBoxBlockEntity.this.f_58857_ != null) {
                WoodenBoxBlockEntity.this.f_58857_.m_7260_(WoodenBoxBlockEntity.this.f_58858_, WoodenBoxBlockEntity.this.m_58900_(), WoodenBoxBlockEntity.this.m_58900_(), 3);
                WoodenBoxBlockEntity.this.f_58857_.m_151543_(WoodenBoxBlockEntity.this.f_58858_);
            }
        }

        public NonNullList<ItemStack> getItems() {
            return this.stacks;
        }
    }
}

