/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ArrowEntity
extends AbstractArrow {
    private static final int NO_EFFECT_COLOR = -1;
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(ArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final byte EVENT_POTION_PUFF = 0;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();
    private String arrowType;
    private Potion potion = Potions.f_43598_;
    private boolean fixedColor;

    public ArrowEntity(@NotNull Level level, @NotNull LivingEntity shooter, @NotNull Item arrowType) {
        super(EntityType.f_20548_, shooter, level);
        this.arrowType = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)arrowType)).toString();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        if (this.potion != Potions.f_43598_) {
            tag.m_128359_("Potion", Objects.requireNonNull(ForgeRegistries.POTIONS.getKey((Object)this.potion)).toString());
        }
        if (this.fixedColor) {
            tag.m_128405_("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListTag list = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                list.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("CustomPotionEffects", (Tag)list);
        }
        tag.m_128359_("Type", this.arrowType);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)tag);
        }
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)tag)) {
            this.addEffect(mobeffectinstance);
        }
        if (tag.m_128425_("Color", 99)) {
            this.setFixedColor(tag.m_128451_("Color"));
        } else {
            this.updateColor();
        }
        this.arrowType = tag.m_128461_("Type");
    }

    public void m_7822_(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_EFFECT_COLOR);
    }

    public void addEffect(@NotNull MobEffectInstance mobEffectInstance) {
        this.effects.add(mobEffectInstance);
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
    }

    protected void m_7761_(@NotNull LivingEntity living) {
        super.m_7761_(living);
        Entity entity = this.m_150173_();
        for (MobEffectInstance effect : this.potion.m_43488_()) {
            living.m_147207_(new MobEffectInstance(effect.m_19544_(), Math.max(effect.m_267696_(duration -> duration / 8), 1), effect.m_19564_(), effect.m_19571_(), effect.m_19572_()), entity);
        }
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance mobEffectInstance : this.effects) {
                living.m_147207_(mobEffectInstance, entity);
            }
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        Item arrow = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.arrowType));
        if (arrow != null) {
            return new ItemStack((ItemLike)arrow);
        }
        return ItemStack.f_41583_;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    private void makeParticle(int particleAmount) {
        int i = this.getColor();
        if (i != -1 && particleAmount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i & 0xFF) / 255.0;
            for (int j = 0; j < particleAmount; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    private void setFixedColor(int fixedColor) {
        this.fixedColor = true;
        this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)fixedColor);
    }
}

