/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.yanny.ytech.configuration.block_entity.MillstoneBlockEntity;
import com.yanny.ytech.configuration.goal.GoAround;
import com.yanny.ytech.registration.YTechEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoAroundEntity
extends Mob
implements IEntityAdditionalSpawnData {
    @NotNull
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private BlockPos position = null;
    @Nullable
    private MillstoneBlockEntity millstoneBlockEntity;

    public GoAroundEntity(EntityType<GoAroundEntity> entityType, Level pLevel) {
        super(entityType, pLevel);
    }

    public GoAroundEntity(@NotNull Mob mob, @NotNull BlockPos position, @NotNull Level level) {
        super((EntityType)YTechEntityTypes.GO_AROUND.get(), level);
        this.position = position;
        this.millstoneBlockEntity = (MillstoneBlockEntity)this.m_9236_().m_7702_(position);
        this.m_6034_(mob.m_20185_(), mob.m_20186_(), mob.m_20189_());
        this.m_146926_(mob.m_146909_());
        this.m_146922_(mob.m_146908_());
        this.m_5616_(mob.m_6080_());
        this.m_5618_(mob.m_213816_());
        this.m_20124_(mob.m_20089_());
        this.leashToMillstone();
        this.m_8099_();
    }

    protected void m_8099_() {
        if (!this.m_9236_().f_46443_ && this.position != null) {
            this.f_21345_.m_262460_(goal -> true);
            this.f_21345_.m_25352_(0, (Goal)new GoAround(this, this.position.m_252807_()));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 1.0);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.position != null) {
            pCompound.m_128405_("pX", this.position.m_123341_());
            pCompound.m_128405_("pY", this.position.m_123342_());
            pCompound.m_128405_("pZ", this.position.m_123343_());
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("pX") && pCompound.m_128441_("pY") && pCompound.m_128441_("pZ")) {
            this.position = new BlockPos(pCompound.m_128451_("pX"), pCompound.m_128451_("pY"), pCompound.m_128451_("pZ"));
            this.m_8099_();
        }
    }

    public boolean m_7998_(@NotNull Entity entity, boolean pForce) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.f_21344_ = new FixedGroundPathNavigation(mob, mob.m_9236_());
        } else {
            LOGGER.warn("Failed to start riding entity (not a Mob): {}", (Object)entity);
        }
        return super.m_7998_(entity, pForce);
    }

    public void m_8127_() {
        super.m_8127_();
        if (!this.m_9236_().f_46443_ && this.m_146911_() == null) {
            if (this.millstoneBlockEntity != null) {
                this.millstoneBlockEntity.removeLeash();
            } else {
                LOGGER.warn("Failed to remove BE because is NULL");
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.m_19998_((ItemLike)Items.f_42655_);
        }
    }

    public void m_8119_() {
        if (this.millstoneBlockEntity == null) {
            this.leashToMillstone();
        }
        super.m_8119_();
    }

    public void m_6083_() {
        Entity vehicle = this.m_20202_();
        super.m_6083_();
        if (vehicle != null) {
            this.f_20883_ = vehicle.m_213816_();
        }
    }

    @Nullable
    public MillstoneBlockEntity getDevice() {
        return this.millstoneBlockEntity;
    }

    public void writeSpawnData(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeBoolean(this.position != null);
        if (this.position != null) {
            friendlyByteBuf.writeInt(this.position.m_123341_());
            friendlyByteBuf.writeInt(this.position.m_123342_());
            friendlyByteBuf.writeInt(this.position.m_123343_());
        } else {
            LOGGER.warn("Sending spawn packet without position!");
        }
    }

    public void readSpawnData(FriendlyByteBuf friendlyByteBuf) {
        if (friendlyByteBuf.readBoolean()) {
            this.position = new BlockPos(friendlyByteBuf.readInt(), friendlyByteBuf.readInt(), friendlyByteBuf.readInt());
        } else {
            LOGGER.warn("Received spawn packet without position!");
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void leashToMillstone() {
        if (this.position != null) {
            this.millstoneBlockEntity = (MillstoneBlockEntity)this.m_9236_().m_7702_(this.position);
            if (this.millstoneBlockEntity != null) {
                this.millstoneBlockEntity.setLeashed(this);
            } else {
                LOGGER.warn("Failed to load BE at {}", (Object)this.position);
            }
        } else {
            LOGGER.warn("NULL position!");
        }
    }

    static class FixedGroundPathNavigation
    extends GroundPathNavigation {
        public FixedGroundPathNavigation(Mob pMob, Level pLevel) {
            super(pMob, pLevel);
        }

        protected void m_6481_(@NotNull Vec3 pPositionVec3) {
            if (this.f_26498_ - this.f_26499_ > 100) {
                float f = this.f_26494_.m_6113_() >= 1.0f ? this.f_26494_.m_6113_() : this.f_26494_.m_6113_() * this.f_26494_.m_6113_();
                float f1 = f * 100.0f * 0.25f;
                if (pPositionVec3.m_82557_(this.f_26500_) < (double)(f1 * f1)) {
                    this.f_26513_ = true;
                    this.m_26573_();
                } else {
                    this.f_26513_ = false;
                }
                this.f_26499_ = this.f_26498_;
                this.f_26500_ = pPositionVec3;
            }
            if (this.f_26496_ != null && !this.f_26496_.m_77392_()) {
                BlockPos vec3i = this.f_26496_.m_77400_();
                long i = this.f_26495_.m_46467_();
                if (vec3i.equals((Object)this.f_26501_)) {
                    this.f_26502_ += i - this.f_26503_;
                } else {
                    this.f_26501_ = vec3i;
                    double d0 = pPositionVec3.m_82554_(Vec3.m_82539_((Vec3i)this.f_26501_));
                    this.f_26504_ = this.f_26494_.m_6113_() > 0.0f ? d0 / (double)this.f_26494_.m_6113_() * 20.0 : 0.0;
                    this.f_26502_ = 0L;
                }
                if (this.f_26504_ > 0.0 && (double)this.f_26502_ > this.f_26504_ * 3.0) {
                    this.m_26564_();
                }
                this.f_26503_ = i;
            }
        }
    }
}

