/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.goal;

import com.yanny.ytech.configuration.block_entity.MillstoneBlockEntity;
import com.yanny.ytech.configuration.entity.GoAroundEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoAround
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double STEP = 0.19634954084936207;
    private static final int RADIUS = 3;
    @NotNull
    GoAroundEntity mob;
    Vec3 pos;

    public GoAround(@NotNull GoAroundEntity mob, Vec3 pos) {
        this.pos = pos;
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        MillstoneBlockEntity blockEntity = this.mob.getDevice();
        if (blockEntity != null) {
            return blockEntity.isMilling();
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_() && this.mob.m_6084_() && this.mob.getDevice() != null && this.mob.getDevice().isMilling();
    }

    public void m_8056_() {
        Path path = this.mob.m_21573_().m_26570_();
        if ((path == null || path.m_77392_()) && !this.mob.m_21573_().m_26536_(this.createPath(), 1.0)) {
            LOGGER.warn("Failed to create path!");
        }
    }

    public void m_8041_() {
        MillstoneBlockEntity millstoneBlockEntity;
        super.m_8041_();
        Entity entity = this.mob.m_20202_();
        if (entity instanceof Mob) {
            Mob mobVehicle = (Mob)entity;
            mobVehicle.f_21344_.m_26573_();
        }
        if ((millstoneBlockEntity = this.mob.getDevice()) != null) {
            this.mob.getDevice().onFinished();
        }
    }

    private Path createPath() {
        BlockPos startingPos = null;
        Vec3 mobPos = this.mob.m_20097_().m_252807_();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(17);
        for (double angle = 0.0; angle < 6.4795348480289485; angle += 0.19634954084936207) {
            double x = this.pos.f_82479_ + 3.0 * Math.cos(angle);
            double y = this.pos.f_82480_;
            double z = this.pos.f_82481_ + 3.0 * Math.sin(angle);
            BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            if (startingPos == null || startingPos.m_203193_((Position)mobPos) > blockPos.m_203193_((Position)mobPos)) {
                startingPos = blockPos;
            }
            if (posList.contains(blockPos)) continue;
            posList.add(blockPos);
        }
        int index = posList.indexOf(startingPos);
        Stream ordered = Stream.concat(posList.subList(index, posList.size()).stream(), posList.subList(0, index).stream());
        return new SamePathIsFine(ordered.map(n -> new Node(n.m_123341_(), n.m_123342_(), n.m_123343_())).toList(), startingPos, true);
    }

    static class SamePathIsFine
    extends Path {
        public SamePathIsFine(List<Node> pNodes, BlockPos pTarget, boolean pReached) {
            super(pNodes, pTarget, pReached);
        }

        public boolean m_77385_(@Nullable Path path) {
            return false;
        }
    }
}

