/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.goal;

import com.yanny.ytech.configuration.goal.IRaidGarden;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class RaidGardenGoal<T extends PathfinderMob>
extends MoveToBlockGoal {
    @NotNull
    private final T animal;
    private final TagKey<Block> raidBlocks;
    private boolean wantsToRaid;
    private boolean canRaid;

    public RaidGardenGoal(@NotNull T animal, TagKey<Block> raidBlocks) {
        super(animal, (double)0.7f, 16);
        this.animal = animal;
        this.raidBlocks = raidBlocks;
    }

    public boolean m_8036_() {
        if (this.f_25600_ <= 0) {
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.animal.m_9236_(), this.animal)) {
                return false;
            }
            this.canRaid = false;
            this.wantsToRaid = ((IRaidGarden)this.animal).wantsMoreFood();
        }
        return super.m_8036_();
    }

    public boolean m_8045_() {
        return this.canRaid && super.m_8045_();
    }

    public void m_8037_() {
        super.m_8037_();
        this.animal.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.animal.m_8132_());
        if (this.m_25625_()) {
            Level level = this.animal.m_9236_();
            BlockPos pos = this.f_25602_.m_7494_();
            BlockState blockState = level.m_8055_(pos);
            if (this.canRaid && blockState.m_204336_(this.raidBlocks)) {
                blockState.m_61145_((Property)CropBlock.f_52244_).ifPresentOrElse(age -> {
                    if (age == 0) {
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                        level.m_46953_(pos, true, this.animal);
                    } else {
                        level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)CarrotBlock.f_52244_, (Comparable)Integer.valueOf(age - 1)), 2);
                        level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockState));
                    }
                }, () -> {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                    level.m_46953_(pos, true, this.animal);
                });
                ((IRaidGarden)this.animal).setWantsMoreFoodTicks();
            }
            this.canRaid = false;
            this.f_25600_ = 10;
        }
    }

    protected boolean m_6465_(@NotNull LevelReader level, @NotNull BlockPos pos) {
        BlockState state;
        if (this.wantsToRaid && !this.canRaid && (state = level.m_8055_(pos.m_7494_())).m_204336_(this.raidBlocks)) {
            this.canRaid = true;
            return true;
        }
        return false;
    }
}

