/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.item;

import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class ClayBucketItem
extends BucketItem {
    public ClayBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        BlockHitResult blockHitResult;
        ItemStack itemInHand = player.m_21120_(hand);
        InteractionResultHolder interactionResult = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)itemInHand, (HitResult)(blockHitResult = ClayBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))));
        if (interactionResult != null) {
            return interactionResult;
        }
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemInHand);
        }
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemInHand);
        }
        BlockPos blockPos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        BlockPos relativePos = blockPos.m_121945_(direction);
        if (level.m_7966_(player, blockPos) && player.m_36204_(relativePos, direction, itemInHand)) {
            BlockPos placePos;
            if (this.getFluid() == Fluids.f_76191_) {
                BucketPickup bucketPickup;
                ItemStack pickedItemStack;
                LiquidBlock liquidBlock;
                Block block;
                BlockState blockState = level.m_8055_(blockPos);
                if (!blockState.m_61138_((Property)BlockStateProperties.f_61362_) && (block = blockState.m_60734_()) instanceof LiquidBlock && !(liquidBlock = (LiquidBlock)block).getFluid().m_6212_((Fluid)Fluids.f_76193_) && !liquidBlock.getFluid().m_6212_((Fluid)Fluids.f_76195_)) {
                    return InteractionResultHolder.m_19100_((Object)itemInHand);
                }
                block = blockState.m_60734_();
                if (block instanceof BucketPickup && !(pickedItemStack = (bucketPickup = (BucketPickup)block).m_142598_((LevelAccessor)level, blockPos, blockState)).m_41619_()) {
                    if (pickedItemStack.m_150930_(Items.f_42447_)) {
                        pickedItemStack = new ItemStack((ItemLike)YTechItems.WATER_CLAY_BUCKET.get());
                    } else if (pickedItemStack.m_150930_(Items.f_42448_)) {
                        pickedItemStack = new ItemStack((ItemLike)YTechItems.LAVA_CLAY_BUCKET.get());
                    } else {
                        return InteractionResultHolder.m_19100_((Object)itemInHand);
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    bucketPickup.getPickupSound(blockState).ifPresent(soundEvent -> player.m_5496_(soundEvent, 1.0f, 1.0f));
                    level.m_142346_((Entity)player, GameEvent.f_157816_, blockPos);
                    ItemStack filledResult = ItemUtils.m_41813_((ItemStack)itemInHand, (Player)player, (ItemStack)pickedItemStack);
                    if (!level.f_46443_) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, pickedItemStack);
                    }
                    return InteractionResultHolder.m_19092_((Object)filledResult, (boolean)level.m_5776_());
                }
                return InteractionResultHolder.m_19100_((Object)itemInHand);
            }
            BlockState blockState = level.m_8055_(blockPos);
            BlockPos blockPos2 = placePos = this.canBlockContainFluid(level, blockPos, blockState) ? blockPos : relativePos;
            if (this.emptyContents(player, level, placePos, blockHitResult, itemInHand)) {
                this.m_142131_(player, level, itemInHand, placePos);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, placePos, itemInHand);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)ClayBucketItem.m_40699_(itemInHand, player), (boolean)level.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)itemInHand);
        }
        return InteractionResultHolder.m_19100_((Object)itemInHand);
    }

    @NotNull
    public static ItemStack m_40699_(@NotNull ItemStack bucketItemStack, Player player) {
        if (bucketItemStack.m_204117_(YTechItemTags.LAVA_BUCKETS) && !player.m_150110_().f_35937_) {
            return ItemStack.f_41583_;
        }
        return !player.m_150110_().f_35937_ ? new ItemStack((ItemLike)YTechItems.CLAY_BUCKET.get()) : bucketItemStack;
    }
}

