/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.entity.TerrorBirdEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TerrorBirdModel
extends EntityModel<TerrorBirdEntity> {
    @NotNull
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Utils.modLoc("terror_bird"), "main");
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart l_foot;
    @NotNull
    private final ModelPart r_foot;

    public TerrorBirdModel(@NotNull ModelPart root) {
        super(RenderType::m_110458_);
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.l_foot = root.m_171324_("l_foot");
        this.r_foot = root.m_171324_("r_foot");
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packetLight, int packetOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.parts().forEach(modelPart -> modelPart.m_104306_(poseStack, vertexConsumer, packetLight, packetOverlay, pRed, pGreen, pBlue, pAlpha));
    }

    public void setupAnim(@NotNull TerrorBirdEntity entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.r_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.l_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
    }

    @NotNull
    private Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.l_foot, (Object)this.r_foot);
    }

    @NotNull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -19.0f, -6.0f, 10.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_("l_foot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.5f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(1.0f, 9.0f, -3.0f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        partdefinition.m_171599_("r_foot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, 9.0f, -3.0f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)-4.0f));
        head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-3.0f, -4.0f, -8.0f, 6.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)-4.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)-2.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

