/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.google.common.collect.ImmutableList;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.entity.WildBoarEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WildBoarModel
extends AgeableListModel<WildBoarEntity> {
    @NotNull
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Utils.modLoc("wild_boar"), "main");
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart fl_foot;
    @NotNull
    private final ModelPart bl_foot;
    @NotNull
    private final ModelPart fr_foot;
    @NotNull
    private final ModelPart br_foot;

    public WildBoarModel(@NotNull ModelPart root) {
        super(false, 4.0f, 5.0f);
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.fl_foot = root.m_171324_("fl_foot");
        this.bl_foot = root.m_171324_("bl_foot");
        this.fr_foot = root.m_171324_("fr_foot");
        this.br_foot = root.m_171324_("br_foot");
    }

    @NotNull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.fl_foot, (Object)this.bl_foot, (Object)this.fr_foot, (Object)this.br_foot);
    }

    public void setupAnim(@NotNull WildBoarEntity entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.fl_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.bl_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.fr_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.br_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.head.m_171324_((String)"tusks").f_104207_ = !entity.m_6162_();
    }

    @NotNull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -14.0f, -9.0f, 10.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_("fl_foot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)18.0f, (float)-6.0f));
        partdefinition.m_171599_("fr_foot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)-6.0f));
        partdefinition.m_171599_("bl_foot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)18.0f, (float)6.0f));
        partdefinition.m_171599_("br_foot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)6.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-4.0f, -3.0f, -6.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(-2.0f, 0.0f, -8.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)-9.0f));
        head.m_171599_("tusks", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(2.0f, -11.0f, -17.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -11.0f, -17.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)9.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }
}

