/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.entity.WoollyMammothEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WoollyMammothModel
extends EntityModel<WoollyMammothEntity> {
    @NotNull
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Utils.modLoc("woolly_mammoth"), "main");
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart fl_foot;
    @NotNull
    private final ModelPart bl_foot;
    @NotNull
    private final ModelPart fr_foot;
    @NotNull
    private final ModelPart br_foot;

    public WoollyMammothModel(@NotNull ModelPart root) {
        super(RenderType::m_110458_);
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.fl_foot = root.m_171324_("fl_foot");
        this.bl_foot = root.m_171324_("bl_foot");
        this.fr_foot = root.m_171324_("fr_foot");
        this.br_foot = root.m_171324_("br_foot");
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packetLight, int packetOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.parts().forEach(modelPart -> modelPart.m_104306_(poseStack, vertexConsumer, packetLight, packetOverlay, pRed, pGreen, pBlue, pAlpha));
    }

    public void setupAnim(@NotNull WoollyMammothEntity entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.fl_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.bl_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.fr_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.br_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
    }

    @NotNull
    private Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.fl_foot, (Object)this.bl_foot, (Object)this.fr_foot, (Object)this.br_foot);
    }

    @NotNull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171488_(-8.0f, -30.0f, 7.0f, 16.0f, 18.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -32.0f, -10.0f, 16.0f, 20.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_("fl_foot", CubeListBuilder.m_171558_().m_171514_(61, 32).m_171488_(-3.0f, 0.0f, -2.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)12.0f, (float)-6.0f));
        partdefinition.m_171599_("fr_foot", CubeListBuilder.m_171558_().m_171514_(61, 32).m_171488_(-3.0f, 0.0f, -2.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)12.0f, (float)-6.0f));
        partdefinition.m_171599_("bl_foot", CubeListBuilder.m_171558_().m_171514_(61, 32).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)12.0f, (float)17.0f));
        partdefinition.m_171599_("br_foot", CubeListBuilder.m_171558_().m_171514_(61, 32).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)12.0f, (float)17.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(86, 31).m_171488_(-5.0f, -5.0f, -9.0f, 10.0f, 14.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-10.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -18.0f, -22.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)28.0f, (float)10.0f));
        nose.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(14, 38).m_171488_(-3.0f, -6.0f, -2.5f, 6.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-21.0f, (float)-18.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        nose.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-1.5f, -4.0f, 0.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.5f, (float)-20.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition tusks = head.m_171599_("tusks", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)28.0f, (float)10.0f));
        tusks.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)-24.0f, (float)-17.5f, (float)-0.3491f, (float)0.0f, (float)0.3491f));
        tusks.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(63, 2).m_171488_(-1.0f, 1.5f, 7.25f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5f, (float)-17.5f, (float)-20.0f, (float)-2.618f, (float)0.0f, (float)0.3491f));
        tusks.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(68, 2).m_171488_(-1.5f, 2.5f, 2.25f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5f, (float)-17.5f, (float)-20.0f, (float)-1.7017f, (float)0.0f, (float)0.3491f));
        tusks.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(68, 2).m_171488_(-1.5f, -1.25f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5f, (float)-17.5f, (float)-20.0f, (float)-0.8727f, (float)0.0f, (float)0.3491f));
        tusks.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(63, 2).m_171488_(0.0f, 1.5f, 7.25f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)-17.5f, (float)-20.0f, (float)-2.618f, (float)0.0f, (float)-0.3491f));
        tusks.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(68, 2).m_171488_(-0.5f, 2.5f, 2.25f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)-17.5f, (float)-20.0f, (float)-1.7017f, (float)0.0f, (float)-0.3491f));
        tusks.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(68, 2).m_171488_(-0.5f, -1.25f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)-17.5f, (float)-20.0f, (float)-0.8727f, (float)0.0f, (float)-0.3491f));
        tusks.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)-24.0f, (float)-17.5f, (float)-0.3491f, (float)0.0f, (float)-0.3491f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }
}

