/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AlloyingRecipe(ResourceLocation id, Ingredient ingredient1, int count1, Ingredient ingredient2, int count2, int minTemperature, int smeltingTime, ItemStack result) implements Recipe<Container>
{
    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        return this.matchesFully(container.m_8020_(0), container.m_8020_(1), false);
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)YTechRecipeSerializers.ALLOYING.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)YTechRecipeTypes.ALLOYING.get();
    }

    public int getInput1Count() {
        return this.count1;
    }

    public int getInput2Count() {
        return this.count2;
    }

    public boolean matchesPartially(@NotNull ItemStack itemStack1, @NotNull ItemStack itemStack2, boolean ignoreCount) {
        return this.ingredient1.test(itemStack1) && (ignoreCount || itemStack1.m_41613_() >= this.count1) || this.ingredient1.test(itemStack2) && (ignoreCount || itemStack2.m_41613_() >= this.count1) || this.ingredient2.test(itemStack1) && (ignoreCount || itemStack1.m_41613_() >= this.count2) || this.ingredient2.test(itemStack2) && (ignoreCount || itemStack2.m_41613_() >= this.count2);
    }

    public boolean matchesFully(@NotNull ItemStack itemStack1, @NotNull ItemStack itemStack2, boolean ignoreCount) {
        return !((!this.ingredient1.test(itemStack1) || !ignoreCount && itemStack1.m_41613_() < this.count1 || !this.ingredient2.test(itemStack2) || !ignoreCount && itemStack2.m_41613_() < this.count2) && (!this.ingredient1.test(itemStack2) || !ignoreCount && itemStack2.m_41613_() < this.count1 || !this.ingredient2.test(itemStack1) || !ignoreCount && itemStack1.m_41613_() < this.count2));
    }

    public boolean matchesIngredient1(@NotNull ItemStack itemStack, boolean ignoreCount) {
        return this.ingredient1.test(itemStack) && (ignoreCount || itemStack.m_41613_() >= this.count1);
    }

    public boolean matchesIngredient2(@NotNull ItemStack itemStack, boolean ignoreCount) {
        return this.ingredient2.test(itemStack) && (ignoreCount || itemStack.m_41613_() >= this.count2);
    }

    public static class Builder
    implements RecipeBuilder {
        private final Ingredient ingredient1;
        private final int count1;
        private final Ingredient ingredient2;
        private final int count2;
        private final int minTemperature;
        private final int smeltingTime;
        private final Item result;
        private final int count;
        private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

        Builder(@NotNull Ingredient ingredient1, int count1, @NotNull Ingredient ingredient2, int count2, int minTemperature, int smeltingTime, @NotNull Item result, int count) {
            this.ingredient1 = ingredient1;
            this.count1 = count1;
            this.ingredient2 = ingredient2;
            this.count2 = count2;
            this.minTemperature = minTemperature;
            this.smeltingTime = smeltingTime;
            this.result = result;
            this.count = count;
        }

        public static Builder alloying(@NotNull TagKey<Item> input1, int count1, @NotNull TagKey<Item> input2, int count2, int minTemperature, int smeltingTime, @NotNull Item result, int count) {
            return new Builder(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(input1))), count1, Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(input2))), count2, minTemperature, smeltingTime, result, count);
        }

        public static Builder alloying(@NotNull TagKey<Item> input1, int count1, @NotNull ItemLike input2, int count2, int minTemperature, int smeltingTime, @NotNull Item result, int count) {
            return new Builder(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(input1))), count1, Ingredient.m_43938_(Stream.of(new Ingredient.ItemValue(new ItemStack(input2)))), count2, minTemperature, smeltingTime, result, count);
        }

        @NotNull
        public RecipeBuilder m_126132_(@NotNull String criterionName, @NotNull CriterionTriggerInstance criterionTrigger) {
            this.advancement.m_138386_(criterionName, criterionTrigger);
            return this;
        }

        @NotNull
        public RecipeBuilder m_126145_(@Nullable String groupName) {
            return this;
        }

        @NotNull
        public Item m_142372_() {
            return this.result;
        }

        public void m_126140_(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer, @NotNull ResourceLocation recipeId) {
            this.ensureValid(recipeId);
            this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
            finishedRecipeConsumer.accept(new Result(recipeId, this.ingredient1, this.count1, this.ingredient2, this.count2, this.minTemperature, this.smeltingTime, this.result, this.count, this.advancement, recipeId.m_246208_("recipes/alloying/")));
        }

        private void ensureValid(@NotNull ResourceLocation id) {
            if (this.advancement.m_138405_().isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public record Result(@NotNull ResourceLocation id, @NotNull Ingredient ingredient1, int count1, Ingredient ingredient2, int count2, int minTemperature, int smeltingTime, @NotNull Item result, int count, @NotNull Advancement.Builder advancement, @NotNull ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(@NotNull JsonObject json) {
            JsonObject item1 = new JsonObject();
            JsonObject item2 = new JsonObject();
            item1.add("ingredient", this.ingredient1.m_43942_());
            item1.addProperty("count", (Number)this.count1);
            item2.add("ingredient", this.ingredient2.m_43942_());
            item2.addProperty("count", (Number)this.count2);
            json.add("ingredient1", (JsonElement)item1);
            json.add("ingredient2", (JsonElement)item2);
            JsonObject resultItemStack = new JsonObject();
            resultItemStack.addProperty("item", Utils.loc(this.result).toString());
            if (this.count > 1) {
                resultItemStack.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)resultItemStack);
            json.addProperty("minTemp", (Number)this.minTemperature);
            json.addProperty("smeltingTime", (Number)this.smeltingTime);
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)YTechRecipeSerializers.ALLOYING.get();
        }

        @NotNull
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @NotNull
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }

    public static class Serializer
    implements RecipeSerializer<AlloyingRecipe> {
        @NotNull
        public AlloyingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject serializedRecipe) {
            JsonObject item1 = serializedRecipe.getAsJsonObject("ingredient1");
            JsonObject item2 = serializedRecipe.getAsJsonObject("ingredient2");
            Ingredient ingredient1 = Ingredient.m_288218_((JsonElement)item1.get("ingredient"), (boolean)false);
            Ingredient ingredient2 = Ingredient.m_288218_((JsonElement)item2.get("ingredient"), (boolean)false);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"result"));
            int minTemperature = GsonHelper.m_13927_((JsonObject)serializedRecipe, (String)"minTemp");
            int smeltingTime = GsonHelper.m_13927_((JsonObject)serializedRecipe, (String)"smeltingTime");
            int count1 = GsonHelper.m_13927_((JsonObject)item1, (String)"count");
            int count2 = GsonHelper.m_13927_((JsonObject)item2, (String)"count");
            return new AlloyingRecipe(recipeId, ingredient1, count1, ingredient2, count2, minTemperature, smeltingTime, result);
        }

        @Nullable
        public AlloyingRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            int minTemperature = buffer.readInt();
            int smeltingTime = buffer.readInt();
            int count1 = buffer.readInt();
            int count2 = buffer.readInt();
            return new AlloyingRecipe(recipeId, ingredient1, count1, ingredient2, count2, minTemperature, smeltingTime, result);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull AlloyingRecipe recipe) {
            recipe.ingredient1.m_43923_(buffer);
            recipe.ingredient2.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.writeInt(recipe.minTemperature);
            buffer.writeInt(recipe.smeltingTime);
            buffer.writeInt(recipe.count1);
            buffer.writeInt(recipe.count2);
        }
    }
}

