/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MillingRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, float bonusChance) implements Recipe<Container>
{
    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        return this.ingredient.test(container.m_8020_(0));
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)YTechRecipeSerializers.MILLING.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)YTechRecipeTypes.MILLING.get();
    }

    public static class Builder
    implements RecipeBuilder {
        private final Ingredient ingredient;
        private final Item result;
        private final int count;
        private float bonusChance = 0.0f;
        private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

        Builder(@NotNull Ingredient ingredient, @NotNull Item result, int count) {
            this.ingredient = ingredient;
            this.result = result;
            this.count = count;
        }

        public static Builder milling(@NotNull TagKey<Item> input, @NotNull Item result, int count) {
            return new Builder(Ingredient.m_204132_(input), result, count);
        }

        public static Builder milling(@NotNull ItemLike input, @NotNull Item result, int count) {
            return new Builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), result, count);
        }

        public RecipeBuilder bonusChance(float bonusChance) {
            this.bonusChance = bonusChance;
            return this;
        }

        @NotNull
        public RecipeBuilder m_126132_(@NotNull String criterionName, @NotNull CriterionTriggerInstance criterionTrigger) {
            this.advancement.m_138386_(criterionName, criterionTrigger);
            return this;
        }

        @NotNull
        public RecipeBuilder m_126145_(@Nullable String groupName) {
            return this;
        }

        @NotNull
        public Item m_142372_() {
            return this.result;
        }

        public void m_126140_(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer, @NotNull ResourceLocation recipeId) {
            this.ensureValid(recipeId);
            this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
            finishedRecipeConsumer.accept(new Result(recipeId, this.ingredient, this.result, this.count, this.bonusChance, this.advancement, recipeId.m_246208_("recipes/milling/")));
        }

        private void ensureValid(@NotNull ResourceLocation id) {
            if (this.advancement.m_138405_().isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public record Result(@NotNull ResourceLocation id, @NotNull Ingredient ingredient, @NotNull Item result, int count, float bonusChance, @NotNull Advancement.Builder advancement, @NotNull ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(@NotNull JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            JsonObject resultItemStack = new JsonObject();
            resultItemStack.addProperty("item", Utils.loc(this.result).toString());
            resultItemStack.addProperty("count", (Number)this.count);
            json.add("result", (JsonElement)resultItemStack);
            json.addProperty("bonusChance", (Number)Float.valueOf(this.bonusChance));
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)YTechRecipeSerializers.MILLING.get();
        }

        @NotNull
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @NotNull
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }

    public static class Serializer
    implements RecipeSerializer<MillingRecipe> {
        @NotNull
        public MillingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject serializedRecipe) {
            Ingredient ingredient = Ingredient.m_288218_((JsonElement)serializedRecipe.get("ingredient"), (boolean)false);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"result"));
            float bonusChance = serializedRecipe.getAsJsonPrimitive("bonusChance").getAsFloat();
            return new MillingRecipe(recipeId, ingredient, result, bonusChance);
        }

        @Nullable
        public MillingRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            float bonusChance = buffer.readFloat();
            return new MillingRecipe(recipeId, ingredient, result, bonusChance);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull MillingRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.writeFloat(recipe.bonusChance);
        }
    }
}

