/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PotteryRecipe(ResourceLocation id, int count, ItemStack result) implements Recipe<Container>
{
    private static final Ingredient clay = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42461_});

    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        ItemStack item = container.m_8020_(0);
        return clay.test(item) && item.m_41613_() == this.count;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)YTechRecipeSerializers.POTTERY.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)YTechRecipeTypes.POTTERY.get();
    }

    public static class Builder
    implements RecipeBuilder {
        private final int count;
        private final Item result;
        private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

        Builder(int count, @NotNull Item result) {
            this.count = count;
            this.result = result;
        }

        public static Builder pottery(int count, @NotNull Item result) {
            return new Builder(count, result);
        }

        @NotNull
        public RecipeBuilder m_126132_(@NotNull String criterionName, @NotNull CriterionTriggerInstance criterionTrigger) {
            this.advancement.m_138386_(criterionName, criterionTrigger);
            return this;
        }

        @NotNull
        public RecipeBuilder m_126145_(@Nullable String groupName) {
            return this;
        }

        @NotNull
        public Item m_142372_() {
            return this.result;
        }

        public void m_126140_(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer, @NotNull ResourceLocation recipeId) {
            this.ensureValid(recipeId);
            this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
            finishedRecipeConsumer.accept(new Result(recipeId, this.count, this.result, this.advancement, recipeId.m_246208_("recipes/pottery/")));
        }

        private void ensureValid(@NotNull ResourceLocation id) {
            if (this.advancement.m_138405_().isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public record Result(@NotNull ResourceLocation id, int count, @NotNull Item result, @NotNull Advancement.Builder advancement, @NotNull ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(@NotNull JsonObject json) {
            JsonObject resultItemStack = new JsonObject();
            resultItemStack.addProperty("item", Utils.loc(this.result).toString());
            json.add("result", (JsonElement)resultItemStack);
            json.addProperty("count", (Number)this.count);
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)YTechRecipeSerializers.POTTERY.get();
        }

        @NotNull
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @NotNull
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }

    public static class Serializer
    implements RecipeSerializer<PotteryRecipe> {
        @NotNull
        public PotteryRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject serializedRecipe) {
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"result"));
            int count = GsonHelper.m_13927_((JsonObject)serializedRecipe, (String)"count");
            return new PotteryRecipe(recipeId, count, result);
        }

        @Nullable
        public PotteryRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            ItemStack result = buffer.m_130267_();
            int count = buffer.readInt();
            return new PotteryRecipe(recipeId, count, result);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull PotteryRecipe recipe) {
            buffer.m_130055_(recipe.result);
            buffer.writeInt(recipe.count);
        }
    }
}

