/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.google.gson.JsonObject;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RemainingShapedRecipe
extends ShapedRecipe {
    private static final RandomSource RANDOM = RandomSource.m_216327_();

    public RemainingShapedRecipe(ShapedRecipe recipe) {
        super(recipe.m_6423_(), recipe.m_6076_(), recipe.m_245232_(), recipe.m_44220_(), recipe.m_44221_(), recipe.m_7527_(), recipe.m_8043_(null), recipe.m_271738_());
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList list = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (item.hasCraftingRemainingItem()) {
                list.set(i, (Object)item.getCraftingRemainingItem());
                continue;
            }
            if (!item.m_41763_()) continue;
            ItemStack result = item.m_41777_();
            list.set(i, (Object)result);
            if (!result.m_220157_(1, RANDOM, null)) continue;
            result.m_41774_(1);
            result.m_41721_(0);
        }
        return list;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)YTechRecipeSerializers.REMAINING_SHAPED.get();
    }

    public static class Builder
    extends ShapedRecipeBuilder {
        public Builder(RecipeCategory pCategory, ItemLike pResult, int pCount) {
            super(pCategory, pResult, pCount);
        }

        public static Builder shaped(@NotNull RecipeCategory pCategory, ItemLike pResult) {
            return Builder.shaped(pCategory, pResult, 1);
        }

        public static Builder shaped(@NotNull RecipeCategory pCategory, ItemLike pResult, int pCount) {
            return new Builder(pCategory, pResult, pCount);
        }

        public void m_126140_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
            super.m_126140_(t -> {
                ShapedRecipeBuilder.Result r = (ShapedRecipeBuilder.Result)t;
                consumer.accept((FinishedRecipe)new Result(id, r.f_126149_, r.f_126150_, r.f_126151_, Builder.m_245179_((RecipeCategory)this.f_243672_), r.f_126152_, r.f_126153_, r.f_126154_, r.f_126155_, r.f_271297_));
            }, id);
        }
    }

    private static class Result
    extends ShapedRecipeBuilder.Result {
        public Result(ResourceLocation pId, Item pResult, int pCount, String pGroup, CraftingBookCategory pCategory, List<String> pPattern, Map<Character, Ingredient> pKey, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId, boolean pShowNotification) {
            super(pId, pResult, pCount, pGroup, pCategory, pPattern, pKey, pAdvancement, pAdvancementId, pShowNotification);
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)YTechRecipeSerializers.REMAINING_SHAPED.get();
        }
    }

    public static class Serializer
    implements RecipeSerializer<RemainingShapedRecipe> {
        private static final ShapedRecipe.Serializer serializer = new ShapedRecipe.Serializer();

        @NotNull
        public RemainingShapedRecipe fromJson(@NotNull ResourceLocation resourceLocation, @NotNull JsonObject jsonObject) {
            return new RemainingShapedRecipe(serializer.m_6729_(resourceLocation, jsonObject));
        }

        @NotNull
        public RemainingShapedRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
            return new RemainingShapedRecipe(serializer.m_8005_(id, buffer));
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull RemainingShapedRecipe recipe) {
            serializer.m_6178_(buf, (ShapedRecipe)recipe);
        }
    }
}

