/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record WorkspaceCraftingRecipe(ResourceLocation id, NonNullList<Ingredient> recipeItems, Ingredient tool, ItemStack result) implements Recipe<Container>
{
    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        int z;
        int x;
        int y;
        int i;
        boolean matches = true;
        for (i = 0; i < 27; ++i) {
            if (((Ingredient)this.recipeItems.get(i)).test(container.m_8020_(i))) continue;
            matches = false;
        }
        if (!matches) {
            i = 0;
            matches = true;
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    for (z = 0; z < 3; ++z) {
                        if (!((Ingredient)this.recipeItems.get(i)).test(container.m_8020_(x + z * 3 + y * 9))) {
                            matches = false;
                        }
                        ++i;
                    }
                }
            }
        }
        if (!matches) {
            i = 0;
            matches = true;
            for (y = 0; y < 3; ++y) {
                for (int z2 = 2; z2 >= 0; --z2) {
                    for (int x2 = 2; x2 >= 0; --x2) {
                        if (!((Ingredient)this.recipeItems.get(i)).test(container.m_8020_(x2 + z2 * 3 + y * 9))) {
                            matches = false;
                        }
                        ++i;
                    }
                }
            }
        }
        if (!matches) {
            i = 0;
            matches = true;
            for (y = 0; y < 3; ++y) {
                for (x = 2; x >= 0; --x) {
                    for (z = 2; z >= 0; --z) {
                        if (!((Ingredient)this.recipeItems.get(i)).test(container.m_8020_(x + z * 3 + y * 9))) {
                            matches = false;
                        }
                        ++i;
                    }
                }
            }
        }
        return matches;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)YTechRecipeSerializers.WORKSPACE_CRAFTING.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)YTechRecipeTypes.WORKSPACE_CRAFTING.get();
    }

    private static String[][] patternFromJson(JsonObject pJson) {
        return new String[][]{WorkspaceCraftingRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"bottom")), WorkspaceCraftingRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"middle")), WorkspaceCraftingRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"top"))};
    }

    private static Map<String, Ingredient> keyFromJson(JsonObject pKeyEntry) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : pKeyEntry.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_288218_((JsonElement)((JsonElement)entry.getValue()), (boolean)false));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    private static String[] patternFromJson(JsonArray pPatternArray) {
        String[] strings = new String[pPatternArray.size()];
        if (strings.length != 3) {
            throw new JsonSyntaxException("Invalid pattern: expected 3 rows");
        }
        for (int i = 0; i < strings.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)pPatternArray.get(i), (String)("pattern[" + i + "]"));
            if (s.length() != 3) {
                throw new JsonSyntaxException("Invalid pattern: expected 3 columns");
            }
            if (i > 0 && strings[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = s;
        }
        return strings;
    }

    private static NonNullList<Ingredient> dissolvePattern(String[][] pPattern, Map<String, Ingredient> pKeys) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(pKeys.keySet());
        set.remove(" ");
        for (int i = 0; i < pPattern.length; ++i) {
            for (int j = 0; j < pPattern[i].length; ++j) {
                for (int k = 0; k < pPattern[i][j].length(); ++k) {
                    String s = pPattern[i][j].substring(k, k + 1);
                    Ingredient ingredient = pKeys.get(s);
                    if (ingredient == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                    }
                    set.remove(s);
                    nonnulllist.set(k + j * 3 + 9 * i, (Object)ingredient);
                }
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return nonnulllist;
    }

    public static class Builder
    implements RecipeBuilder {
        private final Item result;
        private final Ingredient tool;
        private final List<String> bottomRows = Lists.newArrayList();
        private final List<String> middleRows = Lists.newArrayList();
        private final List<String> topRows = Lists.newArrayList();
        private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
        private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

        protected Builder(Ingredient tool, ItemLike pResult) {
            this.tool = tool;
            this.result = pResult.m_5456_();
        }

        public static Builder recipe(TagKey<Item> tool, ItemLike pResult) {
            return new Builder(Ingredient.m_204132_(tool), pResult);
        }

        public Builder define(Character pSymbol, TagKey<Item> pTag) {
            return this.define(pSymbol, Ingredient.m_204132_(pTag));
        }

        public Builder define(Character pSymbol, ItemLike pItem) {
            return this.define(pSymbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItem}));
        }

        public Builder define(Character pSymbol, Ingredient pIngredient) {
            if (this.key.containsKey(pSymbol)) {
                throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
            }
            if (pSymbol.charValue() == ' ') {
                throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
            }
            this.key.put(pSymbol, pIngredient);
            return this;
        }

        public Builder bottomPattern(String pPattern) {
            return this.pattern(pPattern, this.bottomRows);
        }

        public Builder middlePattern(String pPattern) {
            return this.pattern(pPattern, this.middleRows);
        }

        public Builder topPattern(String pPattern) {
            return this.pattern(pPattern, this.topRows);
        }

        @NotNull
        public Builder unlockedBy(@NotNull String pCriterionName, @NotNull CriterionTriggerInstance pCriterionTrigger) {
            this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
            return this;
        }

        @NotNull
        public Builder group(@Nullable String pGroupName) {
            return this;
        }

        @NotNull
        public Item m_142372_() {
            return this.result;
        }

        public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, @NotNull ResourceLocation pRecipeId) {
            this.ensureValid(pRecipeId);
            this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
            pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.key, this.bottomRows, this.middleRows, this.topRows, this.tool, this.result, this.advancement, pRecipeId.m_246208_("recipes/workspace_crafting/")));
        }

        private Builder pattern(String pPattern, List<String> list) {
            if (pPattern.length() != 3) {
                throw new IllegalArgumentException("Pattern must have exactly 3 characters!");
            }
            if (list.size() == 3) {
                throw new IllegalArgumentException("Pattern must have exactly 3 rows!");
            }
            list.add(pPattern);
            return this;
        }

        private void ensureValid(ResourceLocation pId) {
            if (this.bottomRows.isEmpty()) {
                throw new IllegalStateException("No pattern is defined for bottom layer for recipe " + String.valueOf(pId) + "!");
            }
            if (this.middleRows.isEmpty()) {
                throw new IllegalStateException("No pattern is defined for middle layer for recipe " + String.valueOf(pId) + "!");
            }
            if (this.topRows.isEmpty()) {
                throw new IllegalStateException("No pattern is defined for bottom layer for recipe " + String.valueOf(pId) + "!");
            }
            HashSet set = Sets.newHashSet(this.key.keySet());
            set.remove(Character.valueOf(' '));
            this.processList(pId, this.bottomRows, set);
            this.processList(pId, this.middleRows, set);
            this.processList(pId, this.topRows, set);
            if (!set.isEmpty()) {
                throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(pId));
            }
            if (this.bottomRows.size() != 3 || this.middleRows.size() != 3 || this.topRows.size() != 3) {
                throw new IllegalStateException("Recipe " + String.valueOf(pId) + " has invalid count of rows");
            }
            if (this.advancement.m_138405_().isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
            }
        }

        private void processList(ResourceLocation pId, List<String> rows, Set<Character> set) {
            for (String s : rows) {
                for (int i = 0; i < s.length(); ++i) {
                    char c0 = s.charAt(i);
                    if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                        throw new IllegalStateException("Pattern in recipe " + String.valueOf(pId) + " uses undefined symbol '" + c0 + "'");
                    }
                    set.remove(Character.valueOf(c0));
                }
            }
        }
    }

    public record Result(@NotNull ResourceLocation id, @NotNull Map<Character, Ingredient> keyMap, List<String> bottom, List<String> middle, List<String> top, Ingredient tool, @NotNull Item result, @NotNull Advancement.Builder advancement, @NotNull ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(@NotNull JsonObject pJson) {
            JsonObject keyObject = new JsonObject();
            JsonObject resultObject = new JsonObject();
            pJson.add("pattern", (JsonElement)this.getPattern());
            for (Map.Entry<Character, Ingredient> entry : this.keyMap.entrySet()) {
                keyObject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            pJson.add("key", (JsonElement)keyObject);
            resultObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            pJson.add("tool", this.tool.m_43942_());
            pJson.add("result", (JsonElement)resultObject);
        }

        @NotNull
        private JsonObject getPattern() {
            JsonObject pattern = new JsonObject();
            JsonArray bottomArray = new JsonArray();
            JsonArray middleArray = new JsonArray();
            JsonArray topArray = new JsonArray();
            for (String s : this.bottom) {
                bottomArray.add(s);
            }
            for (String s : this.middle) {
                middleArray.add(s);
            }
            for (String s : this.top) {
                topArray.add(s);
            }
            pattern.add("bottom", (JsonElement)bottomArray);
            pattern.add("middle", (JsonElement)middleArray);
            pattern.add("top", (JsonElement)topArray);
            return pattern;
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)YTechRecipeSerializers.WORKSPACE_CRAFTING.get();
        }

        @NotNull
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @NotNull
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }

    public static class Serializer
    implements RecipeSerializer<WorkspaceCraftingRecipe> {
        @NotNull
        public WorkspaceCraftingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject pJson) {
            Map<String, Ingredient> keys = WorkspaceCraftingRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)pJson, (String)"key"));
            String[][] pattern = WorkspaceCraftingRecipe.patternFromJson(GsonHelper.m_13930_((JsonObject)pJson, (String)"pattern"));
            NonNullList<Ingredient> ingredients = WorkspaceCraftingRecipe.dissolvePattern(pattern, keys);
            Ingredient tool = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"tool"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            return new WorkspaceCraftingRecipe(recipeId, ingredients, tool, result);
        }

        @Nullable
        public WorkspaceCraftingRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            NonNullList ingredients = NonNullList.m_122780_((int)27, (Object)Ingredient.f_43901_);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            Ingredient tool = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new WorkspaceCraftingRecipe(recipeId, (NonNullList<Ingredient>)ingredients, tool, result);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull WorkspaceCraftingRecipe recipe) {
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            recipe.tool.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }
    }
}

