/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import com.yanny.ytech.configuration.block_entity.CraftingWorkspaceBlockEntity;
import com.yanny.ytech.configuration.renderer.FakeCraftingWorkspaceLevel;
import com.yanny.ytech.configuration.renderer.FluidVertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public class CraftingWorkspaceRenderer
implements BlockEntityRenderer<CraftingWorkspaceBlockEntity> {
    private static final FakeCraftingWorkspaceLevel FAKE_LEVEL;

    public CraftingWorkspaceRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull CraftingWorkspaceBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.33333334f, 0.33333334f, 0.33333334f);
        if (level != null) {
            int bitmask = blockEntity.getBitmask();
            int i = 0;
            NonNullList<ItemStack> items = blockEntity.getItems();
            NonNullList<BlockState> states = blockEntity.getBlockStates();
            FAKE_LEVEL.setData(blockEntity.m_58899_(), level, items, states);
            ModelBlockRenderer.m_111000_();
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    for (int x = 0; x < 3; ++x) {
                        if ((bitmask >> i & 1) == 1) {
                            int[] position = CraftingWorkspaceBlock.getPosition(i);
                            ItemStack itemStack = (ItemStack)items.get(i);
                            BlockState state = (BlockState)states.get(i);
                            if (position == null || itemStack.m_41619_()) {
                                ++i;
                                continue;
                            }
                            poseStack.m_85836_();
                            poseStack.m_252880_((float)x, (float)y, (float)z);
                            if (!state.m_60819_().m_76178_()) {
                                pos = new BlockPos(x + 1, y + 1, z + 1);
                                poseStack.m_252880_((float)(-x), (float)(-y), (float)(-z));
                                poseStack.m_252880_(-1.0f, -1.0f, -1.0f);
                                FluidVertexConsumer vertexConsumer = new FluidVertexConsumer(buffer, state.m_60819_(), poseStack.m_85850_().m_252922_(), poseStack.m_85850_().m_252943_());
                                Minecraft.m_91087_().m_91289_().m_234363_(pos, (BlockAndTintGetter)FAKE_LEVEL, (VertexConsumer)vertexConsumer, state, state.m_60819_());
                            } else if (itemStack.m_41720_() instanceof BlockItem) {
                                pos = new BlockPos(x + 1, y + 1, z + 1);
                                BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
                                for (RenderType renderType : model.getRenderTypes(state, RandomSource.m_216335_((long)state.m_60726_(pos)), ModelData.EMPTY)) {
                                    VertexConsumer vertexConsumer = buffer.m_6299_(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType));
                                    Minecraft.m_91087_().m_91289_().m_110937_().tesselateBlock((BlockAndTintGetter)FAKE_LEVEL, model, state, pos, poseStack, vertexConsumer, true, RandomSource.m_216327_(), state.m_60726_(pos), packedOverlay, ModelData.EMPTY, renderType);
                                }
                            } else {
                                poseStack.m_85837_(0.5, 0.5, 0.5);
                                poseStack.m_85836_();
                                poseStack.m_272245_(Axis.f_252392_.m_252977_((float)(level.m_46467_() % 360L)), 0.0f, 0.0f, 0.0f);
                                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                                BakedModel bakedmodel = itemRenderer.m_174264_(itemStack, level, null, 0);
                                itemRenderer.m_115143_(itemStack, ItemDisplayContext.FIXED, false, poseStack, buffer, packedLight, packedOverlay, bakedmodel);
                                poseStack.m_85849_();
                            }
                            poseStack.m_85849_();
                        }
                        ++i;
                    }
                }
            }
            FAKE_LEVEL.clearData();
            ModelBlockRenderer.m_111077_();
        }
        poseStack.m_85849_();
    }

    static {
        ObjenesisStd objenesis = new ObjenesisStd();
        ObjectInstantiator instantiator = objenesis.getInstantiatorOf(FakeCraftingWorkspaceLevel.class);
        FAKE_LEVEL = (FakeCraftingWorkspaceLevel)((Object)instantiator.newInstance());
        FAKE_LEVEL.init();
    }
}

