/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yanny.ytech.configuration.SpearType;
import com.yanny.ytech.configuration.item.SpearItem;
import com.yanny.ytech.configuration.model.SpearModel;
import com.yanny.ytech.registration.YTechItems;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class YTechRenderer
extends BlockEntityWithoutLevelRenderer {
    @NotNull
    public static final BlockEntityWithoutLevelRenderer INSTANCE = new YTechRenderer();
    @NotNull
    private final ItemModelShaper itemModelShaper;
    @NotNull
    private final ItemRenderer itemRenderer;
    @NotNull
    private final BakedModel missingModel;
    private final Map<SpearType, SpearModel> spearModels = new HashMap<SpearType, SpearModel>();

    private YTechRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        this.itemModelShaper = Minecraft.m_91087_().m_91291_().m_115103_();
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
        this.missingModel = Minecraft.m_91087_().m_91304_().m_119409_();
        for (SpearType type : SpearType.values()) {
            this.spearModels.put(type, new SpearModel(Minecraft.m_91087_().m_167973_().m_171103_(SpearModel.LAYER_LOCATIONS.get((Object)type))));
        }
    }

    public void m_108829_(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85849_();
        poseStack.m_85836_();
        if (stack.m_41720_() instanceof SpearItem) {
            this.renderStatic(stack, displayContext, packedLight, packedOverlay, poseStack, buffer, (Level)Minecraft.m_91087_().f_91073_, 0);
        } else {
            super.m_108829_(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    public void render(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, boolean leftHand, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay, @NotNull BakedModel bakedModel) {
        if (!stack.m_41619_()) {
            boolean is2dModel;
            poseStack.m_85836_();
            boolean bl = is2dModel = displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.GROUND || displayContext == ItemDisplayContext.FIXED;
            if (is2dModel) {
                for (SpearType spearType : this.spearModels.keySet()) {
                    if (!stack.m_150930_((Item)((RegistryObject)YTechItems.SPEARS.get(spearType.materialType)).get())) continue;
                    bakedModel = this.itemModelShaper.m_109393_().m_119422_(SpearModel.MODEL_LOCATIONS.get((Object)spearType));
                    break;
                }
            }
            bakedModel = bakedModel.applyTransform(displayContext, poseStack, leftHand);
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            for (Map.Entry entry : this.spearModels.entrySet()) {
                Block block;
                if (stack.m_150930_((Item)((RegistryObject)YTechItems.SPEARS.get(((SpearType)((Object)entry.getKey())).materialType)).get()) && !is2dModel) {
                    poseStack.m_85836_();
                    poseStack.m_85841_(1.0f, -1.0f, -1.0f);
                    VertexConsumer vertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)((SpearModel)((Object)entry.getValue())).m_103119_(SpearType.TEXTURE_LOCATION), (boolean)false, (boolean)stack.m_41790_());
                    ((SpearModel)((Object)entry.getValue())).m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    poseStack.m_85849_();
                    continue;
                }
                boolean isFabulous = displayContext != ItemDisplayContext.GUI && !displayContext.m_269069_() && stack.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)stack.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                for (BakedModel model : bakedModel.getRenderPasses(stack, isFabulous)) {
                    for (RenderType rendertype : model.getRenderTypes(stack, isFabulous)) {
                        VertexConsumer vertexConsumer = isFabulous ? ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.m_41790_());
                        this.itemRenderer.m_115189_(model, stack, packedLight, packedOverlay, poseStack, vertexConsumer);
                    }
                }
            }
            poseStack.m_85849_();
        }
    }

    public void renderStatic(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, int packedLight, int packedOverlay, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, @Nullable Level pLevel, int seed) {
        boolean leftHand = displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        this.renderStatic((LivingEntity)Minecraft.m_91087_().f_91074_, stack, displayContext, leftHand, poseStack, buffer, pLevel, packedLight, packedOverlay, seed);
    }

    public void renderStatic(@Nullable LivingEntity pEntity, @NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, boolean pLeftHand, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, @Nullable Level pLevel, int packedLight, int packedOverlay, int seed) {
        if (!stack.m_41619_()) {
            BakedModel bakedmodel = this.getModel(stack, pLevel, pEntity, seed);
            this.render(stack, displayContext, pLeftHand, poseStack, buffer, packedLight, packedOverlay, bakedmodel);
        }
    }

    @NotNull
    public BakedModel getModel(@NotNull ItemStack stack, @Nullable Level level, @Nullable LivingEntity pEntity, int seed) {
        BakedModel bakedModel = this.itemModelShaper.m_109406_(stack);
        for (SpearType spearType : this.spearModels.keySet()) {
            if (!stack.m_150930_((Item)((RegistryObject)YTechItems.SPEARS.get(spearType.materialType)).get())) continue;
            bakedModel = this.itemModelShaper.m_109393_().m_119422_(SpearModel.MODEL_IN_HAND_LOCATIONS.get((Object)spearType));
        }
        ClientLevel clientlevel = level instanceof ClientLevel ? (ClientLevel)level : null;
        BakedModel modelOverride = bakedModel.m_7343_().m_173464_(bakedModel, stack, clientlevel, pEntity, seed);
        return modelOverride == null ? this.missingModel : modelOverride;
    }
}

