/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.GrassBedBlock;
import com.yanny.ytech.configuration.block.WellPulleyBlock;
import com.yanny.ytech.configuration.entity.DeerEntity;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechEntityTypes;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

class YTechLootTableProvider
extends LootTableProvider {
    public YTechLootTableProvider(PackOutput packOutput) {
        super(packOutput, Collections.emptySet(), YTechLootTableProvider.getSubProviders());
    }

    protected void validate(@NotNull Map<ResourceLocation, LootTable> map, @NotNull ValidationContext validationcontext) {
    }

    private static List<LootTableProvider.SubProviderEntry> getSubProviders() {
        return List.of(new LootTableProvider.SubProviderEntry(YTechBlockLootSub::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(YTechEntityLootSub::new, LootContextParamSets.f_81415_), new LootTableProvider.SubProviderEntry(YTechFishingLootSub::new, LootContextParamSets.f_81414_));
    }

    private static Stream<Map.Entry<MaterialType, RegistryObject<Block>>> filteredStream(YTechBlocks.MaterialBlock block, EnumSet<MaterialType> exclude) {
        return block.entries().stream().filter(entry -> !exclude.contains(entry.getKey()));
    }

    private static void registerMaterialLootTable(YTechBlocks.MaterialBlock block, Consumer<RegistryObject<Block>> loot, EnumSet<MaterialType> exclude) {
        YTechLootTableProvider.filteredStream(block, exclude).map(Map.Entry::getValue).forEach(loot);
    }

    private static void registerMaterialLootTable(YTechBlocks.MaterialBlock block, BiConsumer<RegistryObject<Block>, MaterialType> loot, EnumSet<MaterialType> exclude) {
        YTechLootTableProvider.filteredStream(block, exclude).forEach(entry -> loot.accept((RegistryObject)entry.getValue(), (MaterialType)entry.getKey()));
    }

    private static void registerMaterialLootTable(YTechBlocks.MaterialBlock block, BiConsumer<RegistryObject<Block>, MaterialType> loot) {
        block.entries().forEach(entry -> loot.accept((RegistryObject)entry.getValue(), (MaterialType)entry.getKey()));
    }

    private static void registerMaterialLootTable(YTechBlocks.MaterialBlock block, Consumer<RegistryObject<Block>> loot) {
        block.entries().forEach(entry -> loot.accept((RegistryObject)entry.getValue()));
    }

    private static class YTechFishingLootSub
    implements LootTableSubProvider {
        private final Map<ResourceLocation, LootTable.Builder> map = new HashMap<ResourceLocation, LootTable.Builder>();

        private YTechFishingLootSub() {
        }

        private void generateStrainerLootTable() {
            LootTable.Builder builder = LootTable.m_79147_();
            builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41983_).m_79707_(100)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41830_).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41832_).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78720_).m_79707_(10)).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_((TagKey)YTechItemTags.MESHES.get(MaterialType.TWINE)))));
            builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41983_).m_79707_(70)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41830_).m_79707_(50)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.7f)).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_((TagKey)YTechItemTags.MESHES.get(MaterialType.COPPER)))));
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.COPPER)), 0.3f, (Item)((RegistryObject)YTechItems.RAW_MATERIALS.get(MaterialType.CASSITERITE)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.COPPER)), 0.2f, (Item)((RegistryObject)YTechItems.RAW_MATERIALS.get(MaterialType.GALENA)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.COPPER)), 0.1f, (Item)((RegistryObject)YTechItems.RAW_MATERIALS.get(MaterialType.COPPER)).get());
            builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41983_)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f)).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)))));
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)), 0.3f, (Item)((RegistryObject)YTechItems.RAW_MATERIALS.get(MaterialType.CASSITERITE)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)), 0.2f, (Item)((RegistryObject)YTechItems.RAW_MATERIALS.get(MaterialType.GALENA)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)), 0.1f, (Item)((RegistryObject)YTechItems.RAW_MATERIALS.get(MaterialType.COPPER)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)), 0.05f, (Item)((RegistryObject)YTechItems.RAW_MATERIALS.get(MaterialType.GOLD)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)), 0.05f, (Item)((RegistryObject)YTechItems.RAW_MATERIALS.get(MaterialType.IRON)).get());
            this.add(Utils.modLoc("strainer"), builder);
        }

        private void addPool(LootTable.Builder builder, TagKey<Item> tool, float chance, Item item) {
            builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance)).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(tool))));
        }

        private void add(ResourceLocation location, LootTable.Builder builder) {
            this.map.put(location, builder);
        }

        public void m_245126_(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
            this.generateStrainerLootTable();
            this.map.forEach((k, v) -> biConsumer.accept(k.m_246208_("fishing/"), (LootTable.Builder)v));
        }
    }

    private static class YTechEntityLootSub
    extends EntityLootSubProvider {
        protected YTechEntityLootSub() {
            super(FeatureFlagSet.m_247091_((FeatureFlag)FeatureFlags.f_244571_), FeatureFlagSet.m_246902_());
        }

        public void m_246942_() {
            this.registerAurochsLootTable();
            this.registerDeerLootTable();
            this.registerFowlLootTable();
            this.registerMouflonLootTable();
            this.registerSaberToothTigerLootTable();
            this.registerTerrorBirdLootTable();
            this.registerWildBoarLootTable();
            this.registerWoollyMammothLootTable();
            this.registerWoollyRhinoLootTable();
        }

        private void registerAurochsLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_());
            this.m_245309_((EntityType)YTechEntityTypes.AUROCHS.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42579_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        private void registerDeerLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_());
            this.m_245309_((EntityType)YTechEntityTypes.DEER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)YTechItems.VENISON.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)YTechItems.ANTLER.get())).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36654_(NbtPredicate.m_57481_((JsonElement)new JsonPrimitive(DeerEntity.hasAntlersStr())))))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))))));
        }

        private void registerFowlLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_());
            this.m_245309_((EntityType)YTechEntityTypes.FOWL.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42581_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        private void registerMouflonLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_());
            this.m_245309_((EntityType)YTechEntityTypes.MOUFLON.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42658_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        private void registerSaberToothTigerLootTable() {
            this.m_245309_((EntityType)YTechEntityTypes.SABER_TOOTH_TIGER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        private void registerTerrorBirdLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_());
            this.m_245309_((EntityType)YTechEntityTypes.TERROR_BIRD.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42581_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        private void registerWildBoarLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_());
            this.m_245309_((EntityType)YTechEntityTypes.WILD_BOAR.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42485_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        private void registerWoollyMammothLootTable() {
            this.m_245309_((EntityType)YTechEntityTypes.WOOLLY_MAMMOTH.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)6.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)YTechItems.MAMMOTH_TUSK.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))))));
        }

        private void registerWoollyRhinoLootTable() {
            this.m_245309_((EntityType)YTechEntityTypes.WOOLLY_RHINO.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)YTechItems.RHINO_HORN.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }
    }

    private static class YTechBlockLootSub
    extends BlockLootSubProvider {
        protected YTechBlockLootSub() {
            super(new HashSet(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.dropSelf(YTechBlocks.AMPHORA);
            this.dropSelf(YTechBlocks.AQUEDUCT_FERTILIZER);
            this.dropSelf(YTechBlocks.AQUEDUCT_HYDRATOR);
            this.dropSelf(YTechBlocks.AQUEDUCT_VALVE);
            this.dropSelf(YTechBlocks.BRICK_CHIMNEY);
            this.dropSelf(YTechBlocks.BRONZE_ANVIL);
            this.dropSelf(YTechBlocks.FIRE_PIT);
            GrassBedBlock.registerLootTable(this);
            this.dropSelf(YTechBlocks.MILLSTONE);
            this.dropSelf(YTechBlocks.POTTERS_WHEEL);
            this.dropSelf(YTechBlocks.PRIMITIVE_ALLOY_SMELTER);
            this.dropSelf(YTechBlocks.PRIMITIVE_SMELTER);
            this.dropSelf(YTechBlocks.REINFORCED_BRICKS);
            this.dropSelf(YTechBlocks.REINFORCED_BRICK_CHIMNEY);
            this.dropSelf(YTechBlocks.STRAINER);
            this.dropSelf(YTechBlocks.TERRACOTTA_BRICKS);
            this.registerSlabLootTable(YTechBlocks.TERRACOTTA_BRICK_SLAB);
            this.dropSelf(YTechBlocks.TERRACOTTA_BRICK_STAIRS);
            this.dropSelf(YTechBlocks.THATCH);
            this.registerSlabLootTable(YTechBlocks.THATCH_SLAB);
            this.dropSelf(YTechBlocks.THATCH_STAIRS);
            this.dropSelf(YTechBlocks.TOOL_RACK);
            this.dropSelf(YTechBlocks.TREE_STUMP);
            this.registerWellPulleyLootTable();
            this.dropSelf(YTechBlocks.WOODEN_BOX);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.AQUEDUCTS, this::dropSelf);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.DEEPSLATE_ORES, this::oreLoot, MaterialType.VANILLA_METALS);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.DRYING_RACKS, this::dropSelf);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.GRAVEL_DEPOSITS, (block, material) -> this.depositLootProvider((RegistryObject<Block>)block, (MaterialType)material, Items.f_41832_));
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.NETHER_ORES, this::oreLoot, EnumSet.of(MaterialType.GOLD));
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.RAW_STORAGE_BLOCKS, this::dropSelf, MaterialType.VANILLA_METALS);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.SAND_DEPOSITS, (block, material) -> this.depositLootProvider((RegistryObject<Block>)block, (MaterialType)material, Items.f_41830_));
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.STONE_ORES, this::oreLoot, MaterialType.VANILLA_METALS);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.STORAGE_BLOCKS, this::dropSelf, MaterialType.VANILLA_METALS);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.TANNING_RACKS, this::dropSelf);
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return Stream.of(Stream.of(YTechBlocks.AMPHORA, YTechBlocks.AQUEDUCT_FERTILIZER, YTechBlocks.AQUEDUCT_HYDRATOR, YTechBlocks.AQUEDUCT_VALVE, YTechBlocks.BRICK_CHIMNEY, YTechBlocks.BRONZE_ANVIL, YTechBlocks.FIRE_PIT, YTechBlocks.GRASS_BED, YTechBlocks.MILLSTONE, YTechBlocks.POTTERS_WHEEL, YTechBlocks.PRIMITIVE_ALLOY_SMELTER, YTechBlocks.PRIMITIVE_SMELTER, YTechBlocks.REINFORCED_BRICKS, YTechBlocks.REINFORCED_BRICK_CHIMNEY, YTechBlocks.STRAINER, YTechBlocks.TERRACOTTA_BRICKS, YTechBlocks.TERRACOTTA_BRICK_SLAB, YTechBlocks.TERRACOTTA_BRICK_STAIRS, YTechBlocks.THATCH, YTechBlocks.THATCH_SLAB, YTechBlocks.THATCH_STAIRS, YTechBlocks.TREE_STUMP, YTechBlocks.TOOL_RACK, YTechBlocks.WELL_PULLEY, YTechBlocks.WOODEN_BOX).map(RegistryObject::get), YTechBlocks.AQUEDUCTS.entries().stream().map(Map.Entry::getValue).map(RegistryObject::get), YTechLootTableProvider.filteredStream(YTechBlocks.DEEPSLATE_ORES, MaterialType.VANILLA_METALS).map(Map.Entry::getValue).map(RegistryObject::get), YTechBlocks.DRYING_RACKS.entries().stream().map(Map.Entry::getValue).map(RegistryObject::get), YTechBlocks.GRAVEL_DEPOSITS.entries().stream().map(Map.Entry::getValue).map(RegistryObject::get), YTechLootTableProvider.filteredStream(YTechBlocks.NETHER_ORES, EnumSet.of(MaterialType.GOLD)).map(Map.Entry::getValue).map(RegistryObject::get), YTechLootTableProvider.filteredStream(YTechBlocks.RAW_STORAGE_BLOCKS, MaterialType.VANILLA_METALS).map(Map.Entry::getValue).map(RegistryObject::get), YTechBlocks.SAND_DEPOSITS.entries().stream().map(Map.Entry::getValue).map(RegistryObject::get), YTechLootTableProvider.filteredStream(YTechBlocks.STONE_ORES, MaterialType.VANILLA_METALS).map(Map.Entry::getValue).map(RegistryObject::get), YTechLootTableProvider.filteredStream(YTechBlocks.STORAGE_BLOCKS, MaterialType.VANILLA_METALS).map(Map.Entry::getValue).map(RegistryObject::get), YTechBlocks.TANNING_RACKS.entries().stream().map(Map.Entry::getValue).map(RegistryObject::get)).flatMap(i -> i).toList();
        }

        private void dropSelf(RegistryObject<Block> block) {
            this.m_245724_((Block)block.get());
        }

        private void registerSlabLootTable(RegistryObject<Block> block) {
            this.m_246481_((Block)block.get(), arg_0 -> ((YTechBlockLootSub)this).m_247233_(arg_0));
        }

        private void oreLoot(RegistryObject<Block> block, MaterialType material) {
            this.m_246481_((Block)block.get(), b -> this.m_246109_((Block)b, (Item)((RegistryObject)YTechItems.RAW_MATERIALS.get(material)).get()));
        }

        private void depositLootProvider(RegistryObject<Block> object, MaterialType material, @NotNull Item baseItem) {
            LootItemCondition.Builder hasSilkTouch = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
            this.m_246481_((Block)object.get(), block -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(hasSilkTouch).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(hasSilkTouch.m_81807_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)baseItem))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(hasSilkTouch.m_81807_()).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)((RegistryObject)YTechItems.CRUSHED_MATERIALS.get(material)).get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.25f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2)))));
        }

        private void registerWellPulleyLootTable() {
            this.m_246481_((Block)YTechBlocks.WELL_PULLEY.get(), b -> this.m_245178_((Block)b, (Property)WellPulleyBlock.WELL_PART, (Comparable)((Object)WellPulleyBlock.WellPulleyPart.BASE)));
        }
    }
}

