/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.loot_modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yanny.ytech.registration.YTechGLMCodecs;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ReplaceItemModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("oldItem").forGetter(m -> m.oldItem)).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("newItem").forGetter(m -> m.newItem)).apply((Applicative)inst, ReplaceItemModifier::new)));
    private final Item oldItem;
    private final Item newItem;

    public ReplaceItemModifier(LootItemCondition[] conditionsIn, Item oldItem, Item newItem) {
        super(conditionsIn);
        this.oldItem = oldItem;
        this.newItem = newItem;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (int i = 0; i < generatedLoot.size(); ++i) {
            ItemStack item = (ItemStack)generatedLoot.get(i);
            if (!item.m_150930_(this.oldItem)) continue;
            generatedLoot.set(i, (Object)new ItemStack((ItemLike)this.newItem, item.m_41613_()));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)YTechGLMCodecs.REPLACE_ITEM.get();
    }
}

