/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.network.generic.server;

import com.mojang.logging.LogUtils;
import com.yanny.ytech.network.generic.NetworkUtils;
import com.yanny.ytech.network.generic.common.INetworkBlockEntity;
import com.yanny.ytech.network.generic.common.NetworkFactory;
import com.yanny.ytech.network.generic.server.ServerLevelData;
import com.yanny.ytech.network.generic.server.ServerNetwork;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerPropagator<N extends ServerNetwork<N, O>, O extends INetworkBlockEntity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private final HashMap<ResourceLocation, ServerLevelData<N, O>> levelMap = new HashMap();
    @NotNull
    private final NetworkFactory<N, O> networkFactory;
    @NotNull
    private final String networkName;

    public ServerPropagator(@NotNull NetworkFactory<N, O> networkFactory, @NotNull String networkName) {
        this.networkFactory = networkFactory;
        this.networkName = networkName;
    }

    public void add(@NotNull O blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.levelMap.get(NetworkUtils.getLevelId((Level)level2)).add(blockEntity);
        } else {
            LOGGER.warn("[{}][add] Invalid ServerLevel reference: {}", (Object)this.networkName, (Object)blockEntity.m_58904_());
        }
    }

    public void changed(@NotNull O blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.levelMap.get(NetworkUtils.getLevelId((Level)level2)).update(blockEntity);
        } else {
            LOGGER.warn("[{}][changed] Invalid ServerLevel reference: {}", (Object)this.networkName, (Object)blockEntity.m_58904_());
        }
    }

    public void remove(@NotNull O blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.levelMap.get(NetworkUtils.getLevelId((Level)level2)).remove(blockEntity);
        } else {
            LOGGER.warn("[{}][remove] Invalid ServerLevel reference: {}", (Object)this.networkName, (Object)blockEntity.m_58904_());
        }
    }

    public void onLevelLoad(@NotNull ServerLevel level) {
        ResourceLocation id = NetworkUtils.getLevelId((Level)level);
        LOGGER.debug("[{}][onLevelLoad] Preparing propagators for {}", (Object)this.networkName, (Object)id);
        this.levelMap.put(id, (ServerLevelData)level.m_8895_().m_164861_(tag -> new ServerLevelData<N, O>((CompoundTag)tag, id, level.m_7654_(), this.networkFactory, this.networkName), () -> new ServerLevelData<N, O>(id, level.m_7654_(), this.networkFactory, this.networkName), "ytech_" + this.networkName));
        LOGGER.debug("[{}][onLevelLoad] Prepared propagators for {}", (Object)this.networkName, (Object)id);
    }

    public void onLevelUnload(@NotNull ServerLevel level) {
        ResourceLocation id = NetworkUtils.getLevelId((Level)level);
        LOGGER.debug("[{}][onLevelUnload] Removing propagator for {}", (Object)this.networkName, (Object)id);
        this.levelMap.remove(id);
        LOGGER.debug("[{}][onLevelUnload] Removed propagator for {}", (Object)this.networkName, (Object)id);
    }

    public void onPlayerLogIn(@NotNull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LOGGER.debug("[{}][onPlayerLogIn] Connecting player {}", (Object)this.networkName, (Object)serverPlayer);
            this.networkFactory.sendLevelSync(PacketDistributor.PLAYER.with(() -> serverPlayer), this.levelMap.get(NetworkUtils.getLevelId(serverPlayer.m_9236_())).getNetworks());
        }
    }

    @Nullable
    public N getNetwork(@NotNull O blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ServerLevelData<N, O> levelData = this.levelMap.get(NetworkUtils.getLevelId((Level)level2));
            if (levelData != null) {
                return levelData.getNetwork(blockEntity);
            }
            LOGGER.warn("[{}][getNetwork] No {} network for level {}", new Object[]{this.networkName, this.networkName, level2});
            return null;
        }
        LOGGER.warn("[{}][getNetwork] Invalid ServerLevel reference: {}", (Object)this.networkName, (Object)blockEntity.m_58904_());
        return null;
    }

    @NotNull
    public Map<Integer, N> getNetworks(@NotNull ServerLevel level) {
        ServerLevelData<N, O> serverLevelData = this.levelMap.get(NetworkUtils.getLevelId((Level)level));
        if (serverLevelData != null) {
            return serverLevelData.getNetworks();
        }
        LOGGER.warn("[{}][getNetworks] No networks defined for level {}", (Object)this.networkName, (Object)level);
        return Map.of();
    }

    public void tick(@NotNull ServerLevel level) {
        ServerLevelData<N, O> serverLevelData = this.levelMap.get(NetworkUtils.getLevelId((Level)level));
        if (serverLevelData != null) {
            serverLevelData.tick(level.m_7726_());
        } else {
            LOGGER.warn("[{}][tick] No networks defined for level {}", (Object)this.networkName, (Object)level);
        }
    }

    public void onChunkWatch(@NotNull ServerLevel level, @NotNull ServerPlayer player, @NotNull LevelChunk chunk) {
        ServerLevelData<N, O> serverLevelData = this.levelMap.get(NetworkUtils.getLevelId((Level)level));
        if (serverLevelData != null) {
            serverLevelData.getNetworks().values().stream().filter(network -> network.getChunks().contains(chunk.m_7697_())).forEach(network -> this.networkFactory.sendUpdated(PacketDistributor.PLAYER.with(() -> player), network));
        } else {
            LOGGER.warn("[{}][onChunkWatch] No networks defined for level {}", (Object)this.networkName, (Object)level);
        }
    }
}

