/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.registration;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;

public class YTechBlockTags {
    public static final TagKey<Block> AMPHORAE = YTechBlockTags.create("amphorae");
    public static final TagKey<Block> AQUEDUCT_FERTILIZERS = YTechBlockTags.create("aqueduct_fertilizers");
    public static final TagKey<Block> AQUEDUCT_HYDRATORS = YTechBlockTags.create("aqueduct_hydrators");
    public static final TagKey<Block> AQUEDUCT_VALVES = YTechBlockTags.create("aqueduct_valves");
    public static final TagKey<Block> BRICK_CHIMNEYS = YTechBlockTags.create("brick_chimneys");
    public static final TagKey<Block> BRONZE_ANVILS = YTechBlockTags.create("bronze_anvils");
    public static final TagKey<Block> CRAFTING_WORKSPACES = YTechBlockTags.create("crafting_workspaces");
    public static final TagKey<Block> FIRE_PITS = YTechBlockTags.create("fire_pits");
    public static final TagKey<Block> GRASS_BEDS = YTechBlockTags.create("grass_beds");
    public static final TagKey<Block> MILLSTONES = YTechBlockTags.create("millstones");
    public static final TagKey<Block> POTTERS_WHEELS = YTechBlockTags.create("potters_wheels");
    public static final TagKey<Block> PRIMITIVE_ALLOY_SMELTERS = YTechBlockTags.create("primitive_alloy_smelters");
    public static final TagKey<Block> PRIMITIVE_SMELTERS = YTechBlockTags.create("primitive_smelters");
    public static final TagKey<Block> REINFORCED_BRICKS = YTechBlockTags.create("reinforced_bricks");
    public static final TagKey<Block> REINFORCED_BRICK_CHIMNEYS = YTechBlockTags.create("reinforced_brick_chimneys");
    public static final TagKey<Block> STRAINERS = YTechBlockTags.create("strainers");
    public static final TagKey<Block> TERRACOTTA_BRICKS = YTechBlockTags.create("terracotta_bricks");
    public static final TagKey<Block> TERRACOTTA_BRICK_SLABS = YTechBlockTags.create("terracotta_brick_slabs");
    public static final TagKey<Block> TERRACOTTA_BRICK_STAIRS = YTechBlockTags.create("terracotta_brick_stairs");
    public static final TagKey<Block> THATCH = YTechBlockTags.create("thatch");
    public static final TagKey<Block> THATCH_SLABS = YTechBlockTags.create("thatch_slabs");
    public static final TagKey<Block> THATCH_STAIRS = YTechBlockTags.create("thatch_stairs");
    public static final TagKey<Block> TOOL_RACKS = YTechBlockTags.create("tool_racks");
    public static final TagKey<Block> TREE_STUMPS = YTechBlockTags.create("tree_stumps");
    public static final TagKey<Block> WELL_PULLEYS = YTechBlockTags.create("well_pulleys");
    public static final TagKey<Block> WOODEN_BOXES = YTechBlockTags.create("wooden_boxes");
    public static final TagKey<Block> AUROCHS_RAID_BLOCKS = YTechBlockTags.create("aurochs_raid_blocks");
    public static final TagKey<Block> DEER_RAID_BLOCKS = YTechBlockTags.create("deer_raid_blocks");
    public static final TagKey<Block> FOWL_RAID_BLOCKS = YTechBlockTags.create("fowl_raid_blocks");
    public static final TagKey<Block> MOUFLON_RAID_BLOCKS = YTechBlockTags.create("mouflon_raid_blocks");
    public static final TagKey<Block> FIRE_SOURCE = YTechBlockTags.create("fire_source");
    public static final TagKey<Block> SOUL_FIRE_SOURCE = YTechBlockTags.create("soul_fire_source");
    public static final TagKey<Block> REQUIRE_VALID_TOOL = YTechBlockTags.create("require_valid_tool");
    public static final MaterialTag AQUEDUCTS = new MaterialTag("aqueducts", YTechBlocks.AQUEDUCTS);
    public static final MaterialTag DEEPSLATE_ORES = new DeepslateOreMaterialTag();
    public static final MaterialTag DRYING_RACKS = new MaterialTag("drying_racks", YTechBlocks.DRYING_RACKS);
    public static final MaterialTag GRAVEL_DEPOSITS = new MaterialTag("gravel_deposits", YTechBlocks.GRAVEL_DEPOSITS);
    public static final MaterialTag NETHER_ORES = new NetherOreMaterialTag();
    public static final MaterialTag RAW_STORAGE_BLOCKS = new RawStorageBlockMaterialTag();
    public static final MaterialTag SAND_DEPOSITS = new MaterialTag("sand_deposits", YTechBlocks.SAND_DEPOSITS);
    public static final MaterialTag STONE_ORES = new StoneOreMaterialTag();
    public static final MaterialTag STORAGE_BLOCKS = new StorageBlockMaterialTag();
    public static final MaterialTag TANNING_RACKS = new MaterialTag("tanning_racks", YTechBlocks.TANNING_RACKS);

    private static TagKey<Block> create(String name) {
        return BlockTags.create((ResourceLocation)Utils.modLoc(name));
    }

    public static class MaterialTag {
        protected final String name;
        protected final String namespace;
        public final TagKey<Block> tag;
        protected final Map<MaterialType, TagKey<Block>> tags;
        protected Function<MaterialType, String> materialNameSupplier;

        public MaterialTag(String name, YTechBlocks.MaterialBlock block) {
            this(name, YTechBlockTags.create(name), block);
        }

        public MaterialTag(String name, TagKey<Block> tag, YTechBlocks.MaterialBlock block) {
            this(name, "ytech", tag, block);
        }

        public MaterialTag(String name, String namespace, TagKey<Block> tag, YTechBlocks.MaterialBlock block) {
            this(name, namespace, tag, EnumSet.copyOf(block.materials()));
        }

        public MaterialTag(String name, String namespace, TagKey<Block> tag, EnumSet<MaterialType> materials) {
            this(name, namespace, tag, materials, type -> type.key);
        }

        public MaterialTag(String name, String namespace, TagKey<Block> tag, EnumSet<MaterialType> materials, Function<MaterialType, String> materialNameSupplier) {
            this.name = name;
            this.namespace = namespace;
            this.tag = tag;
            this.materialNameSupplier = materialNameSupplier;
            this.tags = new HashMap<MaterialType, TagKey<Block>>();
            materials.forEach(type -> this.tags.put((MaterialType)type, (TagKey<Block>)BlockTags.create((ResourceLocation)new ResourceLocation(namespace, name + "/" + (String)materialNameSupplier.apply((MaterialType)type)))));
        }

        public TagKey<Block> of(MaterialType material) {
            return Objects.requireNonNull(this.tags.get(material));
        }

        public Collection<TagKey<Block>> values() {
            return this.tags.values();
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    private static class DeepslateOreMaterialTag
    extends MaterialTag {
        public DeepslateOreMaterialTag() {
            super("ores", "forge", (TagKey<Block>)Tags.Blocks.ORES, Utils.exclude(EnumSet.copyOf(YTechBlocks.DEEPSLATE_ORES.materials()), MaterialType.VANILLA_METALS));
            this.tags.put(MaterialType.COPPER, Tags.Blocks.ORES_COPPER);
            this.tags.put(MaterialType.GOLD, Tags.Blocks.ORES_GOLD);
            this.tags.put(MaterialType.IRON, Tags.Blocks.ORES_IRON);
        }
    }

    private static class NetherOreMaterialTag
    extends MaterialTag {
        public NetherOreMaterialTag() {
            super("ores", "forge", (TagKey<Block>)Tags.Blocks.ORES, Utils.exclude(EnumSet.copyOf(YTechBlocks.NETHER_ORES.materials()), (Enum[])new MaterialType[]{MaterialType.GOLD}));
            this.tags.put(MaterialType.GOLD, Tags.Blocks.ORES_GOLD);
        }
    }

    private static class RawStorageBlockMaterialTag
    extends MaterialTag {
        public RawStorageBlockMaterialTag() {
            super("storage_blocks", "forge", (TagKey<Block>)Tags.Blocks.STORAGE_BLOCKS, Utils.exclude(EnumSet.copyOf(YTechBlocks.RAW_STORAGE_BLOCKS.materials()), MaterialType.VANILLA_METALS), type -> "raw_" + type.key);
            this.tags.put(MaterialType.COPPER, Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER);
            this.tags.put(MaterialType.GOLD, Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD);
            this.tags.put(MaterialType.IRON, Tags.Blocks.STORAGE_BLOCKS_RAW_IRON);
        }
    }

    private static class StoneOreMaterialTag
    extends MaterialTag {
        public StoneOreMaterialTag() {
            super("ores", "forge", (TagKey<Block>)Tags.Blocks.ORES, Utils.exclude(EnumSet.copyOf(YTechBlocks.STONE_ORES.materials()), MaterialType.VANILLA_METALS));
            this.tags.put(MaterialType.COPPER, Tags.Blocks.ORES_COPPER);
            this.tags.put(MaterialType.GOLD, Tags.Blocks.ORES_GOLD);
            this.tags.put(MaterialType.IRON, Tags.Blocks.ORES_IRON);
        }
    }

    private static class StorageBlockMaterialTag
    extends MaterialTag {
        public StorageBlockMaterialTag() {
            super("storage_blocks", "forge", (TagKey<Block>)Tags.Blocks.STORAGE_BLOCKS, Utils.exclude(EnumSet.copyOf(YTechBlocks.STORAGE_BLOCKS.materials()), MaterialType.VANILLA_METALS));
            this.tags.put(MaterialType.COPPER, Tags.Blocks.STORAGE_BLOCKS_COPPER);
            this.tags.put(MaterialType.GOLD, Tags.Blocks.STORAGE_BLOCKS_GOLD);
            this.tags.put(MaterialType.IRON, Tags.Blocks.STORAGE_BLOCKS_IRON);
        }
    }
}

