/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.registration;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.NameHolder;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.AmphoraBlock;
import com.yanny.ytech.configuration.block.AqueductBlock;
import com.yanny.ytech.configuration.block.AqueductFertilizerBlock;
import com.yanny.ytech.configuration.block.AqueductHydratorBlock;
import com.yanny.ytech.configuration.block.AqueductValveBlock;
import com.yanny.ytech.configuration.block.BrickChimneyBlock;
import com.yanny.ytech.configuration.block.BronzeAnvilBlock;
import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import com.yanny.ytech.configuration.block.DryingRackBlock;
import com.yanny.ytech.configuration.block.FirePitBlock;
import com.yanny.ytech.configuration.block.GrassBedBlock;
import com.yanny.ytech.configuration.block.MillstoneBlock;
import com.yanny.ytech.configuration.block.PottersWheelBlock;
import com.yanny.ytech.configuration.block.PrimitiveAlloySmelterBlock;
import com.yanny.ytech.configuration.block.PrimitiveSmelterBlock;
import com.yanny.ytech.configuration.block.ReinforcedBrickChimneyBlock;
import com.yanny.ytech.configuration.block.StrainerBlock;
import com.yanny.ytech.configuration.block.TanningRackBlock;
import com.yanny.ytech.configuration.block.ToolRackBlock;
import com.yanny.ytech.configuration.block.TreeStumpBlock;
import com.yanny.ytech.configuration.block.WellPulleyBlock;
import com.yanny.ytech.configuration.block.WoodenBoxBlock;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GravelBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class YTechBlocks {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"ytech");
    public static final RegistryObject<Block> AMPHORA = BLOCKS.register("amphora", AmphoraBlock::new);
    public static final RegistryObject<Block> AQUEDUCT_FERTILIZER = BLOCKS.register("aqueduct_fertilizer", AqueductFertilizerBlock::new);
    public static final RegistryObject<Block> AQUEDUCT_HYDRATOR = BLOCKS.register("aqueduct_hydrator", AqueductHydratorBlock::new);
    public static final RegistryObject<Block> AQUEDUCT_VALVE = BLOCKS.register("aqueduct_valve", AqueductValveBlock::new);
    public static final RegistryObject<Block> BRICK_CHIMNEY = BLOCKS.register("brick_chimney", BrickChimneyBlock::new);
    public static final RegistryObject<Block> BRONZE_ANVIL = BLOCKS.register("bronze_anvil", BronzeAnvilBlock::new);
    public static final RegistryObject<Block> CRAFTING_WORKSPACE = BLOCKS.register("crafting_workspace", CraftingWorkspaceBlock::new);
    public static final RegistryObject<Block> FIRE_PIT = BLOCKS.register("fire_pit", FirePitBlock::new);
    public static final RegistryObject<Block> GRASS_BED = BLOCKS.register("grass_bed", GrassBedBlock::new);
    public static final RegistryObject<Block> MILLSTONE = BLOCKS.register("millstone", MillstoneBlock::new);
    public static final RegistryObject<Block> POTTERS_WHEEL = BLOCKS.register("potters_wheel", PottersWheelBlock::new);
    public static final RegistryObject<Block> PRIMITIVE_ALLOY_SMELTER = BLOCKS.register("primitive_alloy_smelter", PrimitiveAlloySmelterBlock::new);
    public static final RegistryObject<Block> PRIMITIVE_SMELTER = BLOCKS.register("primitive_smelter", PrimitiveSmelterBlock::new);
    public static final RegistryObject<Block> REINFORCED_BRICKS = YTechBlocks.registerBlock("reinforced_bricks", (BlockBehaviour)Blocks.f_50076_);
    public static final RegistryObject<Block> REINFORCED_BRICK_CHIMNEY = BLOCKS.register("reinforced_brick_chimney", ReinforcedBrickChimneyBlock::new);
    public static final RegistryObject<Block> STRAINER = BLOCKS.register("strainer", StrainerBlock::new);
    public static final RegistryObject<Block> TERRACOTTA_BRICKS = YTechBlocks.registerBlock("terracotta_bricks", (BlockBehaviour)Blocks.f_50076_);
    public static final RegistryObject<Block> TERRACOTTA_BRICK_SLAB = YTechBlocks.registerSlab("terracotta_brick_slab", (BlockBehaviour)Blocks.f_50410_);
    public static final RegistryObject<Block> TERRACOTTA_BRICK_STAIRS = YTechBlocks.registerStairs("terracotta_brick_stairs", TERRACOTTA_BRICKS, (BlockBehaviour)Blocks.f_50193_);
    public static final RegistryObject<Block> THATCH = YTechBlocks.registerBlock("thatch", (BlockBehaviour)Blocks.f_50335_);
    public static final RegistryObject<Block> THATCH_SLAB = YTechBlocks.registerSlab("thatch_slab", (BlockBehaviour)Blocks.f_50335_);
    public static final RegistryObject<Block> THATCH_STAIRS = YTechBlocks.registerStairs("thatch_stairs", THATCH, (BlockBehaviour)Blocks.f_50335_);
    public static final RegistryObject<Block> TOOL_RACK = BLOCKS.register("tool_rack", ToolRackBlock::new);
    public static final RegistryObject<Block> TREE_STUMP = BLOCKS.register("tree_stump", TreeStumpBlock::new);
    public static final RegistryObject<Block> WELL_PULLEY = BLOCKS.register("well_pulley", WellPulleyBlock::new);
    public static final RegistryObject<Block> WOODEN_BOX = BLOCKS.register("wooden_box", WoodenBoxBlock::new);
    public static final MaterialBlock AQUEDUCTS = new MaterialBlock("aqueduct", NameHolder.suffix("aqueduct"), MaterialType.AQUEDUCT_MATERIALS, AqueductBlock::new);
    public static final MaterialBlock DEEPSLATE_ORES = new DeepslateOreMaterialBlock();
    public static final MaterialBlock DRYING_RACKS = new MaterialBlock("drying_rack", NameHolder.suffix("drying_rack"), MaterialType.ALL_WOODS, DryingRackBlock::new);
    public static final MaterialBlock GRAVEL_DEPOSITS = new MaterialBlock("gravel_deposit", NameHolder.suffix("gravel_deposit"), MaterialType.ALL_DEPOSIT_ORES, () -> new GravelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_)));
    public static final MaterialBlock NETHER_ORES = new NetherOreMaterialBlock();
    public static final MaterialBlock RAW_STORAGE_BLOCKS = new RawStorageBlockMaterialBlock();
    public static final MaterialBlock SAND_DEPOSITS = new MaterialBlock("sand_deposit", NameHolder.suffix("sand_deposit"), MaterialType.ALL_DEPOSIT_ORES, () -> new SandBlock(14406560, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_)));
    public static final MaterialBlock STONE_ORES = new StoneOreMaterialBlock();
    public static final MaterialBlock STORAGE_BLOCKS = new StorageBlockMaterialBlock();
    public static final MaterialBlock TANNING_RACKS = new MaterialBlock("tanning_rack", NameHolder.suffix("tanning_rack"), MaterialType.ALL_WOODS, TanningRackBlock::new);

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    private static RegistryObject<Block> registerBlock(String name, BlockBehaviour behaviour) {
        return BLOCKS.register(name, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)behaviour)));
    }

    private static RegistryObject<Block> registerSlab(String name, BlockBehaviour behaviour) {
        return BLOCKS.register(name, () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)behaviour)));
    }

    private static RegistryObject<Block> registerStairs(String name, RegistryObject<Block> baseBlock, BlockBehaviour behaviour) {
        return BLOCKS.register(name, () -> new StairBlock(() -> ((Block)baseBlock.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)behaviour)));
    }

    public static class MaterialBlock {
        protected final String group;
        protected final NameHolder nameHolder;
        protected final Map<MaterialType, RegistryObject<Block>> blocks;

        public MaterialBlock(String group, NameHolder nameHolder, EnumSet<MaterialType> materialTypes, Function<MaterialType, Block> itemSupplier) {
            this.group = group;
            this.nameHolder = nameHolder;
            this.blocks = new HashMap<MaterialType, RegistryObject<Block>>();
            materialTypes.forEach(type -> {
                Object key = nameHolder.prefix() != null ? nameHolder.prefix() + "_" : "";
                key = type.key.equals("gold") && nameHolder.prefix() == null ? (String)key + "golden" : (String)key + type.key;
                key = (String)key + (String)(nameHolder.suffix() != null ? "_" + nameHolder.suffix() : "");
                this.blocks.put((MaterialType)type, (RegistryObject<Block>)BLOCKS.register((String)key, () -> (Block)itemSupplier.apply((MaterialType)type)));
            });
        }

        public MaterialBlock(String group, NameHolder nameHolder, EnumSet<MaterialType> materialTypes, Supplier<Block> itemSupplier) {
            this(group, nameHolder, materialTypes, (MaterialType m) -> (Block)itemSupplier.get());
        }

        public RegistryObject<Block> of(MaterialType material) {
            return Objects.requireNonNull(this.blocks.get(material));
        }

        public Collection<RegistryObject<Block>> blocks() {
            return this.blocks.values();
        }

        public Set<MaterialType> materials() {
            return this.blocks.keySet();
        }

        public Set<Map.Entry<MaterialType, RegistryObject<Block>>> entries() {
            return this.blocks.entrySet();
        }

        public String getGroup() {
            return this.group;
        }
    }

    private static class DeepslateOreMaterialBlock
    extends MaterialBlock {
        public DeepslateOreMaterialBlock() {
            super("deepslate_ore", NameHolder.both("deepslate", "ore"), Utils.exclude(MaterialType.ALL_ORES, MaterialType.VANILLA_METALS), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152468_)));
            this.blocks.put(MaterialType.COPPER, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_152506_), (IForgeRegistry)ForgeRegistries.BLOCKS));
            this.blocks.put(MaterialType.GOLD, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_152467_), (IForgeRegistry)ForgeRegistries.BLOCKS));
            this.blocks.put(MaterialType.IRON, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_152468_), (IForgeRegistry)ForgeRegistries.BLOCKS));
        }
    }

    private static class NetherOreMaterialBlock
    extends MaterialBlock {
        public NetherOreMaterialBlock() {
            super("nether_ore", NameHolder.both("nether", "ore"), (EnumSet<MaterialType>)Utils.exclude(MaterialType.ALL_ORES, (Enum[])new MaterialType[]{MaterialType.GOLD}), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49998_)));
            this.blocks.put(MaterialType.GOLD, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_49998_), (IForgeRegistry)ForgeRegistries.BLOCKS));
        }
    }

    private static class RawStorageBlockMaterialBlock
    extends MaterialBlock {
        public RawStorageBlockMaterialBlock() {
            super("storage_block", NameHolder.both("raw", "block"), Utils.exclude(MaterialType.ALL_ORES, MaterialType.VANILLA_METALS), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152598_)));
            this.blocks.put(MaterialType.COPPER, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_152599_), (IForgeRegistry)ForgeRegistries.BLOCKS));
            this.blocks.put(MaterialType.GOLD, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_152600_), (IForgeRegistry)ForgeRegistries.BLOCKS));
            this.blocks.put(MaterialType.IRON, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_152598_), (IForgeRegistry)ForgeRegistries.BLOCKS));
        }
    }

    private static class StoneOreMaterialBlock
    extends MaterialBlock {
        public StoneOreMaterialBlock() {
            super("stone_ore", NameHolder.suffix("ore"), Utils.exclude(MaterialType.ALL_ORES, MaterialType.VANILLA_METALS), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)));
            this.blocks.put(MaterialType.COPPER, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_152505_), (IForgeRegistry)ForgeRegistries.BLOCKS));
            this.blocks.put(MaterialType.GOLD, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_49995_), (IForgeRegistry)ForgeRegistries.BLOCKS));
            this.blocks.put(MaterialType.IRON, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_49996_), (IForgeRegistry)ForgeRegistries.BLOCKS));
        }
    }

    private static class StorageBlockMaterialBlock
    extends MaterialBlock {
        public StorageBlockMaterialBlock() {
            super("storage_block", NameHolder.suffix("block"), Utils.exclude(MaterialType.ALL_METALS, MaterialType.VANILLA_METALS), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
            this.blocks.put(MaterialType.COPPER, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_152504_), (IForgeRegistry)ForgeRegistries.BLOCKS));
            this.blocks.put(MaterialType.GOLD, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50074_), (IForgeRegistry)ForgeRegistries.BLOCKS));
            this.blocks.put(MaterialType.IRON, RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50075_), (IForgeRegistry)ForgeRegistries.BLOCKS));
        }
    }
}

