/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.the_pumpkin_challenge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.the_pumpkin_challenge.ThePumpkinChallengeMod;
import net.mcreator.the_pumpkin_challenge.procedures.SkipButtonProcedure;
import net.mcreator.the_pumpkin_challenge.procedures.WildMerchantBackButtonProcedure;
import net.mcreator.the_pumpkin_challenge.procedures.WildMerchantNextButtonProcedure;
import net.mcreator.the_pumpkin_challenge.procedures.WildMerchantTabGearsProcedure;
import net.mcreator.the_pumpkin_challenge.procedures.WildMerchantTabMaterialsOthersProcedure;
import net.mcreator.the_pumpkin_challenge.procedures.WildMerchantTabMaterialsProcedure;
import net.mcreator.the_pumpkin_challenge.world.inventory.WildMerchMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WildMerchButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public WildMerchButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public WildMerchButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(WildMerchButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(WildMerchButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            WildMerchButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = WildMerchMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SkipButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            WildMerchantNextButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            WildMerchantBackButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            WildMerchantTabMaterialsProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            WildMerchantTabGearsProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            WildMerchantTabMaterialsOthersProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ThePumpkinChallengeMod.addNetworkMessage(WildMerchButtonMessage.class, WildMerchButtonMessage::buffer, WildMerchButtonMessage::new, WildMerchButtonMessage::handler);
    }
}

