/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.the_pumpkin_challenge.network;

import java.io.File;
import java.util.function.Supplier;
import net.mcreator.the_pumpkin_challenge.ThePumpkinChallengeMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ThePumpkinChallengeModVariables {
    public static double WildMerchanMaterials = 0.0;
    public static double WildMerchantGears = 0.0;
    public static double WildMerchantOthers = 0.0;
    public static File WildMerchantGear = new File("");
    public static File WildMerchantMaterial = new File("");
    public static File WildMerchantOther = new File("");
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ThePumpkinChallengeMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        ThePumpkinChallengeMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.ShadowArmor = message.data.ShadowArmor;
                    variables.PumpkinWait = message.data.PumpkinWait;
                    variables.PumpkinTier = message.data.PumpkinTier;
                    variables.PumpkinOST = message.data.PumpkinOST;
                    variables.PumpkinMusic = message.data.PumpkinMusic;
                    variables.PumpkinBlade = message.data.PumpkinBlade;
                    variables.FirstWave = message.data.FirstWave;
                    variables.FirstGoldWave = message.data.FirstGoldWave;
                    variables.WildMerchant = message.data.WildMerchant;
                    variables.WildMerchantPage = message.data.WildMerchantPage;
                    variables.WildMerchantTab = message.data.WildMerchantTab;
                    variables.ExecutionerBuff = message.data.ExecutionerBuff;
                    variables.BuyConfirm = message.data.BuyConfirm;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean ShadowArmor = false;
        public double PumpkinWait = 0.0;
        public double PumpkinTier = 1.0;
        public String PumpkinOST = "\"\"";
        public double PumpkinMusic = 0.0;
        public boolean PumpkinBlade = false;
        public boolean FirstWave = true;
        public boolean FirstGoldWave = true;
        public boolean WildMerchant = true;
        public double WildMerchantPage = 0.0;
        public String WildMerchantTab = "\"Materials\"";
        public boolean ExecutionerBuff = false;
        public double BuyConfirm = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ThePumpkinChallengeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("ShadowArmor", this.ShadowArmor);
            nbt.m_128347_("PumpkinWait", this.PumpkinWait);
            nbt.m_128347_("PumpkinTier", this.PumpkinTier);
            nbt.m_128359_("PumpkinOST", this.PumpkinOST);
            nbt.m_128347_("PumpkinMusic", this.PumpkinMusic);
            nbt.m_128379_("PumpkinBlade", this.PumpkinBlade);
            nbt.m_128379_("FirstWave", this.FirstWave);
            nbt.m_128379_("FirstGoldWave", this.FirstGoldWave);
            nbt.m_128379_("WildMerchant", this.WildMerchant);
            nbt.m_128347_("WildMerchantPage", this.WildMerchantPage);
            nbt.m_128359_("WildMerchantTab", this.WildMerchantTab);
            nbt.m_128379_("ExecutionerBuff", this.ExecutionerBuff);
            nbt.m_128347_("BuyConfirm", this.BuyConfirm);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.ShadowArmor = nbt.m_128471_("ShadowArmor");
            this.PumpkinWait = nbt.m_128459_("PumpkinWait");
            this.PumpkinTier = nbt.m_128459_("PumpkinTier");
            this.PumpkinOST = nbt.m_128461_("PumpkinOST");
            this.PumpkinMusic = nbt.m_128459_("PumpkinMusic");
            this.PumpkinBlade = nbt.m_128471_("PumpkinBlade");
            this.FirstWave = nbt.m_128471_("FirstWave");
            this.FirstGoldWave = nbt.m_128471_("FirstGoldWave");
            this.WildMerchant = nbt.m_128471_("WildMerchant");
            this.WildMerchantPage = nbt.m_128459_("WildMerchantPage");
            this.WildMerchantTab = nbt.m_128461_("WildMerchantTab");
            this.ExecutionerBuff = nbt.m_128471_("ExecutionerBuff");
            this.BuyConfirm = nbt.m_128459_("BuyConfirm");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("the_pumpkin_challenge", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_pumpkin_challenge_mapvars";
        public double IronTierChampionsWaves = 0.0;
        public String IronTierChampions = "\"No champions yet\"";
        public boolean IronArena4 = false;
        public boolean IronArena3 = false;
        public boolean IronArena2 = false;
        public boolean IronArena1 = false;
        public boolean IronArena0 = false;
        public double GoldTierChampionsWaves = 0.0;
        public String GoldTierChampions = "\"No champions yet\"";
        public boolean GoldArena4 = false;
        public boolean GoldArena3 = false;
        public boolean GoldArena2 = false;
        public boolean GoldArena1 = false;
        public boolean GoldArena0 = false;
        public double CopperTierChampionsWaves = 0.0;
        public String CopperTierChampions = "\"No champions yet\"";
        public boolean CopperArena4 = false;
        public boolean CopperArena3 = false;
        public boolean CopperArena2 = false;
        public boolean CopperArena1 = false;
        public boolean CopperArena0 = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.IronTierChampionsWaves = nbt.m_128459_("IronTierChampionsWaves");
            this.IronTierChampions = nbt.m_128461_("IronTierChampions");
            this.IronArena4 = nbt.m_128471_("IronArena4");
            this.IronArena3 = nbt.m_128471_("IronArena3");
            this.IronArena2 = nbt.m_128471_("IronArena2");
            this.IronArena1 = nbt.m_128471_("IronArena1");
            this.IronArena0 = nbt.m_128471_("IronArena0");
            this.GoldTierChampionsWaves = nbt.m_128459_("GoldTierChampionsWaves");
            this.GoldTierChampions = nbt.m_128461_("GoldTierChampions");
            this.GoldArena4 = nbt.m_128471_("GoldArena4");
            this.GoldArena3 = nbt.m_128471_("GoldArena3");
            this.GoldArena2 = nbt.m_128471_("GoldArena2");
            this.GoldArena1 = nbt.m_128471_("GoldArena1");
            this.GoldArena0 = nbt.m_128471_("GoldArena0");
            this.CopperTierChampionsWaves = nbt.m_128459_("CopperTierChampionsWaves");
            this.CopperTierChampions = nbt.m_128461_("CopperTierChampions");
            this.CopperArena4 = nbt.m_128471_("CopperArena4");
            this.CopperArena3 = nbt.m_128471_("CopperArena3");
            this.CopperArena2 = nbt.m_128471_("CopperArena2");
            this.CopperArena1 = nbt.m_128471_("CopperArena1");
            this.CopperArena0 = nbt.m_128471_("CopperArena0");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("IronTierChampionsWaves", this.IronTierChampionsWaves);
            nbt.m_128359_("IronTierChampions", this.IronTierChampions);
            nbt.m_128379_("IronArena4", this.IronArena4);
            nbt.m_128379_("IronArena3", this.IronArena3);
            nbt.m_128379_("IronArena2", this.IronArena2);
            nbt.m_128379_("IronArena1", this.IronArena1);
            nbt.m_128379_("IronArena0", this.IronArena0);
            nbt.m_128347_("GoldTierChampionsWaves", this.GoldTierChampionsWaves);
            nbt.m_128359_("GoldTierChampions", this.GoldTierChampions);
            nbt.m_128379_("GoldArena4", this.GoldArena4);
            nbt.m_128379_("GoldArena3", this.GoldArena3);
            nbt.m_128379_("GoldArena2", this.GoldArena2);
            nbt.m_128379_("GoldArena1", this.GoldArena1);
            nbt.m_128379_("GoldArena0", this.GoldArena0);
            nbt.m_128347_("CopperTierChampionsWaves", this.CopperTierChampionsWaves);
            nbt.m_128359_("CopperTierChampions", this.CopperTierChampions);
            nbt.m_128379_("CopperArena4", this.CopperArena4);
            nbt.m_128379_("CopperArena3", this.CopperArena3);
            nbt.m_128379_("CopperArena2", this.CopperArena2);
            nbt.m_128379_("CopperArena1", this.CopperArena1);
            nbt.m_128379_("CopperArena0", this.CopperArena0);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ThePumpkinChallengeMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_pumpkin_challenge_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ThePumpkinChallengeMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.PumpkinTier = original.PumpkinTier;
            clone.FirstWave = original.FirstWave;
            clone.FirstGoldWave = original.FirstGoldWave;
            clone.WildMerchantPage = original.WildMerchantPage;
            clone.WildMerchantTab = original.WildMerchantTab;
            if (!event.isWasDeath()) {
                clone.ShadowArmor = original.ShadowArmor;
                clone.PumpkinWait = original.PumpkinWait;
                clone.PumpkinOST = original.PumpkinOST;
                clone.PumpkinMusic = original.PumpkinMusic;
                clone.PumpkinBlade = original.PumpkinBlade;
                clone.WildMerchant = original.WildMerchant;
                clone.ExecutionerBuff = original.ExecutionerBuff;
                clone.BuyConfirm = original.BuyConfirm;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ThePumpkinChallengeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ThePumpkinChallengeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ThePumpkinChallengeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

