/*
 * Decompiled with CFR 0.152.
 */
package de.darksmp.simpletimer;

import de.darksmp.simpletimer.TimerManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class TimerCommand
implements CommandExecutor {
    private final TimerManager timer;

    public TimerCommand(TimerManager timer) {
        this.timer = timer;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("simpletimer.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Keine Berechtigung.");
            return true;
        }
        if (args.length == 0) {
            this.help(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "start": {
                this.timer.start();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Timer gestartet.");
                break;
            }
            case "stop": {
                this.timer.stop();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Timer gestoppt.");
                break;
            }
            case "reset": {
                this.timer.reset();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Timer zur\u00fcckgesetzt.");
                break;
            }
            case "mode": 
            case "modus": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Nutze /timer mode <1|2|3>");
                    return true;
                }
                try {
                    TimerManager.Mode newMode;
                    int m = Integer.parseInt(args[1]);
                    switch (m) {
                        case 1: {
                            TimerManager.Mode mode = TimerManager.Mode.UP;
                            break;
                        }
                        case 2: {
                            TimerManager.Mode mode = TimerManager.Mode.DOWN;
                            break;
                        }
                        case 3: {
                            TimerManager.Mode mode = TimerManager.Mode.TIMESTAMP;
                            break;
                        }
                        default: {
                            TimerManager.Mode mode = newMode = null;
                        }
                    }
                    if (newMode == null) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Ung\u00fcltiger Modus.");
                        break;
                    }
                    this.timer.setMode(newMode);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Modus ge\u00e4ndert.");
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Keine g\u00fcltige Zahl.");
                }
                break;
            }
            case "set": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Nutze /timer set <Sekunden|Timestamp>");
                    return true;
                }
                try {
                    long value = Long.parseLong(args[1]);
                    if (this.timer.getMode() == TimerManager.Mode.TIMESTAMP) {
                        this.timer.setTargetTimestamp(value);
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Zielzeit gesetzt.");
                        break;
                    }
                    this.timer.setValue(value);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Timerwert gesetzt.");
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Ung\u00fcltiger Wert.");
                }
                break;
            }
            case "debug": {
                sender.sendMessage("\u00a77[DEBUG] Mode: \u00a7a" + String.valueOf((Object)this.timer.getMode()));
                sender.sendMessage("\u00a77[DEBUG] Zeit: \u00a7a" + this.timer.getTime());
                sender.sendMessage("\u00a77[DEBUG] L\u00e4uft: \u00a7a" + (this.timer.isRunning() ? "ja" : "nein"));
                break;
            }
            default: {
                this.help(sender);
            }
        }
        return true;
    }

    private void help(CommandSender s) {
        s.sendMessage(String.valueOf(ChatColor.AQUA) + "/timer start|stop|reset|mode <1-3>|set <value>");
    }
}

